/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServerConnection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.ui.IEditorInput;
import org.fusesource.ide.camel.model.service.core.io.CamelIOHandler;
import org.fusesource.ide.camel.model.service.core.jmx.camel.IBacklogTracerHeader;
import org.fusesource.ide.camel.model.service.core.jmx.camel.ICamelDebuggerMBeanFacade;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.fusesource.ide.foundation.ui.io.CamelXMLEditorInput;
import org.fusesource.ide.jmx.commons.backlogtracermessage.BacklogTracerEventMessage;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugElement;
import org.fusesource.ide.launcher.debug.model.CamelEndpointBreakpoint;
import org.fusesource.ide.launcher.debug.model.CamelThread;
import org.fusesource.ide.launcher.debug.model.EventDispatchJob;
import org.fusesource.ide.launcher.debug.model.JMXCamelConnectJob;
import org.fusesource.ide.launcher.debug.model.ThreadGarbageCollector;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistry;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;
import org.jboss.tools.jmx.core.IConnectionWrapper;

public class CamelDebugTarget
extends CamelDebugElement
implements IDebugTarget {
    private IProcess fProcess;
    private ILaunch fLaunch;
    private String jmxUri;
    private boolean fTerminated = false;
    private boolean fProcessingActive = true;
    private String fName;
    private String camelContextId;
    private String suspendedNodeId;
    private HashMap<String, CamelThread> threads = new HashMap();
    EventDispatchJob dispatcher;
    ThreadGarbageCollector garbageCollector;
    private JMXCamelConnectJob conJob;
    ICamelDebuggerMBeanFacade debugger;
    private IConnectionWrapper jmxConnectionWrapper;

    public CamelDebugTarget(ILaunch launch, IProcess process, String jmxUri, String jmxUser, String jmxPass) throws CoreException {
        super(null);
        this.fLaunch = launch;
        this.fTarget = this;
        this.fProcess = process;
        this.jmxUri = jmxUri;
        this.initCamelContextId();
        this.scheduleJobs(jmxUser, jmxPass);
        this.registerAsBreakpointListener();
    }

    public CamelDebugTarget(ILaunch launch, IProcess process, IConnectionWrapper jmxConnectionWrapper) throws CoreException {
        super(null);
        this.fLaunch = launch;
        this.fTarget = this;
        this.fProcess = process;
        this.jmxConnectionWrapper = jmxConnectionWrapper;
        this.initCamelContextId();
        this.scheduleJobs();
        this.registerAsBreakpointListener();
    }

    private void scheduleJobs() {
        this.scheduleJMXConnectJob();
        this.scheduleEventDispatcherJob();
        this.scheduleGarbageCollectorJob();
    }

    void registerAsBreakpointListener() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
    }

    void scheduleJobs(String jmxUser, String jmxPass) {
        this.scheduleJMXConnectJob(jmxUser, jmxPass);
        this.scheduleEventDispatcherJob();
        this.scheduleGarbageCollectorJob();
    }

    private void scheduleGarbageCollectorJob() {
        this.garbageCollector = new ThreadGarbageCollector(this);
        this.garbageCollector.schedule();
    }

    private void scheduleEventDispatcherJob() {
        this.dispatcher = new EventDispatchJob(this);
        this.dispatcher.schedule();
    }

    private void scheduleJMXConnectJob() {
        this.conJob = new JMXCamelConnectJob(this);
        this.conJob.schedule();
    }

    private void scheduleJMXConnectJob(String jmxUser, String jmxPass) {
        this.conJob = new JMXCamelConnectJob(this, jmxUser, jmxPass);
        this.conJob.schedule();
    }

    public CamelThread getThreadForId(String uniqueId) {
        CamelThread t;
        if (this.threads.containsKey(uniqueId)) {
            t = this.threads.get(uniqueId);
        } else {
            t = new CamelThread(this, uniqueId);
            this.threads.put(uniqueId, t);
        }
        return t;
    }

    public String getSuspendedNodeId() {
        return this.suspendedNodeId;
    }

    public String generateKey(BacklogTracerEventMessage msg) {
        if (msg == null) {
            return null;
        }
        List headers = msg.getMessage().getHeaders();
        for (IBacklogTracerHeader h : headers) {
            if (!"breadcrumbid".equalsIgnoreCase(h.getKey())) continue;
            return h.getValue();
        }
        return msg.getExchangeId();
    }

    private void initCamelContextId() {
        CamelFile cf;
        File f;
        this.camelContextId = null;
        String filePath = CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(this.getLaunch().getLaunchConfiguration());
        if (filePath != null && (f = new File(filePath)).exists() && f.isFile() && CamelUtils.isCamelContextFile((String)filePath) && (cf = this.loadCamelModelFromFile(f)) != null) {
            this.camelContextId = cf.getRouteContainer().getId();
        }
    }

    protected CamelFile loadCamelModelFromFile(File f) {
        try {
            CamelIOHandler ioHandler = new CamelIOHandler();
            return ioHandler.loadCamelModel(f, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception ex) {
            Activator.getLogger().error("Unable to load Camel context file: " + f.getPath(), (Throwable)ex);
            return null;
        }
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public CamelThread[] getThreads() throws DebugException {
        return this.threads.values().toArray(new CamelThread[this.threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public String getName() {
        if (this.fName == null) {
            this.fName = String.format("Camel Context at %s", this.getJMXDisplayName());
        }
        return this.fName;
    }

    private String getJMXDisplayName() {
        if (this.jmxConnectionWrapper != null) {
            return this.jmxConnectionWrapper.getProvider().getName(this.jmxConnectionWrapper);
        }
        return this.jmxUri;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        String file;
        if (breakpoint.getModelIdentifier().equals("org.fusesource.ide.launcher.debug.camel") && (file = CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(this.getLaunch().getLaunchConfiguration())) != null) {
            File f = new File(file);
            IMarker marker = breakpoint.getMarker();
            if (marker != null && marker.getResource() != null && f.exists()) {
                return f.getPath().equals(marker.getResource().getLocation().toFile().getPath());
            }
        }
        return false;
    }

    @Override
    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean canTerminate() {
        return this.getProcess() != null && !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fTerminated || this.getProcess() != null && this.getProcess().isTerminated();
    }

    public void terminate() throws DebugException {
        this.fTerminated = true;
        this.unregisterBreakpointListener();
        try {
            if (this.conJob != null) {
                this.conJob.cancel();
            }
            if (!this.isDisconnected()) {
                this.disconnect();
            }
            if (this.fProcess != null && !this.fProcess.isTerminated()) {
                this.fProcess.terminate();
            }
        }
        finally {
            this.closeRemoteContextEditor();
            this.fireTerminateEvent();
            this.cleanJobs();
        }
    }

    private void cleanJobs() {
        if (this.conJob != null) {
            this.conJob.cancel();
        }
        if (this.dispatcher != null) {
            this.dispatcher.cancel();
            this.dispatcher = null;
        }
        if (this.garbageCollector != null) {
            this.garbageCollector.cancel();
            this.garbageCollector = null;
        }
    }

    void unregisterBreakpointListener() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended() && !this.isDisconnected();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended() && !this.isDisconnected();
    }

    public boolean isSuspended() {
        return !this.fProcessingActive;
    }

    public void resume() throws DebugException {
        this.fProcessingActive = true;
        if (this.dispatcher == null) {
            this.scheduleEventDispatcherJob();
        }
        if (this.garbageCollector == null) {
            this.scheduleGarbageCollectorJob();
        }
        this.fireResumeEvent(32);
    }

    public void suspend() throws DebugException {
        this.fProcessingActive = false;
        this.fireSuspendEvent(32);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        try {
            if (this.supportsBreakpoint(breakpoint) && breakpoint.isEnabled() && !this.isDisconnected()) {
                String markerType = breakpoint.getMarker().getType();
                if ("org.fusesource.ide.launcher.debug.camel.conditionalbreakpoint.marker".equals(markerType)) {
                    this.debugger.addConditionalBreakpoint(CamelDebugUtils.getEndpointNodeId(breakpoint), CamelDebugUtils.getLanguage(breakpoint), CamelDebugUtils.getCondition(breakpoint));
                } else if ("org.fusesource.ide.launcher.debug.camel.breakpoint.marker".equals(markerType)) {
                    this.debugger.addBreakpoint(CamelDebugUtils.getEndpointNodeId(breakpoint));
                }
            }
        }
        catch (CoreException e) {
            Activator.getLogger().error("Failed to add breakpoint.", (Throwable)e);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint) && !this.isDisconnected()) {
            this.debugger.removeBreakpoint(CamelDebugUtils.getEndpointNodeId(breakpoint));
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled() && this.isBreakpointManagerEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else if (!breakpoint.isEnabled() || !this.isBreakpointManagerEnabled()) {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException e) {
                Activator.getLogger().error("Failed to change breakpoint state.", (Throwable)e);
            }
        }
    }

    protected boolean isBreakpointManagerEnabled() {
        IBreakpointManager bpManager = DebugPlugin.getDefault().getBreakpointManager();
        return bpManager != null && bpManager.isEnabled();
    }

    public boolean canDisconnect() {
        return this.fProcess == null && !this.isDisconnected();
    }

    public void disconnect() throws DebugException {
        if (this.debugger != null) {
            this.debugger.resumeAll();
            this.debugger.disableDebugger();
            for (CamelThread t : this.threads.values()) {
                t.terminate();
            }
            this.debugger = null;
        }
        this.fireTerminateEvent();
        this.cleanJobs();
    }

    public boolean isDisconnected() {
        return this.debugger == null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public void started(boolean createEditorInput) {
        this.fireCreationEvent();
        this.installDeferredBreakpoints();
        if (createEditorInput) {
            this.createRemoteDebugContextEditorInput();
        }
        try {
            this.resume();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    public void resumeAllThreads() {
        try {
            for (CamelThread t : this.threads.values()) {
                t.resume();
            }
            this.resume();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    private void installDeferredBreakpoints() {
        if (this.isBreakpointManagerEnabled()) {
            IBreakpoint[] breakpoints;
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.fusesource.ide.launcher.debug.camel");
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint bp = iBreakpointArray[n2];
                this.installDeferredBreakpoint(bp);
                ++n2;
            }
        }
    }

    private void installDeferredBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint instanceof CamelEndpointBreakpoint) {
            CamelEndpointBreakpoint ceb = (CamelEndpointBreakpoint)breakpoint;
            String fileUnderDebug = CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(this.getLaunch().getLaunchConfiguration());
            IProject p = CamelDebugUtils.getProjectForFilePath(fileUnderDebug);
            if (p.getName().equals(ceb.getProjectName())) {
                this.breakpointAdded(breakpoint);
            }
        }
    }

    public ICamelDebuggerMBeanFacade getDebugger() {
        return this.debugger;
    }

    public String getMessagesForNode(String endpointNodeId) {
        return this.debugger.dumpTracedMessagesAsXml(endpointNodeId);
    }

    void breakpointHit(String nodeId, BacklogTracerEventMessage msg) {
        boolean bpFound = false;
        String id = this.generateKey(msg);
        CamelThread t = this.getThreadForId(id);
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.fusesource.ide.launcher.debug.camel");
        int i = 0;
        while (i < breakpoints.length) {
            CamelEndpointBreakpoint bp;
            IBreakpoint breakpoint = breakpoints[i];
            if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof CamelEndpointBreakpoint && (bp = (CamelEndpointBreakpoint)breakpoint).getEndpointNodeId().equals(nodeId)) {
                t.setBreakpoints(new IBreakpoint[]{breakpoint});
                t.breakpointHit(nodeId, msg);
                this.suspendedNodeId = nodeId;
                bpFound = true;
                break;
            }
            ++i;
        }
        if (!bpFound && this.getThreadForId(this.generateKey(msg)).isStepping()) {
            t.setBreakpoints(new IBreakpoint[0]);
            t.breakpointHit(nodeId, msg);
        }
    }

    private void closeRemoteContextEditor() {
    }

    private void createRemoteDebugContextEditorInput() {
        try {
            String fullPath = CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(this.getLaunch().getLaunchConfiguration());
            IFile contextFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fullPath));
            CamelXMLEditorInput input = new CamelXMLEditorInput(contextFile, this.camelContextId);
            CamelDebugRegistry.getInstance().createEntry(this, this.camelContextId, (IEditorInput)input, this.getLaunch().getLaunchConfiguration());
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    public void updateEditorInput() {
    }

    public void setDebugger(ICamelDebuggerMBeanFacade camelDebugFacade) {
        this.debugger = camelDebugFacade;
    }

    public String getCamelContextId() {
        return this.camelContextId;
    }

    public IConnectionWrapper getJmxConnectionWrapper() {
        return this.jmxConnectionWrapper;
    }

    public String getJmxUri() {
        return this.jmxUri;
    }

    public EventDispatchJob getDispatcher() {
        return this.dispatcher;
    }

    public ThreadGarbageCollector getGarbageCollector() {
        return this.garbageCollector;
    }

    public MBeanServerConnection getMBeanConnection() {
        return this.conJob.getMBeanConnection();
    }
}

