/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.values;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.CamelStackFrame;
import org.fusesource.ide.launcher.debug.model.values.BaseCamelValue;
import org.fusesource.ide.launcher.debug.model.variables.BaseCamelVariable;

public class CamelDebuggerValue
extends BaseCamelValue {
    private List<IVariable> fVariables = new ArrayList<IVariable>();
    private CamelDebugTarget debugTarget;
    private CamelStackFrame stackFrame;

    public CamelDebuggerValue(CamelDebugTarget target, CamelStackFrame stackFrame, Class<?> type) {
        super(target, target != null ? Integer.toString(((Object)((Object)target)).hashCode()) : "", type);
        this.debugTarget = target;
        this.stackFrame = stackFrame;
        try {
            this.init();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    private void init() throws DebugException {
        this.fillFVariables("BodyMaxChars", Integer.toString(this.getBodyMaxChars()));
        this.fillFVariables("BodyIncludeFiles", Boolean.toString(this.isBodyIncludeFiles()));
        this.fillFVariables("BodyIncludeStreams", Boolean.toString(this.isBodyIncludeStreams()));
        this.fillFVariables("DebugCounter", Long.toString(this.getDebugCounter()));
        this.fillFVariables("LogLevel", this.getLogLevel());
    }

    private void fillFVariables(String variableNameProcessorId, String valueString) throws DebugException {
        BaseCamelVariable var = new BaseCamelVariable(this.debugTarget, variableNameProcessorId, String.class);
        BaseCamelValue val = new BaseCamelValue(this.fTarget, valueString, var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return !this.fVariables.isEmpty();
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        return this.fVariables.toArray(new IVariable[this.fVariables.size()]);
    }

    @Override
    protected String getVariableDisplayString() {
        return "CamelDebuggerSettings";
    }

    private String getLogLevel() {
        return this.stackFrame.getDebugger().getLoggingLevel();
    }

    private long getDebugCounter() {
        return this.stackFrame.getDebugger().getDebugCounter();
    }

    private int getBodyMaxChars() {
        return this.stackFrame.getDebugger().getBodyMaxChars();
    }

    private boolean isBodyIncludeFiles() {
        return this.stackFrame.getDebugger().isBodyIncludeFiles();
    }

    private boolean isBodyIncludeStreams() {
        return this.stackFrame.getDebugger().isBodyIncludeStreams();
    }
}

