/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.values;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.fusesource.ide.jmx.commons.backlogtracermessage.BacklogTracerEventMessage;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.values.BaseCamelValue;
import org.fusesource.ide.launcher.debug.model.variables.BaseCamelVariable;

public class CamelExchangeValue
extends BaseCamelValue {
    private BacklogTracerEventMessage exchange;
    private List<IVariable> fVariables = new ArrayList<IVariable>();
    private CamelDebugTarget debugTarget;

    public CamelExchangeValue(CamelDebugTarget target, BacklogTracerEventMessage exchange, Class<?> type) {
        super(target, exchange.getExchangeId(), type);
        this.debugTarget = target;
        this.exchange = exchange;
        try {
            this.initExchange();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    private void initExchange() throws DebugException {
        this.fillfVariables("ExchangeId", String.class, this.exchange.getExchangeId());
        this.fillfVariables("NodeId", String.class, this.exchange.getToNode());
        this.fillfVariables("RouteId", String.class, this.exchange.getRouteId());
        Date timestamp = this.exchange.getTimestamp();
        this.fillfVariables("Timestamp", Date.class, timestamp != null ? String.valueOf(timestamp.getTime()) : null);
        this.fillfVariables("UID", String.class, String.valueOf(this.exchange.getUid()));
    }

    private void fillfVariables(String variableName, Class<?> type, String value) throws DebugException {
        BaseCamelVariable var = new BaseCamelVariable(this.debugTarget, variableName, type);
        BaseCamelValue val = new BaseCamelValue(this.fTarget, value, var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return !this.fVariables.isEmpty();
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        return this.fVariables.toArray(new IVariable[this.fVariables.size()]);
    }

    @Override
    protected String getVariableDisplayString() {
        return "CamelExchange";
    }
}

