/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.values;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.CamelStackFrame;
import org.fusesource.ide.launcher.debug.model.values.BaseCamelValue;
import org.fusesource.ide.launcher.debug.model.variables.BaseCamelVariable;

public class CamelProcessorValue
extends BaseCamelValue {
    private List<IVariable> fVariables = new ArrayList<IVariable>();
    private CamelDebugTarget debugTarget;
    private CamelStackFrame stackFrame;
    private String processorId;

    public CamelProcessorValue(CamelDebugTarget target, CamelStackFrame stackFrame, String value, Class<?> type) {
        super(target, value, type);
        this.debugTarget = target;
        this.stackFrame = stackFrame;
        this.processorId = value;
        try {
            this.init();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    private void init() throws DebugException {
        this.fillFVariables("ProcessorId", this.getValueString());
        this.fillFVariables("RouteId", this.getRouteId());
        this.fillFVariables("CamelId", this.getCamelId());
        this.fillFVariables("CompletedExchanges", Long.toString(this.getExchangesCompleted()));
        this.fillFVariables("FailedExchanges", Long.toString(this.getExchangesFailed()));
        this.fillFVariables("TotalExchanges", Long.toString(this.getTotalExchanges()));
        this.fillFVariables("Redeliveries", Long.toString(this.getRedeliveries()));
        this.fillFVariables("ExternalRedeliveries", Long.toString(this.getExternalRedeliveries()));
        this.fillFVariables("HandledFailures", Long.toString(this.getFailuresHandled()));
        this.fillFVariables("LastProcessingTime", Long.toString(this.getLastProcessingTime()));
        this.fillFVariables("MinProcessingTime", Long.toString(this.getMinProcessingTime()));
        this.fillFVariables("AverageProcessingTime", Long.toString(this.getMeanProcessingTime()));
        this.fillFVariables("MaxProcessingTime", Long.toString(this.getMaxProcessingTime()));
        this.fillFVariables("TotalProcessingTime", Long.toString(this.getTotalProcessingTime()));
    }

    private void fillFVariables(String variableNameProcessorId, String valueString) throws DebugException {
        BaseCamelVariable var = new BaseCamelVariable(this.debugTarget, variableNameProcessorId, String.class);
        BaseCamelValue val = new BaseCamelValue(this.fTarget, valueString, var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return !this.fVariables.isEmpty();
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        return this.fVariables.toArray(new IVariable[this.fVariables.size()]);
    }

    private String getCamelId() {
        return this.stackFrame.getDebugger().getCamelId(this.processorId);
    }

    private String getRouteId() {
        return this.stackFrame.getDebugger().getRouteId(this.processorId);
    }

    private long getExchangesCompleted() {
        return this.stackFrame.getDebugger().getCompletedExchanges(this.processorId);
    }

    private long getExchangesFailed() {
        return this.stackFrame.getDebugger().getFailedExchanges(this.processorId);
    }

    private long getTotalExchanges() {
        return this.stackFrame.getDebugger().getTotalExchanges(this.processorId);
    }

    private long getExternalRedeliveries() {
        return this.stackFrame.getDebugger().getExternalRedeliveries(this.processorId);
    }

    private long getFailuresHandled() {
        return this.stackFrame.getDebugger().getHandledFailures(this.processorId);
    }

    private long getRedeliveries() {
        return this.stackFrame.getDebugger().getRedeliveries(this.processorId);
    }

    private long getLastProcessingTime() {
        return this.stackFrame.getDebugger().getLastProcessingTime(this.processorId);
    }

    private long getMinProcessingTime() {
        return this.stackFrame.getDebugger().getMinProcessingTime(this.processorId);
    }

    private long getMaxProcessingTime() {
        return this.stackFrame.getDebugger().getMaxProcessingTime(this.processorId);
    }

    private long getMeanProcessingTime() {
        return this.stackFrame.getDebugger().getAverageProcessingTime(this.processorId);
    }

    private long getTotalProcessingTime() {
        return this.stackFrame.getDebugger().getTotalProcessingTime(this.processorId);
    }

    @Override
    protected String getVariableDisplayString() {
        return "CamelProcessor";
    }
}

