/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.remote.debug;

import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.util.CamelJMXLaunchConfiguration;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;

public class RemoteCamelLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String LAUNCH_CONFIGURATION_TYPE = "org.fusesource.ide.launcher.camelcontext.remote";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        CamelJMXLaunchConfiguration conf = new CamelJMXLaunchConfiguration(configuration, "service:jmx:rmi:///jndi/rmi://localhost:9011/jmxrmi");
        IDebugTarget target = this.createDebugTarget(configuration, launch, conf);
        launch.addDebugTarget(target);
    }

    private IDebugTarget createDebugTarget(ILaunchConfiguration configuration, ILaunch launch, CamelJMXLaunchConfiguration conf) throws CoreException {
        CamelDebugTarget target;
        String providerId = configuration.getAttribute("org.fusesource.ide.launcher.debug.wrapper.provider.id", "");
        String connectionName = configuration.getAttribute("org.fusesource.ide.launcher.debug.wrapper.connection.name", "");
        if (providerId.isEmpty()) {
            target = new CamelDebugTarget(launch, null, conf.getJMXUrl(), conf.getJMXUser(), conf.getJMXPassword());
        } else {
            IConnectionProvider provider = ExtensionManager.getProvider((String)providerId);
            IConnectionWrapper jmxConnectionWrapper = Stream.of(provider.getConnections()).filter(connection -> connectionName.equals(provider.getName(connection))).findAny().orElseThrow(() -> new CoreException((IStatus)new Status(4, Activator.getBundleID(), "Cannot retrieve the JMX Connection " + connectionName)));
            target = new CamelDebugTarget(launch, null, jmxConnectionWrapper);
        }
        return target;
    }
}

