/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.adopters.configurators;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.fusesource.ide.camel.editor.utils.BuildAndRefreshJobWaiterUtil;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.projecttemplates.adopters.configurators.DefaultTemplateConfigurator;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.CommonNewProjectMetaData;
import org.fusesource.ide.projecttemplates.util.maven.MavenUtils;

public class MavenTemplateConfigurator
extends DefaultTemplateConfigurator {
    public MavenTemplateConfigurator(String bomVersion) {
        super(bomVersion);
    }

    @Override
    public boolean configure(IProject project, CommonNewProjectMetaData metadata, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.mavenTemplateConfiguratorConfiguringTemplatesMonitorMessage, (int)3);
        boolean ok = super.configure(project, metadata, (IProgressMonitor)subMonitor.newChild(1));
        if (ok) {
            ok = this.configureMavenNature(project, (IProgressMonitor)subMonitor.newChild(1));
        }
        if (ok && !Strings.isBlank((String)metadata.getCamelVersion())) {
            ok = MavenUtils.configurePomCamelVersion(project, metadata, metadata.getCamelVersion(), (IProgressMonitor)subMonitor.newChild(1));
        }
        return ok;
    }

    protected boolean configureMavenNature(IProject project, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.mavenTemplateConfiguratorConfiguringMavenNatureMonitorMessage, (int)4);
        try {
            ResolverConfiguration configuration = new ResolverConfiguration();
            configuration.setResolveWorkspaceProjects(true);
            configuration.setSelectedProfiles("");
            new BuildAndRefreshJobWaiterUtil().waitJob((IProgressMonitor)subMonitor.newChild(1));
            IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
            configurationManager.enableMavenNature(project, configuration, (IProgressMonitor)subMonitor.newChild(1));
            configurationManager.updateProjectConfiguration(project, (IProgressMonitor)subMonitor.newChild(1));
            new BuildAndRefreshJobWaiterUtil().waitJob((IProgressMonitor)subMonitor.newChild(1));
        }
        catch (CoreException ex) {
            ProjectTemplatesActivator.pluginLog().logError(ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }
}

