/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.impl.simple;

import java.io.IOException;
import java.io.InputStream;
import org.fusesource.ide.projecttemplates.adopters.AbstractProjectTemplate;
import org.fusesource.ide.projecttemplates.adopters.creators.UnzipStreamCreator;
import org.fusesource.ide.projecttemplates.adopters.util.CamelDSLType;
import org.fusesource.ide.projecttemplates.adopters.util.InvalidProjectMetaDataException;
import org.fusesource.ide.projecttemplates.util.CommonNewProjectMetaData;
import org.fusesource.ide.projecttemplates.util.ICamelDSLTypeSupport;

public abstract class AbstractEAPSpringTemplate
extends AbstractProjectTemplate {
    @Override
    public boolean supportsDSL(CamelDSLType type) {
        switch (type) {
            case BLUEPRINT: {
                return false;
            }
            case SPRING: {
                return true;
            }
            case JAVA: {
                return false;
            }
        }
        return false;
    }

    protected class EAPSpringUnzipTemplateCreator
    extends UnzipStreamCreator {
        private String suffix;
        private static final String TEMPLATE_FOLDER = "templates/";
        private static final String TEMPLATE_SPRING = "template-medium-eap-wildfly-spring-fuse";

        public EAPSpringUnzipTemplateCreator(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public InputStream getTemplateStream(CommonNewProjectMetaData metadata) throws IOException, InvalidProjectMetaDataException {
            if (metadata instanceof ICamelDSLTypeSupport && CamelDSLType.SPRING.equals((Object)((ICamelDSLTypeSupport)((Object)metadata)).getDslType())) {
                return this.getTemplateStream(String.format("%s%s%s.zip", TEMPLATE_FOLDER, TEMPLATE_SPRING, this.suffix));
            }
            throw new InvalidProjectMetaDataException("Invalid project metadata not supporting Camel DSL types");
        }
    }
}

