/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.maven;

import java.util.Arrays;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.fusesource.ide.camel.editor.utils.MavenUtils;
import org.fusesource.ide.camel.model.service.core.util.CamelFilesFinder;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;
import org.fusesource.ide.camel.model.service.core.util.JavaCamelFilesFinder;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.camel.CamelFacetDataModelProvider;
import org.fusesource.ide.projecttemplates.util.camel.CamelFacetVersionChangeDelegate;

public class CamelProjectConfigurator
extends AbstractProjectConfigurator {
    private static final String ARTFIFACT_ID_CAMEL_PREFIX = "camel-";
    private static final String GROUP_ID_ORG_APACHE_CAMEL = "org.apache.camel";
    public static final String WAR_PACKAGE = "WAR";
    public static final String BUNDLE_PACKAGE = "BUNDLE";
    public static final String JAR_PACKAGE = "JAR";
    public static final IProjectFacet camelFacet = ProjectFacetsManager.getProjectFacet((String)"jst.camel");
    public static final IProjectFacet javaFacet = ProjectFacetsManager.getProjectFacet((String)"java");
    public static final IProjectFacet m2eFacet = ProjectFacetsManager.getProjectFacet((String)"jboss.m2");
    public static final IProjectFacet utilFacet = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
    public static final IProjectFacet webFacet = WebFacetUtils.WEB_FACET;
    public static final String DEFAULT_CAMEL_FACET_VERSION = "3.0";

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = event.getMavenProject();
        if (event.getFlags() == 1 && facade != null) {
            IProject project = facade.getProject();
            MavenProject mavenProject = facade.getMavenProject(monitor);
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            if (fproj != null && this.checkCamelContextsExist(project, monitor) && this.isValidCamelFacetCandidate(project)) {
                this.installDefaultFacets(project, mavenProject, fproj, monitor);
            }
        }
        super.mavenProjectChanged(event, monitor);
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        if (this.checkCamelContextsExist(request.getProject(), monitor) && this.isValidCamelFacetCandidate(request.getProject())) {
            if (!this.isCamelFacetEnabled(request)) {
                this.configureFacet(request.getMavenProject(), request.getProject(), monitor);
            }
            if (this.isInvalidCamelFacetVersion(request)) {
                this.repairCamelFacet(request, monitor);
            }
            if (!this.isCamelNatureEnabled(request.getProject())) {
                this.configureNature(request.getProject(), request.getMavenProject(), monitor);
            }
            if (this.isWARProject(request.getProject(), monitor)) {
                this.configureWARStructureMapping(request.getProject(), monitor);
            }
        }
    }

    private void configureWARStructureMapping(IProject project, IProgressMonitor monitor) throws CoreException {
        IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)false);
        c.create(0, monitor);
        IVirtualFolder webroot = c.getRootFolder();
        IVirtualFolder classesFolder = webroot.getFolder("/WEB-INF/classes");
        IMavenProjectFacade m2prj = MavenPlugin.getMavenProjectRegistry().create(project, monitor);
        this.updateMappings(m2prj.getCompileSourceLocations(), project, classesFolder, monitor);
    }

    private void updateMappings(IPath[] paths, IProject project, IVirtualFolder vFolder, IProgressMonitor monitor) throws CoreException {
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath sourceLoc = iPathArray[n2];
            IFolder srcFolder = project.getFolder(sourceLoc);
            IPath absSourcePath = srcFolder.getProjectRelativePath().makeAbsolute();
            IVirtualResource[] mappings = ComponentCore.createResources((IResource)srcFolder);
            boolean found = false;
            IVirtualResource[] iVirtualResourceArray = mappings;
            int n3 = mappings.length;
            int n4 = 0;
            while (n4 < n3) {
                IVirtualResource mapping = iVirtualResourceArray[n4];
                if (mapping.getProjectRelativePath().equals((Object)absSourcePath)) {
                    mapping.createLink(absSourcePath, 0, monitor);
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                vFolder.createLink(absSourcePath, 0, monitor);
            } else {
                this.removeRedundantMappingToRootRuntimePath(monitor, absSourcePath, mappings);
            }
            ++n2;
        }
    }

    private void removeRedundantMappingToRootRuntimePath(IProgressMonitor monitor, IPath absSourcePath, IVirtualResource[] mappings) {
        Arrays.stream(mappings).filter(mapping -> mapping.getProjectRelativePath().equals((Object)absSourcePath)).filter(mapping -> "/".equals(mapping.getRuntimePath().toPortableString())).forEach(mapping -> {
            try {
                mapping.delete(1024, monitor);
            }
            catch (CoreException e) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)e);
            }
        });
    }

    private boolean isWARProject(IProject project, IProgressMonitor monitor) {
        IMavenProjectFacade m2prj = MavenPlugin.getMavenProjectRegistry().create(project, monitor);
        return WAR_PACKAGE.equalsIgnoreCase(m2prj.getPackaging());
    }

    private boolean isInvalidCamelFacetVersion(ProjectConfigurationRequest request) throws CoreException {
        IProject project = request.getProject();
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        if (fproj != null) {
            return fproj.getInstalledVersion(camelFacet).getVersionString().compareTo(DEFAULT_CAMEL_FACET_VERSION) < 0;
        }
        return true;
    }

    private void repairCamelFacet(ProjectConfigurationRequest request, IProgressMonitor mon) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)mon, (int)3);
        IProject project = request.getProject();
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        if (fproj != null) {
            IProjectFacetVersion oldfv = fproj.getInstalledVersion(camelFacet);
            fproj.uninstallProjectFacet(oldfv, null, (IProgressMonitor)subMon.split(1));
            IFacetedProjectWorkingCopy fpwc = fproj.createWorkingCopy();
            this.installCamelFacet(fproj, fpwc, (IProgressMonitor)subMon.split(1));
            fpwc.commitChanges((IProgressMonitor)subMon.split(1));
        }
    }

    private boolean isCamelFacetEnabled(ProjectConfigurationRequest request) throws CoreException {
        IProject project = request.getProject();
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        if (fproj != null) {
            Set facets = fproj.getProjectFacets();
            for (IProjectFacetVersion f : facets) {
                if (!"jst.camel".equals(f.getProjectFacet().getId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCamelNatureEnabled(IProject project) throws CoreException {
        IProjectDescription projectDescription = project.getDescription();
        String[] ids = projectDescription.getNatureIds();
        return Arrays.stream(ids).anyMatch("org.fusesource.ide.project.RiderProjectNature"::equals);
    }

    private void configureNature(IProject project, MavenProject m2Project, IProgressMonitor monitor) throws CoreException {
        boolean hasCamelDeps = this.checkCamelDependencies(m2Project);
        boolean hasCamelContextXML = false;
        if (!hasCamelDeps) {
            hasCamelContextXML = this.checkCamelContextsExist(project, monitor);
        }
        if (hasCamelDeps || hasCamelContextXML) {
            CamelProjectConfigurator.addNature((IProject)project, (String)"org.fusesource.ide.project.RiderProjectNature", (IProgressMonitor)monitor);
        }
    }

    private void configureFacet(MavenProject mavenProject, IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.configuringFacets, (int)4);
        if (!this.checkCamelContextsExist(project, (IProgressMonitor)subMonitor.split(1))) {
            subMonitor.setWorkRemaining(0);
            return;
        }
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)subMonitor.split(1));
        if (fproj == null) {
            WtpUtils.addNatures((IProject)project);
            CamelProjectConfigurator.addNature((IProject)project, (String)"org.eclipse.wst.common.project.facet.core.nature", (IProgressMonitor)subMonitor.split(1));
            fproj = ProjectFacetsManager.create((IProject)project);
        }
        subMonitor.setWorkRemaining(1);
        if (fproj != null) {
            this.installDefaultFacets(project, mavenProject, fproj, (IProgressMonitor)subMonitor.split(1));
        }
        subMonitor.setWorkRemaining(0);
    }

    private void installDefaultFacets(IProject project, MavenProject mavenProject, IFacetedProject fproj, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.installingRequiredFacetsForCamelProject, (int)4);
        String camelVersion = new CamelMavenUtils().getCamelVersionFromMaven(project, false);
        subMonitor.setWorkRemaining(3);
        if (camelVersion != null) {
            IFacetedProjectWorkingCopy fpwc = fproj.createWorkingCopy();
            this.installFacet(fproj, fpwc, javaFacet, javaFacet.getLatestVersion());
            this.installFacet(fproj, fpwc, m2eFacet, m2eFacet.getLatestVersion());
            if (mavenProject.getPackaging() != null) {
                String packaging = mavenProject.getPackaging();
                if (WAR_PACKAGE.equalsIgnoreCase(packaging)) {
                    this.installFacet(fproj, fpwc, webFacet, javaFacet.getLatestVersion());
                } else if (BUNDLE_PACKAGE.equalsIgnoreCase(packaging) || JAR_PACKAGE.equalsIgnoreCase(packaging)) {
                    this.installFacet(fproj, fpwc, utilFacet, utilFacet.getLatestVersion());
                }
            }
            this.installCamelFacet(fproj, fpwc, (IProgressMonitor)subMonitor.split(1));
            fpwc.commitChanges((IProgressMonitor)subMonitor.split(1));
            this.configureNature(project, mavenProject, (IProgressMonitor)subMonitor.split(1));
            this.updateMavenProject(project);
        }
    }

    private void updateMavenProject(IProject project) {
        if (project != null) {
            UpdateMavenProjectJob updateJob = new UpdateMavenProjectJob(new IProject[]{project});
            updateJob.schedule();
        }
    }

    private void installCamelFacet(IFacetedProject fproj, IFacetedProjectWorkingCopy fpwc, IProgressMonitor monitor) throws CoreException {
        IDataModel config = (IDataModel)new CamelFacetDataModelProvider().create();
        config.setBooleanProperty("camel.project.structure.update", false);
        this.installFacet(fproj, fpwc, camelFacet, this.getCamelFacetVersion());
        CamelFacetVersionChangeDelegate del = new CamelFacetVersionChangeDelegate();
        del.execute(fproj.getProject(), this.getCamelFacetVersion(), config, monitor);
    }

    private IProjectFacetVersion getCamelFacetVersion() throws CoreException {
        try {
            IProjectFacetVersion facetVersion = camelFacet.getVersion(DEFAULT_CAMEL_FACET_VERSION);
            if (facetVersion != null) {
                return facetVersion;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return camelFacet.getLatestVersion();
        }
        return camelFacet.getLatestVersion();
    }

    private boolean isValidCamelFacetCandidate(IProject project) {
        return !new MavenUtils().isSyndesisExtensionProject(project);
    }

    private boolean checkCamelContextsExist(IProject project, IProgressMonitor monitor) {
        return !new CamelFilesFinder().findFiles((IResource)project).isEmpty() || new JavaCamelFilesFinder().findJavaDSLRouteBuilderClass(project, monitor) != null;
    }

    private void installFacet(IFacetedProject fproj, IFacetedProjectWorkingCopy fpwc, IProjectFacet facet, IProjectFacetVersion facetVersion) {
        if (facet != null && !fproj.hasProjectFacet(facet)) {
            fpwc.addProjectFacet(facetVersion);
        } else {
            IProjectFacetVersion f = fproj.getProjectFacetVersion(facet);
            if (!f.getVersionString().equals(facetVersion.getVersionString())) {
                fpwc.changeProjectFacetVersion(facetVersion);
            }
        }
    }

    private boolean checkCamelDependencies(MavenProject m2Project) {
        return m2Project.getDependencies().stream().anyMatch(this::isCamelDependency);
    }

    private boolean isCamelDependency(Dependency dep) {
        return GROUP_ID_ORG_APACHE_CAMEL.equals(dep.getGroupId()) && dep.getArtifactId().startsWith(ARTFIFACT_ID_CAMEL_PREFIX);
    }
}

