/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.model.GlobalPreferences;
import org.eclipse.wst.validation.internal.model.GlobalPreferencesValues;
import org.fusesource.ide.camel.editor.utils.BuildAndRefreshJobWaiterUtil;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCacheManager;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.foundation.core.util.VersionUtil;
import org.fusesource.ide.projecttemplates.adopters.AbstractProjectTemplate;
import org.fusesource.ide.projecttemplates.impl.simple.EmptyProjectTemplateForFuse6;
import org.fusesource.ide.projecttemplates.impl.simple.EmptyProjectTemplateForFuse7;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.BasicProjectCreator;
import org.fusesource.ide.projecttemplates.util.CommonNewProjectMetaData;

public abstract class BasicProjectCreatorRunnable
implements IRunnableWithProgress {
    protected CommonNewProjectMetaData metadata;

    public BasicProjectCreatorRunnable(CommonNewProjectMetaData metadata) {
        this.metadata = metadata;
    }

    public boolean shouldPreloadCatalog() {
        return true;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        boolean oldValueForValidation = this.disableGlobalValidationDuringProjectCreation();
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.basicProjectCreatorRunnableCreatingTheProjectMonitorMessage, (int)8);
            CamelModelServiceCoreActivator.getProjectClasspathChangeListener().deactivate();
            BasicProjectCreator c = new BasicProjectCreator(this.metadata);
            boolean ok = c.create((IProgressMonitor)subMonitor.split(1));
            IProject prj = c.getProject();
            if (ok) {
                AbstractProjectTemplate template = this.retrieveTemplate();
                try {
                    template.create(prj, this.metadata, (IProgressMonitor)subMonitor.split(1));
                }
                catch (CoreException ex) {
                    ProjectTemplatesActivator.pluginLog().logError("Unable to create project...", (Throwable)ex);
                }
            }
            if (this.requiresFuseIntegrationPerspective()) {
                boolean switchPerspective;
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IPerspectiveDescriptor finalPersp = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("org.fusesource.ide.branding.perspective");
                IPerspectiveDescriptor currentPersp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
                boolean bl = switchPerspective = currentPersp.getId().equals(finalPersp.getId()) ? false : this.confirmPerspectiveSwitch(workbenchWindow, finalPersp);
                if (switchPerspective) {
                    this.switchToFusePerspective(workbenchWindow);
                }
            }
            subMonitor.setWorkRemaining(5);
            try {
                prj.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
            }
            catch (CoreException ex) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            }
            this.doAdditionalProjectConfiguration(prj, (IProgressMonitor)subMonitor.split(1));
            if (this.shouldPreloadCatalog()) {
                CamelCatalogCacheManager.getInstance().getCamelModelForProject(prj, (IProgressMonitor)subMonitor.split(1, 0));
            }
            subMonitor.setWorkRemaining(2);
            this.openRequiredFilesInEditor(prj, (IProgressMonitor)subMonitor.split(1));
            new BuildAndRefreshJobWaiterUtil().waitJob((IProgressMonitor)subMonitor.split(1));
        }
        finally {
            this.setbackValidationValueAfterProjectCreation(oldValueForValidation);
            CamelModelServiceCoreActivator.getProjectClasspathChangeListener().activate();
        }
    }

    protected void openRequiredFilesInEditor(IProject prj, IProgressMonitor monitor) {
    }

    protected void doAdditionalProjectConfiguration(IProject prj, IProgressMonitor monitor) {
        IResource rs = prj.findMember("src/META-INF/");
        if (rs != null && rs.exists()) {
            try {
                rs.delete(true, monitor);
            }
            catch (CoreException ex) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            }
        }
    }

    protected boolean requiresFuseIntegrationPerspective() {
        return true;
    }

    protected void setbackValidationValueAfterProjectCreation(boolean oldValueForValidation) {
        GlobalPreferencesValues globalPreferencesAsValues = ValManager.getDefault().getGlobalPreferences().asValues();
        globalPreferencesAsValues.disableAllValidation = oldValueForValidation;
        ValManager.getDefault().replace(globalPreferencesAsValues);
    }

    protected boolean disableGlobalValidationDuringProjectCreation() {
        GlobalPreferences globalPreferences = ValManager.getDefault().getGlobalPreferences();
        GlobalPreferencesValues globalPreferencesAsValues = globalPreferences.asValues();
        boolean oldValueForValidation = globalPreferencesAsValues.disableAllValidation;
        globalPreferencesAsValues.disableAllValidation = true;
        ValManager.getDefault().replace(globalPreferencesAsValues);
        return oldValueForValidation;
    }

    void switchToFusePerspective(IWorkbenchWindow workbenchWindow) {
        IPerspectiveDescriptor activePerspective = workbenchWindow.getActivePage().getPerspective();
        if (activePerspective == null || !"org.fusesource.ide.branding.perspective".equals(activePerspective.getId())) {
            workbenchWindow.getShell().getDisplay().syncExec(() -> {
                try {
                    workbenchWindow.getWorkbench().showPerspective("org.fusesource.ide.branding.perspective", workbenchWindow);
                }
                catch (WorkbenchException e) {
                    ProjectTemplatesActivator.pluginLog().logError((Throwable)e);
                }
            });
        }
    }

    private boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(pspm)) {
            return "always".equals(pspm);
        }
        String desc = finalPersp.getDescription();
        String message = desc == null || desc.length() == 0 ? NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessage, (Object)finalPersp.getLabel()) : NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessageWithDesc, (Object[])new String[]{finalPersp.getLabel(), desc});
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ResourceMessages.NewProject_perspSwitchTitle, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", preferenceValue);
        }
        return result == 2;
    }

    protected AbstractProjectTemplate retrieveTemplate() {
        if (this.metadata.getTemplate() == null) {
            if (new VersionUtil().isStrictlyLowerThan2200(this.metadata.getCamelVersion())) {
                return new EmptyProjectTemplateForFuse6();
            }
            return new EmptyProjectTemplateForFuse7();
        }
        return this.metadata.getTemplate();
    }
}

