/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.fusesource.ide.camel.model.service.core.CamelServiceManagerUtil;
import org.fusesource.ide.projecttemplates.actions.ui.UnknownTimeMonitorUpdater;
import org.fusesource.ide.projecttemplates.internal.Messages;

public class CamelVersionChecker
implements IRunnableWithProgress {
    private String camelVersionToValidate;
    private boolean valid;
    private boolean done;
    private UnknownTimeMonitorUpdater unknownTimeMonitorUpdater;

    public CamelVersionChecker(String camelVersionToValidate) {
        this.camelVersionToValidate = camelVersionToValidate;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.validatingCamelVersionMessage, (Object)this.camelVersionToValidate), (int)1);
        this.unknownTimeMonitorUpdater = new UnknownTimeMonitorUpdater(subMonitor);
        try {
            new Thread(this.unknownTimeMonitorUpdater).start();
            this.valid = this.isCamelVersionValid(this.camelVersionToValidate);
            subMonitor.setWorkRemaining(0);
        }
        finally {
            this.unknownTimeMonitorUpdater.finish();
        }
        this.done = true;
    }

    public void cancel() {
        this.unknownTimeMonitorUpdater.cancel();
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isValid() {
        return this.valid;
    }

    public synchronized boolean isCamelVersionValid(String camelVersion) {
        boolean versionValid = false;
        if (camelVersion != null) {
            versionValid = CamelServiceManagerUtil.getManagerService().isCamelVersionExisting(camelVersion);
        }
        return versionValid;
    }
}

