/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.fuse.core.runtime;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.server.karaf.core.runtime.KarafRuntimeDelegate;

public class FuseESBRuntimeDelegate
extends KarafRuntimeDelegate {
    public IStatus validate() {
        return this.validateRuntimeAndVersion(this.getRuntime().getRuntimeType().getId(), this.getVersion());
    }

    protected IStatus validateRuntimeAndVersion(String runtimeId, String runtimeVersion) {
        if (Strings.isBlank((String)runtimeVersion)) {
            return new Status(4, "org.fusesource.ide.server.fuse.core", "Empty runtime version found for runtime " + runtimeId + "...");
        }
        String versionStartString = this.getMajorMinorString(runtimeVersion);
        if (!runtimeId.toLowerCase().endsWith(String.format("fuseesb.runtime.%s", versionStartString)) && !this.isNewerUnsupportedVersion(runtimeVersion)) {
            return new Status(4, "org.fusesource.ide.server.fuse.core", "Runtime type " + runtimeId + " is not compatible with found version " + runtimeVersion);
        }
        return Status.OK_STATUS;
    }

    public IExecutionEnvironment getMinimumExecutionEnvironment() {
        if (this.getRuntime().getRuntimeType().getVersion().startsWith("7.")) {
            return JavaRuntime.getExecutionEnvironmentsManager().getEnvironment("JavaSE-1.8");
        }
        return JavaRuntime.getExecutionEnvironmentsManager().getEnvironment("JavaSE-1.7");
    }
}

