/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.bean;

import java.io.File;
import org.fusesource.ide.server.karaf.core.bean.BaseKarafServerTypeCondition;
import org.jboss.ide.eclipse.as.core.server.bean.ICondition;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;

public class ServerBeanTypeKaraf3x
extends ServerBeanType {
    private static final String KARAF3x_RELEASE_VERSION = "Bundle-Version";
    public static final String V3_0 = "3.0";
    public static final String V3_x = "3.";

    protected ServerBeanTypeKaraf3x() {
        super("KARAF3x", "Apache Karaf 3.x", "lib" + File.separator + "karaf.jar", (ICondition)new Karaf3xServerTypeCondition());
    }

    public static class Karaf3xServerTypeCondition
    extends BaseKarafServerTypeCondition {
        public boolean isServerRoot(File location) {
            return Karaf3xServerTypeCondition.checkKarafVersion(location, ServerBeanTypeKaraf3x.KARAF3x_RELEASE_VERSION, ServerBeanTypeKaraf3x.V3_x) && !Karaf3xServerTypeCondition.isIntegratedKaraf(location);
        }

        protected static boolean checkKarafVersion(File location, String property, String propPrefix) {
            String mainFolder = new ServerBeanTypeKaraf3x().getSystemJarPath();
            String value = ServerBeanTypeKaraf3x.getJarProperty((File)new File(location + File.separator + mainFolder), (String)property);
            return value != null && value.startsWith(propPrefix);
        }

        public String getServerTypeId(String version) {
            if (version.equals(ServerBeanTypeKaraf3x.V3_0)) {
                return "org.fusesource.ide.karaf.server.30";
            }
            if (version.startsWith(ServerBeanTypeKaraf3x.V3_x)) {
                return "org.fusesource.ide.karaf.server.30";
            }
            return null;
        }
    }
}

