/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.publish.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.publish.IPublishBehaviour;
import org.fusesource.ide.server.karaf.core.publish.jmx.IJMXPublishBehaviour;
import org.fusesource.ide.server.karaf.core.publish.jmx.KarafBundleMBeanPublishBehaviour;
import org.fusesource.ide.server.karaf.core.publish.jmx.KarafBundlesMBeanPublishBehaviour;
import org.fusesource.ide.server.karaf.core.publish.jmx.OSGIMBeanPublishBehaviour;
import org.fusesource.ide.server.karaf.core.server.KarafServerDelegate;
import org.fusesource.ide.server.karaf.core.util.KarafUtils;

public class KarafJMXPublisher
implements IPublishBehaviour {
    private static final ArrayList<IJMXPublishBehaviour> KNOWN_JMX_BEHAVIOURS = new ArrayList();
    protected JMXServiceURL url;
    protected JMXConnector jmxc;
    protected MBeanServerConnection mbsc;
    protected IServer server;
    protected IJMXPublishBehaviour jmxPublisher;

    static {
        KNOWN_JMX_BEHAVIOURS.add(new KarafBundleMBeanPublishBehaviour());
        KNOWN_JMX_BEHAVIOURS.add(new KarafBundlesMBeanPublishBehaviour());
        KNOWN_JMX_BEHAVIOURS.add(new OSGIMBeanPublishBehaviour());
    }

    protected boolean connect(IServer server) {
        this.server = server;
        KarafServerDelegate del = (KarafServerDelegate)server.loadAdapter(KarafServerDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        HashMap<String, String[]> envMap = new HashMap<String, String[]>();
        envMap.put("jmx.remote.credentials", new String[]{del.getUserName(), del.getPassword()});
        try {
            String conUrl = KarafUtils.getJMXConnectionURL(server);
            this.url = new JMXServiceURL(conUrl);
            this.jmxc = JMXConnectorFactory.connect(this.url, envMap);
            this.mbsc = this.jmxc.getMBeanServerConnection();
            this.jmxPublisher = this.findCompatiblePublisher(this.mbsc);
            return this.jmxPublisher != null;
        }
        catch (IOException ex) {
            Activator.getLogger().error((Throwable)ex);
            return false;
        }
    }

    private IJMXPublishBehaviour findCompatiblePublisher(MBeanServerConnection mbsc) {
        for (IJMXPublishBehaviour pb : KNOWN_JMX_BEHAVIOURS) {
            if (!pb.canHandle(mbsc)) continue;
            return pb;
        }
        Activator.getLogger().error("No compatible JMX publisher has been found. Please check that your server has started and is accessible by JMX.");
        return null;
    }

    protected boolean disconnect(IServer server) {
        try {
            if (this.jmxc != null) {
                this.jmxc.close();
            }
            return true;
        }
        catch (IOException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        finally {
            this.jmxc = null;
            this.mbsc = null;
            this.url = null;
        }
        return false;
    }

    @Override
    public int publish(IServer server, IModule[] module, String symbolicName, String version, IPath file) {
        this.ensureActiveConnection(server);
        try {
            long bundleId = this.jmxPublisher.getBundleId(this.mbsc, symbolicName, version);
            if (bundleId != -1L) {
                this.reinstallBundle(server, bundleId, file);
            } else {
                bundleId = this.installBundle(server, file);
            }
            if (bundleId != -1L) {
                int n = this.jmxPublisher.getBundleStatus(this.mbsc, bundleId);
                return n;
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        finally {
            this.disconnect(server);
        }
        return 0;
    }

    private void ensureActiveConnection(IServer server) {
        if (!this.isInActiveState()) {
            this.connect(server);
        }
    }

    private boolean isInActiveState() {
        return this.jmxc != null && this.jmxPublisher != null && this.mbsc != null;
    }

    @Override
    public boolean uninstall(IServer server, IModule[] module, String symbolicName, String version) {
        this.ensureActiveConnection(server);
        boolean unpublished = false;
        try {
            try {
                IProject project = module[0].getProject();
                if (project != null) {
                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                long bundleId = -1L;
                if (symbolicName != null && version != null && (bundleId = this.jmxPublisher.getBundleId(this.mbsc, symbolicName, version.replaceAll("qualifier", ""))) == -1L) {
                    bundleId = this.jmxPublisher.getBundleId(this.mbsc, symbolicName, null);
                }
                if (bundleId != -1L) {
                    unpublished = this.jmxPublisher.uninstallBundle(this.mbsc, bundleId);
                }
            }
            catch (Exception ex) {
                Activator.getLogger().error((Throwable)ex);
                this.disconnect(server);
            }
        }
        finally {
            this.disconnect(server);
        }
        return unpublished;
    }

    private boolean reinstallBundle(IServer server, long bundleId, IPath file) throws CoreException {
        if (file != null) {
            return this.jmxPublisher.updateBundle(this.mbsc, bundleId, file.toOSString());
        }
        return false;
    }

    private long installBundle(IServer server, IPath file) throws CoreException {
        if (file != null) {
            long bundleId = this.jmxPublisher.installBundle(this.mbsc, file.toOSString().replace("file:", ""));
            return bundleId;
        }
        return -1L;
    }
}

