/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.runtime;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.RuntimeDelegate;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.server.karaf.core.runtime.IKarafRuntimeWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBean;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.wtp.core.util.VMInstallUtil;
import org.osgi.framework.Version;

public class KarafRuntimeDelegate
extends RuntimeDelegate
implements IKarafRuntimeWorkingCopy {
    private static String PROPERTY_VM_ID = "PROPERTY_VM_ID";
    private static String PROPERTY_VM_TYPE_ID = "PROPERTY_VM_TYPE_ID";
    private static String PROPERTY_EXECUTION_ENVIRONMENT = "PROPERTY_EXEC_ENVIRONMENT";

    public void setDefaults(IProgressMonitor monitor) {
        this.getRuntimeWorkingCopy().setName(this.getNextRuntimeName());
        this.setVM(null);
    }

    protected String getNextRuntimeName() {
        return KarafRuntimeDelegate.getNextRuntimeName(this.getRuntimeNameBase());
    }

    protected String getRuntimeNameBase() {
        return String.valueOf(this.getRuntime().getRuntimeType().getName()) + " Runtime";
    }

    public static String getNextRuntimeName(String base) {
        IRuntime rt = ServerCore.findRuntime((String)base);
        if (rt == null) {
            return base;
        }
        int i = 0;
        while (rt != null) {
            rt = ServerCore.findRuntime((String)(String.valueOf(base) + " " + ++i));
        }
        return String.valueOf(base) + " " + i;
    }

    @Override
    public String getVersion() {
        IPath loc = this.getRuntime().getLocation();
        ServerBean sb = new ServerBeanLoader(loc.toFile()).getServerBean();
        if (sb != null) {
            return sb.getFullVersion();
        }
        return null;
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        String id = this.getRuntime().getRuntimeType().getId();
        String version = this.getVersion();
        return this.validateRuntimeAndVersion(id, version);
    }

    protected IStatus validateRuntimeAndVersion(String runtimeId, String runtimeVersion) {
        if (Strings.isBlank((String)runtimeVersion)) {
            return new Status(4, "org.fusesource.ide.server.karaf.core", "Empty runtime version found for runtime " + runtimeId + "...");
        }
        String versionStartString = this.getMajorMinorString(runtimeVersion);
        if (!runtimeId.toLowerCase().endsWith(String.format("karaf.runtime.%s", versionStartString)) && !this.isNewerUnsupportedVersion(runtimeVersion)) {
            return new Status(4, "org.fusesource.ide.server.karaf.core", "Runtime type " + runtimeId + " is not compatible with found version " + runtimeVersion);
        }
        return Status.OK_STATUS;
    }

    protected boolean isNewerUnsupportedVersion(String runtimeVersion) {
        Version foundVersion = Version.parseVersion((String)runtimeVersion);
        Version rtVersion = Version.parseVersion((String)this.getRuntime().getRuntimeType().getVersion());
        return foundVersion.getMajor() == rtVersion.getMajor() && foundVersion.compareTo(rtVersion) > 0;
    }

    protected String getMajorMinorString(String runtimeVersion) {
        int pos = runtimeVersion.indexOf(46);
        pos = runtimeVersion.indexOf(46, pos + 1);
        return runtimeVersion.substring(0, pos).replaceAll("\\.", "");
    }

    @Override
    public IExecutionEnvironment getExecutionEnvironment() {
        String id = this.getAttribute(PROPERTY_EXECUTION_ENVIRONMENT, null);
        return id == null ? this.getMinimumExecutionEnvironment() : JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(id);
    }

    @Override
    public IExecutionEnvironment getMinimumExecutionEnvironment() {
        return JavaRuntime.getExecutionEnvironmentsManager().getEnvironment("JavaSE-1.7");
    }

    @Override
    public void setExecutionEnvironment(IExecutionEnvironment environment) {
        this.setAttribute(PROPERTY_EXECUTION_ENVIRONMENT, environment == null ? null : environment.getId());
    }

    public IVMInstall getHardVM() {
        if (this.getAttribute(PROPERTY_VM_TYPE_ID, null) != null) {
            String id = this.getAttribute(PROPERTY_VM_ID, null);
            String type = this.getAttribute(PROPERTY_VM_TYPE_ID, null);
            return VMInstallUtil.findVMInstall((String)type, (String)id);
        }
        return null;
    }

    @Override
    public IVMInstall getVM() {
        IVMInstall hard = this.getHardVM();
        if (hard == null) {
            return VMInstallUtil.findVMInstall((IExecutionEnvironment)this.getExecutionEnvironment());
        }
        return hard;
    }

    @Override
    public void setVM(IVMInstall selectedVM) {
        if (selectedVM == null) {
            this.setAttribute(PROPERTY_VM_ID, null);
            this.setAttribute(PROPERTY_VM_TYPE_ID, null);
        } else {
            this.setAttribute(PROPERTY_VM_ID, selectedVM.getId());
            this.setAttribute(PROPERTY_VM_TYPE_ID, selectedVM.getVMInstallType().getId());
        }
    }

    @Override
    public boolean isUsingDefaultJRE() {
        return this.getAttribute(PROPERTY_VM_TYPE_ID, null) == null;
    }

    @Override
    public IVMInstall[] getValidJREs() {
        return this.getExecutionEnvironment() == null ? new IVMInstall[]{} : this.getExecutionEnvironment().getCompatibleVMs();
    }

    @Override
    public IPath getLocation() {
        return this.getRuntime().getLocation();
    }
}

