/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.runtime.integration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.fusesource.ide.server.karaf.core.Messages;
import org.jboss.jdf.stacks.model.Runtime;
import org.jboss.jdf.stacks.model.Stacks;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.core.model.IDownloadRuntimesProvider;

public abstract class AbstractStacksDownloadRuntimesProvider
implements IDownloadRuntimesProvider {
    public static final String LABEL_FILE_SIZE = "runtime-size";
    public static final String LABEL_WTP_RUNTIME = "wtp-runtime-type";
    public static final String LABEL_RUNTIME_CATEGORY = "runtime-category";
    public static final String LABEL_RUNTIME_TYPE = "runtime-type";
    public static final String PROP_WTP_RUNTIME = "wtp-runtime-type";
    private ArrayList<DownloadRuntime> downloads = null;

    protected abstract Stacks[] getStacks(IProgressMonitor var1);

    public DownloadRuntime[] getDownloadableRuntimes(String requestType, IProgressMonitor monitor) {
        if (this.downloads == null) {
            ArrayList<DownloadRuntime> tmp = this.loadDownloadableRuntimes(monitor);
            if (monitor.isCanceled()) {
                return tmp.toArray(new DownloadRuntime[tmp.size()]);
            }
            this.downloads = tmp;
        }
        return this.downloads.toArray(new DownloadRuntime[this.downloads.size()]);
    }

    private synchronized ArrayList<DownloadRuntime> loadDownloadableRuntimes(IProgressMonitor monitor) {
        monitor.beginTask(Messages.LoadRemoteRuntimes, 200);
        Stacks[] stacksArr = this.getStacks((IProgressMonitor)new SubProgressMonitor(monitor, 100));
        ArrayList<DownloadRuntime> all = new ArrayList<DownloadRuntime>();
        monitor.beginTask(Messages.CreateDownloadRuntimes, stacksArr.length * 100);
        int i = 0;
        while (i < stacksArr.length && !monitor.isCanceled()) {
            SubProgressMonitor inner = new SubProgressMonitor(monitor, 100);
            if (stacksArr[i] != null) {
                this.traverseStacks(stacksArr[i], all, (IProgressMonitor)inner);
            }
            ++i;
        }
        monitor.done();
        return all;
    }

    protected abstract void traverseStacks(Stacks var1, ArrayList<DownloadRuntime> var2, IProgressMonitor var3);

    protected void traverseStacks(Stacks stacks, ArrayList<DownloadRuntime> list, String category, IProgressMonitor monitor) {
        List runtimes = stacks.getAvailableRuntimes();
        Iterator i = runtimes.iterator();
        monitor.beginTask(Messages.CreateDownloadRuntimes, runtimes.size() * 100);
        while (i.hasNext()) {
            String wtpRT;
            Runtime workingRT = (Runtime)i.next();
            String categoryFromStacks = workingRT.getLabels().getProperty(LABEL_RUNTIME_CATEGORY);
            if (category.equals(categoryFromStacks) && (wtpRT = workingRT.getLabels().getProperty("wtp-runtime-type")) != null) {
                String fileSize = workingRT.getLabels().getProperty(LABEL_FILE_SIZE);
                String license = workingRT.getLicense();
                String dlUrl = this.getDownloadURL(workingRT);
                String id = workingRT.getId();
                String legacyId = this.getLegacyId(id);
                String effectiveId = legacyId == null ? id : legacyId;
                String name = workingRT.getName();
                String version = workingRT.getVersion();
                DownloadRuntime dr = new DownloadRuntime(effectiveId, name, version, dlUrl);
                dr.setDisclaimer(!wtpRT.startsWith("org.jboss.ide.eclipse.as.runtime.eap."));
                dr.setHumanUrl(workingRT.getUrl());
                dr.setLicenseURL(license);
                dr.setSize(fileSize);
                dr.setProperty("wtp-runtime-type", (Object)wtpRT);
                dr.setProperty(LABEL_RUNTIME_CATEGORY, (Object)category);
                dr.setProperty(LABEL_RUNTIME_TYPE, (Object)workingRT.getLabels().getProperty(LABEL_RUNTIME_TYPE));
                if (workingRT.getLabels().get("requiresCredentials") != null) {
                    dr.setProperty("requiresCredentials", workingRT.getLabels().get("requiresCredentials"));
                }
                if (legacyId != null) {
                    dr.setProperty("PROPERTY_ALTERNATE_ID", (Object)id);
                }
                list.add(dr);
            }
            monitor.worked(100);
        }
        monitor.done();
    }

    protected String getDownloadURL(Runtime workingRT) {
        String dlUrl;
        String os = Platform.getOS();
        Object o = workingRT.getLabels().get("additionalDownloadURLs");
        String firstPossibleDL = null;
        if (o instanceof Map) {
            Map m = (Map)o;
            for (Object iNext : m.keySet()) {
                if (iNext.equals(os)) {
                    return (String)m.get(iNext);
                }
                if (firstPossibleDL != null) continue;
                firstPossibleDL = (String)m.get(iNext);
            }
        }
        if ((dlUrl = workingRT.getDownloadUrl()) == null) {
            return firstPossibleDL;
        }
        return dlUrl;
    }

    protected abstract String getLegacyId(String var1);
}

