/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.server.IKarafServerDelegateWorkingCopy;
import org.fusesource.ide.server.karaf.core.server.internal.IServerConnectionProvider;
import org.fusesource.ide.server.karaf.core.server.subsystems.Karaf2xStartupLaunchConfigurator;
import org.fusesource.ide.server.karaf.core.util.ServerNamingUtil;
import org.jboss.ide.eclipse.as.core.server.ILaunchConfigConfigurator;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerSecureStorageUtil;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionFacade;
import org.jboss.tools.jmx.core.IConnectionWrapper;

public class KarafServerDelegate
extends ServerDelegate
implements IKarafServerDelegateWorkingCopy,
IConnectionFacade {
    public static final String KARAF_JMX_CONNECTION_PROVIDER_ID = "org.fusesource.ide.jmx.karaf.connection.KarafConnectionProvider";
    public static final int DEFAULT_SSH_PORT = 8101;
    public static final String DEFAULT_KARAF_SSH_HOSTNAME = "localhost";
    public static final String DEFAULT_KARAF_SSH_USER = "karaf";
    public static final String DEFAULT_KARAF_SSH_PASSWORD = "karaf";

    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        IRuntime rt = this.getServer().getRuntime();
        this.getServerWorkingCopy().setName(ServerNamingUtil.getDefaultServerName(this.getServer(), rt));
        this.setAttribute("userId", this.getDefaultUsername());
    }

    protected String getDefaultUsername() {
        return "karaf";
    }

    protected String getDefaultPassword() {
        return "karaf";
    }

    public String getHostName() {
        return this.getAttribute("sshHost", this.getServer().getHost());
    }

    @Override
    public int getPortNumber() {
        return this.getAttribute("sshPort", 8101);
    }

    @Override
    public String getUserName() {
        return this.getAttribute("userId", this.getDefaultUsername());
    }

    public void setHostName(String hostName) {
        this.setAttribute("sshHost", hostName);
    }

    @Override
    public String getPassword() {
        String s = ServerSecureStorageUtil.getFromSecureStorage((String)"org.fusesource.ide.server.karaf.core", (IServerAttributes)this.getServer(), (String)"password");
        if (s == null) {
            return this.getAttribute("password", this.getDefaultPassword());
        }
        return s;
    }

    @Override
    public void setPassword(String pass) {
        try {
            ServerSecureStorageUtil.storeInSecureStorage((String)"org.fusesource.ide.server.karaf.core", (IServerAttributes)this.getServer(), (String)"password", (String)pass);
        }
        catch (UnsupportedEncodingException | StorageException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.fusesource.ide.server.karaf.core", "Could not save password for server in secure storage.", e));
        }
    }

    @Override
    public void setPortNumber(int portNo) {
        this.setAttribute("sshPort", portNo);
    }

    @Override
    public void setUserName(String userName) {
        this.setAttribute("userId", userName);
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        return Status.OK_STATUS;
    }

    public IModule[] getChildModules(IModule[] module) {
        return module;
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        return new IModule[]{module};
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    public ILaunchConfigConfigurator getLaunchConfigurator() throws CoreException {
        return new Karaf2xStartupLaunchConfigurator(this.getServer());
    }

    public IStatus validate() {
        if (this.getServer() != null && this.getServer().getRuntime() != null) {
            IPath rtLoc = this.getServer().getRuntime().getLocation();
            IPath karafJar = rtLoc.append("lib").append("karaf.jar");
            if (rtLoc.toFile().exists() && rtLoc.toFile().isDirectory() && karafJar.toFile().exists() && karafJar.toFile().isFile()) {
                return Status.OK_STATUS;
            }
        }
        return Status.CANCEL_STATUS;
    }

    public IConnectionWrapper getJMXConnection() {
        IConnectionWrapper wrapper = null;
        IServerConnectionProvider provider = (IServerConnectionProvider)ExtensionManager.getProvider((String)KARAF_JMX_CONNECTION_PROVIDER_ID);
        if (provider != null) {
            wrapper = provider.findConnection(this.getServer());
        }
        return wrapper;
    }
}

