/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server.subsystems;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.runtime.IKarafRuntime;
import org.jboss.ide.eclipse.as.core.util.ArgsUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.launch.LaunchConfiguratorWithOverrides;

public abstract class BaseKarafStartupLaunchConfigurator
extends LaunchConfiguratorWithOverrides {
    protected static final String QUOTE = "\"";
    protected static final String SPACE = " ";
    protected static final String SEPARATOR = File.separator;
    protected static final String ENDORSED = "endorsed";
    protected static final String EXT = "ext";
    protected static final String LIB = "lib";
    protected static final String KARAF_MAIN_CLASS = "org.apache.karaf.main.Main";
    protected static final String KARAF_STOP_CLASS = "org.apache.karaf.main.Stop";

    public BaseKarafStartupLaunchConfigurator(IServer server) throws CoreException {
        super(server);
    }

    protected void doConfigure(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        IKarafRuntime runtime = null;
        if (this.server.getRuntime() != null) {
            runtime = (IKarafRuntime)this.server.getRuntime().loadAdapter(IKarafRuntime.class, null);
        }
        if (runtime != null) {
            String karafInstallDir = runtime.getLocation().toOSString();
            String runtimeVersion = runtime.getVersion();
            if (!this.isSupportedRuntimeVersion(runtimeVersion)) {
                Activator.getLogger().error("Unhandled Version (" + runtimeVersion + ")!");
            }
            File vmLoc = runtime.getVM().getInstallLocation();
            String endorsedDirs = this.createEndorsedDirValue(karafInstallDir, vmLoc);
            String extDirs = this.createExtDirValue(karafInstallDir, vmLoc);
            String vmArguments = this.getVMArguments(karafInstallDir, endorsedDirs, extDirs);
            String mainProgram = this.getMainProgram();
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, karafInstallDir);
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainProgram);
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArguments);
            LinkedList<String> classPathList = new LinkedList<String>();
            String[] classPathEntries = this.getClassPathEntries(karafInstallDir);
            if (classPathEntries != null && classPathEntries.length > 0) {
                String[] stringArray = classPathEntries;
                int n = classPathEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    String jarName = stringArray[n2];
                    Path jarPath = new Path(jarName);
                    IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)jarPath);
                    classPathList.add(entry.getMemento());
                    ++n2;
                }
            }
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classPathList);
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, this.getJreContainerPath(runtime));
        }
    }

    public void doOverrides(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        IRuntime serverRuntime = this.server.getRuntime();
        if (serverRuntime != null) {
            IKarafRuntime runtime = (IKarafRuntime)serverRuntime.loadAdapter(IKarafRuntime.class, null);
            String karafInstallDir = serverRuntime.getLocation().toOSString();
            this.configureJRE(launchConfig, runtime, karafInstallDir);
            this.configureVMArguments(launchConfig, karafInstallDir);
        }
    }

    protected void configureVMArguments(ILaunchConfigurationWorkingCopy launchConfig, String karafInstallDir) throws CoreException {
        String vmArguments = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        IKarafRuntime karafRuntime = (IKarafRuntime)this.server.getRuntime().loadAdapter(IKarafRuntime.class, null);
        File vmLoc = karafRuntime.getVM().getInstallLocation();
        vmArguments = ArgsUtil.setArg((String)vmArguments, null, (String)"-Djava.ext.dirs", (String)this.createExtDirValue(karafInstallDir, vmLoc));
        vmArguments = ArgsUtil.setArg((String)vmArguments, null, (String)"-Djava.endorsed.dirs", (String)this.createEndorsedDirValue(karafInstallDir, vmLoc));
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArguments);
    }

    public void configureJRE(ILaunchConfigurationWorkingCopy workingCopy, IKarafRuntime runtime, String karafInstallDir) throws CoreException {
        LinkedList<String> classPathList = new LinkedList<String>();
        String[] classPathEntries = this.getClassPathEntries(karafInstallDir);
        if (classPathEntries != null && classPathEntries.length > 0) {
            String[] stringArray = classPathEntries;
            int n = classPathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                String jarName = stringArray[n2];
                Path jarPath = new Path(jarName);
                IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)jarPath);
                classPathList.add(entry.getMemento());
                ++n2;
            }
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classPathList);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, this.getJreContainerPath(runtime));
    }

    protected abstract boolean isSupportedRuntimeVersion(String var1);

    protected String getJreContainerPath(IKarafRuntime runtime) {
        IVMInstall vmInstall = runtime.getVM();
        if (vmInstall == null) {
            return null;
        }
        return JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString();
    }

    protected String[] getClassPathEntries(String installPath) {
        ArrayList<Object> cp = new ArrayList<Object>();
        Path libPath = new Path(String.format("%s%s%s%s", installPath, SEPARATOR, LIB, SEPARATOR));
        if (libPath.toFile().exists()) {
            this.findJars((IPath)libPath, cp);
        }
        String[] entries = new String[cp.size() + 1];
        entries[0] = String.valueOf(installPath) + SEPARATOR + "etc";
        int i = 1;
        for (Object e : cp) {
            IRuntimeClasspathEntry e2 = (IRuntimeClasspathEntry)e;
            entries[i++] = e2.getLocation();
        }
        return entries;
    }

    protected void findJars(IPath path, List<Object> cp) {
        File[] libs = path.toFile().listFiles(pathname -> pathname.isDirectory() || pathname.isFile() && pathname.getName().toLowerCase().endsWith(".jar"));
        if (libs != null) {
            File[] fileArray = libs;
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                File lib = fileArray[n2];
                IPath p = path.append(lib.getName());
                if (lib.isFile()) {
                    if (lib.getName().toLowerCase().startsWith("karaf")) {
                        cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)p));
                    }
                } else {
                    this.findJars(p, cp);
                }
                ++n2;
            }
        }
    }

    protected String getDeployDir() {
        IKarafRuntime runtime = (IKarafRuntime)this.server.getRuntime().loadAdapter(IKarafRuntime.class, null);
        if (runtime != null) {
            String karafInstallDir = runtime.getLocation().toOSString();
            return String.valueOf(karafInstallDir) + SEPARATOR + "deploy";
        }
        return "";
    }

    protected String getMainProgram() {
        return KARAF_MAIN_CLASS;
    }

    public String getVMArguments(String karafInstallDir, String endorsedDirs, String extDirs) {
        return this.getBaseVMArguments(karafInstallDir, endorsedDirs, extDirs);
    }

    private String getBaseVMArguments(String karafInstallDir, String endorsedDirs, String extDirs) {
        StringBuilder vmArguments = new StringBuilder();
        vmArguments.append("-Xms128M");
        vmArguments.append(" -Xmx512M");
        vmArguments.append(" -XX:+UnlockDiagnosticVMOptions");
        vmArguments.append(" -XX:+UnsyncloadClass");
        vmArguments.append(" -server");
        vmArguments.append(" -Dcom.sun.management.jmxremote");
        vmArguments.append(" -Djava.endorsed.dirs=\"" + endorsedDirs + QUOTE);
        vmArguments.append(" -Djava.ext.dirs=\"" + extDirs + QUOTE);
        vmArguments.append(" -Dkaraf.startLocalConsole=false");
        vmArguments.append(" -Dkaraf.startRemoteShell=true");
        vmArguments.append(" -Dkaraf.home=\"" + karafInstallDir + QUOTE);
        vmArguments.append(" -Dkaraf.base=\"" + karafInstallDir + QUOTE);
        vmArguments.append(" -Dkaraf.instances=\"" + karafInstallDir + SEPARATOR + "instances" + QUOTE);
        vmArguments.append(" -Dkaraf.data=\"" + karafInstallDir + SEPARATOR + "data" + QUOTE);
        vmArguments.append(" -Djava.util.logging.config.file=\"" + karafInstallDir + SEPARATOR + "etc" + SEPARATOR + "java.util.logging.properties" + QUOTE);
        return vmArguments.toString();
    }

    public String createEndorsedDirValue(String karafInstallDir, File vmLoc) {
        return String.valueOf(Paths.get(vmLoc.getPath(), "jre", LIB, ENDORSED).toString()) + File.pathSeparator + Paths.get(vmLoc.getPath(), LIB, ENDORSED).toString() + File.pathSeparator + Paths.get(karafInstallDir, LIB, ENDORSED).toString();
    }

    public String createExtDirValue(String karafInstallDir, File vmLoc) {
        return String.valueOf(Paths.get(vmLoc.getPath(), "jre", LIB, EXT).toString()) + File.pathSeparator + Paths.get(vmLoc.getPath(), LIB, EXT).toString() + File.pathSeparator + Paths.get(karafInstallDir, LIB, EXT).toString();
    }
}

