/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server.subsystems;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.server.karaf.core.server.subsystems.BaseKarafStartupLaunchConfigurator;

public class Karaf2xStartupLaunchConfigurator
extends BaseKarafStartupLaunchConfigurator {
    public Karaf2xStartupLaunchConfigurator(IServer server) throws CoreException {
        super(server);
    }

    @Override
    protected boolean isSupportedRuntimeVersion(String version) {
        return !Strings.isBlank((String)version) && version.startsWith("2.");
    }

    @Override
    public String getVMArguments(String karafInstallDir, String endorsedDirs, String extDirs) {
        StringBuilder vmArguments = new StringBuilder(super.getVMArguments(karafInstallDir, endorsedDirs, extDirs));
        if (this.isNewerThanKaraf24()) {
            vmArguments.append(" -Dkaraf.etc=\"" + karafInstallDir + SEPARATOR + "etc" + "\"");
            return vmArguments.toString();
        }
        vmArguments.append(" -Dderby.system.home=\"" + karafInstallDir + SEPARATOR + "data" + SEPARATOR + "derby" + "\"");
        vmArguments.append(" -Dderby.storage.fileSyncTransactionLog=true");
        return vmArguments.toString();
    }

    protected boolean isNewerThanKaraf24() {
        return this.server.getRuntime() != null && this.server.getRuntime().getRuntimeType().getVersion().startsWith("2.4");
    }
}

