/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Model;
import org.apache.maven.settings.Server;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.server.BaseConfigPropertyProvider;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;

public class KarafUtils {
    private static final String BUNDLE_VERSION_STRING = "Bundle-Version=";
    public static final int NO_PUBLISH = 0;
    public static final int INCREMENTAL_PUBLISH = 1;
    public static final int FULL_PUBLISH = 2;
    public static final int REMOVE_PUBLISH = 3;
    public static final String PROTOCOL_PREFIX_JAR = "wrap:";
    public static final String PROTOCOL_PREFIX_MAVEN = "mvn:";
    public static final String PROTOCOL_PREFIX_OSGI = "";
    public static final String PROTOCOL_PREFIX_WEB = "war:";
    public static final String PACKAGING_JAR = "jar";
    public static final String PACKAGING_BUNDLE = "bundle";
    public static final String PACKAGING_WAR = "war";
    public static final String SERVER_ID = "fabric8-server-id";
    public static final String SERVER_USER = "fabric8-server-user";
    public static final String SERVER_PASSWORD = "fabric8-server-password";

    public static String getVersion(File installFolder) {
        ServerBeanLoader loader = new ServerBeanLoader(installFolder);
        if (loader.getServerBeanType() != ServerBeanType.UNKNOWN) {
            return loader.getFullServerVersion();
        }
        return null;
    }

    public static int getPublishType(IServer server, IModule[] module, int kind, int deltaKind) {
        int modulePublishState = server.getModulePublishState(module);
        if (deltaKind == 1) {
            return 2;
        }
        if (deltaKind == 3) {
            return 3;
        }
        if (kind == 2 || modulePublishState == 3 || kind == 4) {
            return 2;
        }
        if ((kind == 1 || modulePublishState == 2 || kind == 3) && 2 == deltaKind) {
            return 1;
        }
        return 0;
    }

    public static String getBundleFilePath(final IModule module) throws CoreException {
        final String packaging = KarafUtils.getPackaging(module);
        final String artifactId = KarafUtils.getArtifactId(module);
        File projectTargetPath = module.getProject().getLocation().append("target").toFile();
        File[] jars = projectTargetPath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.exists() && pathname.isFile() && (pathname.getName().toLowerCase().startsWith(module.getProject().getName().toLowerCase()) || pathname.getName().toLowerCase().startsWith(artifactId.toLowerCase())) && pathname.getName().toLowerCase().endsWith(KarafUtils.getFileExtensionForPackaging(packaging));
            }
        });
        if (jars != null && jars.length > 0) {
            if (packaging.equalsIgnoreCase(PACKAGING_BUNDLE)) {
                return String.format("%sfile:%s", KarafUtils.getProtocolPrefixForModule(module), jars[0].getPath());
            }
            if (packaging.equalsIgnoreCase(PACKAGING_JAR)) {
                return String.format("%sfile:%s$Bundle-SymbolicName=%s&Bundle-Version=%s", KarafUtils.getProtocolPrefixForModule(module), jars[0].getPath(), KarafUtils.getBundleSymbolicName(module), KarafUtils.getBundleVersion(module, jars[0]));
            }
            if (packaging.equalsIgnoreCase(PACKAGING_WAR)) {
                return String.format("%sfile:%s?Bundle-SymbolicName=%s&Bundle-Version=%s", KarafUtils.getProtocolPrefixForModule(module), jars[0].getPath(), KarafUtils.getBundleSymbolicName(module), KarafUtils.getBundleVersion(module, jars[0]));
            }
        }
        return null;
    }

    private static String getFileExtensionForPackaging(String packaging) {
        if (packaging.equalsIgnoreCase(PACKAGING_BUNDLE) || packaging.equalsIgnoreCase(PACKAGING_JAR)) {
            return ".jar";
        }
        if (packaging.equalsIgnoreCase(PACKAGING_WAR)) {
            return ".war";
        }
        return ".jar";
    }

    private static String getProtocolPrefixForModule(IModule module) throws CoreException {
        String packaging = KarafUtils.getPackaging(module);
        if (Strings.isBlank((String)packaging) || packaging.equalsIgnoreCase(PACKAGING_JAR)) {
            return PROTOCOL_PREFIX_JAR;
        }
        if (packaging.equalsIgnoreCase(PACKAGING_BUNDLE)) {
            return PROTOCOL_PREFIX_OSGI;
        }
        if (packaging.equalsIgnoreCase(PACKAGING_WAR)) {
            return PROTOCOL_PREFIX_WEB;
        }
        return PROTOCOL_PREFIX_JAR;
    }

    private static String getPackaging(IModule module) throws CoreException {
        Model model = MavenPlugin.getMavenModelManager().readMavenModel(KarafUtils.getModelFile(module));
        return model.getPackaging();
    }

    private static String getArtifactId(IModule module) throws CoreException {
        Model model = MavenPlugin.getMavenModelManager().readMavenModel(KarafUtils.getModelFile(module));
        return model.getArtifactId();
    }

    public static File getModelFile(IModule module) {
        if (module == null) {
            return null;
        }
        return module.getProject().getLocation().append("pom.xml").toFile();
    }

    public static boolean runBuild(List<String> goals, IModule module, IProgressMonitor monitor) throws CoreException {
        return KarafUtils.runBuild(goals, null, module, monitor);
    }

    public static boolean runBuild(List<String> goals, Properties serverProperties, IModule module, IProgressMonitor monitor) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        IMavenExecutionContext executionContext = maven.createExecutionContext();
        MavenExecutionRequest executionRequest = executionContext.getExecutionRequest();
        executionRequest.setPom(KarafUtils.getModelFile(module));
        if (serverProperties != null && !serverProperties.isEmpty()) {
            Server fabric8Server = new Server();
            fabric8Server.setId(serverProperties.getProperty(SERVER_ID));
            fabric8Server.setUsername(serverProperties.getProperty(SERVER_USER));
            fabric8Server.setPassword(serverProperties.getProperty(SERVER_PASSWORD));
            executionRequest.addServer(fabric8Server);
        }
        executionRequest.setGoals(goals);
        MavenExecutionResult result = maven.execute(executionRequest, monitor);
        for (Throwable t : result.getExceptions()) {
            Activator.getLogger().error(t);
        }
        return !result.hasExceptions();
    }

    public static String getBundleSymbolicName(IModule module) throws CoreException {
        String symbolicName;
        if (module == null || module.getProject() == null) {
            return PROTOCOL_PREFIX_OSGI;
        }
        IFile manifest = module.getProject().getFile("target/classes/META-INF/MANIFEST.MF");
        if (!manifest.exists()) {
            manifest = module.getProject().getFile("META-INF/MANIFEST.MF");
        }
        if (manifest.exists()) {
            try {
                Manifest mf = new Manifest(new FileInputStream(manifest.getLocation().toFile()));
                symbolicName = mf.getMainAttributes().getValue("Bundle-SymbolicName");
                symbolicName = KarafUtils.stripParametersFromSymbolicName(symbolicName);
            }
            catch (IOException iOException) {
                symbolicName = null;
            }
        } else {
            symbolicName = null;
        }
        if (symbolicName == null) {
            symbolicName = KarafUtils.getArtifactId(module);
        }
        if (symbolicName == null) {
            symbolicName = module.getId();
        }
        return symbolicName;
    }

    public static String stripParametersFromSymbolicName(String symbolicName) {
        int paramIdx;
        String resVal = symbolicName;
        if (symbolicName != null && (paramIdx = symbolicName.indexOf(59)) != -1) {
            resVal = symbolicName.substring(0, paramIdx);
        }
        return resVal;
    }

    public static String getBundleVersionFromManifest(File manifest) {
        String version;
        if (manifest.exists()) {
            try {
                Manifest mf = new Manifest(new FileInputStream(manifest));
                version = mf.getMainAttributes().getValue("Bundle-Version");
            }
            catch (IOException iOException) {
                version = null;
            }
        } else {
            version = null;
        }
        return version;
    }

    public static String getBundleVersionFromFileName(File f, String packaging) {
        String[] parts;
        String version = PROTOCOL_PREFIX_OSGI;
        String[] stringArray = parts = f.getName().split("-");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                String part;
                block3: {
                    part = stringArray[n2];
                    if (Character.isDigit(part.charAt(0))) break block3;
                    if (version.isEmpty()) break block4;
                    version = String.valueOf(version) + "." + part;
                }
                version = String.valueOf(version) + part.trim();
            }
            ++n2;
        }
        version = version.substring(0, version.indexOf(KarafUtils.getFileExtensionForPackaging(packaging)));
        return version;
    }

    public static File findManifest(IModule module) throws CoreException {
        ModuleDelegate md = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, null);
        IModuleResource[] res = md.members();
        int i = 0;
        while (i < res.length) {
            IModuleResource meta;
            if ("META-INF".equals(res[i].getName()) && (meta = res[i]) instanceof IModuleFolder) {
                IModuleResource[] metaContents = ((IModuleFolder)meta).members();
                int j = 0;
                while (j < metaContents.length) {
                    if ("manifest.mf".equalsIgnoreCase(metaContents[j].getName())) {
                        IModuleResource mf = metaContents[j];
                        return (File)mf.getAdapter(File.class);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static String getBundleVersionFromURI(String uri, String packaging) {
        String version = null;
        if (uri != null && uri.indexOf(BUNDLE_VERSION_STRING) != -1) {
            version = uri.substring(uri.indexOf(BUNDLE_VERSION_STRING) + BUNDLE_VERSION_STRING.length());
        } else if (uri != null && uri.endsWith(KarafUtils.getFileExtensionForPackaging(packaging))) {
            String s = uri.substring(uri.lastIndexOf(File.separatorChar) + 1);
            String pack = KarafUtils.getFileExtensionForPackaging(packaging);
            boolean versionDigitsFound = false;
            int pointCount = 0;
            version = PROTOCOL_PREFIX_OSGI;
            int i = s.length() - pack.length() - 1;
            while (i >= 0) {
                char c = s.charAt(i);
                if (Character.isAlphabetic(c)) {
                    if (versionDigitsFound) {
                        break;
                    }
                } else if (Character.isDigit(c)) {
                    versionDigitsFound = true;
                } else if (c == '-' ? versionDigitsFound : c == '.' && ++pointCount > 2) break;
                version = String.valueOf(c) + version;
                --i;
            }
            if (version.indexOf(45) != -1) {
                version = version.replaceAll("-", ".");
            }
        }
        return version;
    }

    public static String getBundleVersion(IModule module, File f) throws CoreException {
        String version;
        if (module == null) {
            return PROTOCOL_PREFIX_OSGI;
        }
        String packaging = KarafUtils.getPackaging(module);
        File manifest = KarafUtils.findManifest(module);
        if (manifest == null || !manifest.exists()) {
            manifest = module.getProject().getFile("META-INF/MANIFEST.MF").getLocation().toFile();
        }
        if ((version = KarafUtils.getBundleVersionFromManifest(manifest)) == null) {
            if (f != null) {
                version = KarafUtils.getBundleVersionFromFileName(f, packaging);
            } else {
                String uri = KarafUtils.getBundleFilePath(module);
                version = KarafUtils.getBundleVersionFromURI(uri, packaging);
            }
        }
        return version;
    }

    public static String getJMXConnectionURL(IServer server) {
        int pos;
        StringBuilder retVal = new StringBuilder();
        BaseConfigPropertyProvider manProv = new BaseConfigPropertyProvider(server.getRuntime().getLocation().append("etc").append("org.apache.karaf.management.cfg").toFile());
        BaseConfigPropertyProvider sysProv = new BaseConfigPropertyProvider(server.getRuntime().getLocation().append("etc").append("system.properties").toFile());
        String url = manProv.getConfigurationProperty("serviceUrl");
        if (url == null) {
            return null;
        }
        url = url.trim();
        while ((pos = url.indexOf("${")) != -1) {
            retVal.append(url.substring(0, pos));
            String placeHolder = url.substring(url.indexOf("${") + 2, url.indexOf(125)).trim();
            String replacement = manProv.getConfigurationProperty(placeHolder);
            if (replacement == null) {
                replacement = sysProv.getConfigurationProperty(placeHolder);
            }
            if (replacement == null) {
                return null;
            }
            retVal.append(replacement.trim());
            url = url.substring(pos + placeHolder.length() + 3);
        }
        if (retVal.length() < 1) {
            retVal.append(url);
        }
        return retVal.toString();
    }
}

