/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.actions;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.hibernate.eclipse.jdt.ui.Activator;
import org.hibernate.eclipse.jdt.ui.internal.jpa.actions.JPAMapToolActor;

public class JPAMapToolActionDelegate
extends AbstractHandler
implements IObjectActionDelegate,
IEditorActionDelegate,
IViewActionDelegate {
    protected JPAMapToolActor actor = new JPAMapToolActor();
    protected WeakReference<Object> refContextObject = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.runInternal();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.actor.setSelection(selection);
        if (action != null) {
            action.setEnabled(this.actor.getSelectedSourceSize() > 0);
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (action != null) {
            action.setEnabled(this.actor.getSelectedSourceSize() > 0);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.runInternal();
        return null;
    }

    public void runInternal() {
        if (this.refContextObject != null) {
            this.processContextObjectElements();
        }
        this.actor.updateSelected(Integer.MAX_VALUE);
    }

    public void init(IViewPart view) {
    }

    public boolean isCUSelected() {
        IWorkbench workbench = Activator.getDefault().getWorkbench();
        if (workbench == null || workbench.getActiveWorkbenchWindow() == null) {
            return false;
        }
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return false;
        }
        IEditorPart editor = page.getActiveEditor();
        return editor instanceof CompilationUnitEditor;
    }

    public void setEnabled(Object context) {
        if (context instanceof EvaluationContext) {
            EvaluationContext ec = (EvaluationContext)context;
            Object obj = ec.getDefaultVariable();
            this.refContextObject = new WeakReference<Object>(obj);
        } else if (context instanceof ExpressionContext) {
            ExpressionContext ec = (ExpressionContext)context;
            Object obj = ec.getDefaultVariable();
            this.refContextObject = new WeakReference<Object>(obj);
        } else {
            this.refContextObject = null;
        }
        this.setBaseEnabled(this.checkEnabled());
    }

    protected boolean checkEnabled() {
        Object obj;
        boolean enable = false;
        Object t = obj = this.refContextObject != null ? (Object)this.refContextObject.get() : null;
        if (obj == null) {
            return enable;
        }
        List<Object> list = null;
        list = obj instanceof List ? (List<Object>)obj : Collections.singletonList(obj);
        Iterator<Object> it = list.iterator();
        while (it.hasNext() && !enable) {
            Object obj2 = it.next();
            if (!(obj2 instanceof IJavaElement)) continue;
            int kind = 1;
            if (obj2 instanceof IPackageFragment) {
                IPackageFragment pf = obj2;
                try {
                    kind = pf.getKind();
                }
                catch (JavaModelException javaModelException) {
                    kind = 2;
                }
            } else if (obj2 instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot pfr = obj2;
                try {
                    kind = pfr.getKind();
                }
                catch (JavaModelException javaModelException) {
                    kind = 2;
                }
            }
            if (kind != true) continue;
            enable = true;
        }
        if (!enable) {
            enable = this.isCUSelected();
        }
        return enable;
    }

    public void processContextObjectElements() {
        Object obj2;
        this.actor.setSelection(null);
        this.actor.clearSelectionCU();
        Object v0 = obj2 = this.refContextObject != null ? this.refContextObject.get() : null;
        if (obj2 == null) {
            return;
        }
        if (obj2 instanceof List) {
            for (Object obj2 : (List)obj2) {
                this.actor.processJavaElements(obj2);
            }
        } else {
            this.actor.processJavaElements(obj2);
        }
    }
}

