/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.actions;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.filebuffers.SynchronizableDocument;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.jdt.ui.Activator;
import org.hibernate.eclipse.jdt.ui.internal.JdtUiMessages;
import org.hibernate.eclipse.jdt.ui.internal.jpa.collect.AllEntitiesInfoCollector;
import org.hibernate.eclipse.jdt.ui.internal.jpa.collect.CompilationUnitCollector;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.Utils;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.AllEntitiesProcessor;

public class JPAMapToolActor {
    protected ISelection selection = null;
    protected CompilationUnitCollector compileUnitCollector = new CompilationUnitCollector();
    protected AllEntitiesInfoCollector collector = new AllEntitiesInfoCollector();
    protected AllEntitiesProcessor processor = new AllEntitiesProcessor();

    public JPAMapToolActor() {
        this.initPreferences();
    }

    public void initPreferences() {
        this.processor.initPreferences();
    }

    public void clearSelectionCU() {
        this.compileUnitCollector.clearSelectionCU();
    }

    public void addCompilationUnit(ICompilationUnit cu) {
        this.compileUnitCollector.addCompilationUnit(cu, true);
    }

    public void updateSelected(int depth) {
        if (this.selection != null) {
            this.updateSelectedItems(this.selection);
            this.selection = null;
        } else if (this.getSelectionCUSize() == 0) {
            this.updateOpen(depth);
            return;
        }
        if (this.getSelectionCUSize() == 0) {
            HashMap<String, EntityInfo> mapCUs_Info = new HashMap<String, EntityInfo>();
            StructuredSelection selection2Update = this.createSelection2Update();
            this.processor.modify(mapCUs_Info, true, (IStructuredSelection)selection2Update);
            return;
        }
        Iterator<ICompilationUnit> it = this.compileUnitCollector.setSelectionCUIterator();
        this.collector.initCollector();
        while (it.hasNext()) {
            ICompilationUnit cu = it.next();
            this.collector.collect(cu, depth);
        }
        this.collector.resolveRelations();
        if (this.collector.getNonInterfaceCUNumber() > 0) {
            this.processor.setAnnotationStylePreference(this.collector.getAnnotationStylePreference());
            Map<String, EntityInfo> mapCUs_Info = this.collector.getMapCUs_Info();
            StructuredSelection selection2Update = this.createSelection2Update();
            this.processor.modify(mapCUs_Info, true, (IStructuredSelection)selection2Update);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)JdtUiMessages.JPAMapToolActor_message_title, (String)JdtUiMessages.JPAMapToolActor_message);
        }
        this.processor.savePreferences();
    }

    private IWorkbenchWindow getActiveWorkbenchWindow() {
        return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    private Shell getShell() {
        IWorkbenchWindow activeWorkbenchWindow = this.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            return activeWorkbenchWindow.getShell();
        }
        return null;
    }

    public void updateOpen(int depth) {
        CompilationUnitEditor cue;
        ICompilationUnit cu;
        IWorkbenchWindow activeWorkbenchWindow = this.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
        if (page == null) {
            return;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof CompilationUnitEditor && (cu = (ICompilationUnit)(cue = (CompilationUnitEditor)editor).getViewPartInput()) != null) {
            this.addCompilationUnit(cu);
            this.collector.initCollector();
            this.collector.collect(cu, depth);
            this.collector.resolveRelations();
            if (this.collector.getNonInterfaceCUNumber() > 0) {
                Map<String, EntityInfo> mapCUs_Info = this.collector.getMapCUs_Info();
                StructuredSelection selection2Update = this.createSelection2Update();
                this.processor.modify(mapCUs_Info, true, (IStructuredSelection)selection2Update);
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)JdtUiMessages.JPAMapToolActor_message_title, (String)JdtUiMessages.JPAMapToolActor_message);
            }
        }
    }

    public void makePersistent(ICompilationUnit cu) throws CoreException {
        this.collector.collect(cu, Integer.MAX_VALUE);
    }

    public synchronized int getSelectedSourceSize() {
        int res = 0;
        if (this.selection == null) {
            res = 1;
        } else if (this.selection instanceof TextSelection) {
            res = 1;
        } else if (this.selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)this.selection;
            res = treeSelection.size();
            for (Object obj : treeSelection) {
                if (!this.excludeElement(obj)) continue;
                --res;
            }
        }
        return res;
    }

    private synchronized void updateSelectedItems(ISelection sel) {
        if (sel instanceof TextSelection) {
            String fullyQualifiedName = "";
            IDocument fDocument = null;
            SynchronizableDocument sDocument = null;
            CompilationUnit resultCU = null;
            Class<?> clazz = sel.getClass();
            Field fd = null;
            try {
                fd = clazz.getDeclaredField("fDocument");
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            if (fd != null) {
                try {
                    fd.setAccessible(true);
                    fDocument = (IDocument)fd.get(sel);
                    if (fDocument instanceof SynchronizableDocument) {
                        sDocument = (SynchronizableDocument)fDocument;
                    }
                    if (sDocument != null) {
                        ASTParser parser = ASTParser.newParser((int)8);
                        parser.setSource(sDocument.get().toCharArray());
                        parser.setResolveBindings(false);
                        resultCU = (CompilationUnit)parser.createAST(null);
                    }
                    if (resultCU != null && resultCU.types().size() > 0) {
                        fullyQualifiedName = resultCU.getPackage() != null ? String.valueOf(resultCU.getPackage().getName().getFullyQualifiedName()) + "." : "";
                        Object tmp = resultCU.types().get(0);
                        if (tmp instanceof AbstractTypeDeclaration) {
                            fullyQualifiedName = String.valueOf(fullyQualifiedName) + ((AbstractTypeDeclaration)tmp).getName();
                        }
                        if (!(tmp instanceof TypeDeclaration)) {
                            fullyQualifiedName = "";
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("IllegalArgumentException: ", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("IllegalAccessException: ", (Throwable)e);
                }
                catch (SecurityException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("SecurityException: ", (Throwable)e);
                }
            }
            this.clearSelectionCU();
            if (fullyQualifiedName.length() > 0) {
                ICompilationUnit cu = Utils.findCompilationUnit(fullyQualifiedName);
                this.addCompilationUnit(cu);
            }
        } else if (sel instanceof TreeSelection) {
            this.clearSelectionCU();
            TreeSelection treeSelection = (TreeSelection)sel;
            for (Object obj : treeSelection) {
                this.processJavaElements(obj);
            }
        } else {
            sel = null;
        }
    }

    protected boolean excludeElement(Object obj) {
        boolean res = false;
        if (obj instanceof JarPackageFragmentRoot) {
            res = true;
        } else if (obj instanceof ClassFile) {
            res = true;
        } else if (obj instanceof PackageFragment) {
            PackageFragment pf = (PackageFragment)obj;
            try {
                if (pf.getKind() == 2) {
                    res = true;
                }
            }
            catch (JavaModelException javaModelException) {}
        } else if (obj instanceof ExternalPackageFragmentRoot) {
            res = true;
        }
        return res;
    }

    public void processJavaElements(Object obj) {
        this.compileUnitCollector.processJavaElements(obj, true);
    }

    public synchronized void setSelection(ISelection selection) {
        this.compileUnitCollector.clearSelection2UpdateList();
        if (selection instanceof StructuredSelection && selection.isEmpty()) {
            this.clearSelectionCU();
            this.selection = null;
            return;
        }
        this.selection = selection;
    }

    public StructuredSelection createSelection2Update() {
        return this.compileUnitCollector.createSelection2Update();
    }

    public void setAllEntitiesInfoCollector(AllEntitiesInfoCollector collector) {
        this.collector = collector;
    }

    public void setAllEntitiesProcessor(AllEntitiesProcessor processor) {
        this.processor = processor;
    }

    public void setSelectionCU(Set<ICompilationUnit> selectionCU) {
        this.compileUnitCollector.setSelectionCU(selectionCU);
    }

    public int getSelectionCUSize() {
        return this.compileUnitCollector.getSelectionCUSize();
    }
}

