/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;

public class EntityInfosCollection {
    protected IPath path;
    protected ICompilationUnit iCompilationUnit;
    protected CompilationUnit compilationUnit;
    protected HashMap<String, EntityInfo> entityInfos = new HashMap();
    protected Set<String> setExistingImports = new TreeSet<String>();
    protected Set<String> setRequiredImports = new TreeSet<String>();

    public void addEntityInfo(EntityInfo ei) {
        this.entityInfos.put(ei.getFullyQualifiedName(), ei);
    }

    public EntityInfo getEntityInfo(String fullyQualifiedName) {
        return this.entityInfos.get(fullyQualifiedName);
    }

    public void updateExistingImportSet() {
        this.setExistingImports.clear();
        Iterator<EntityInfo> it = this.entityInfos.values().iterator();
        while (it.hasNext()) {
            it.next().collectExistingImport(this.setExistingImports);
        }
    }

    public void updateRequiredImportSet() {
        this.setRequiredImports.clear();
        Iterator<EntityInfo> it = this.entityInfos.values().iterator();
        while (it.hasNext()) {
            it.next().collectRequiredImport(this.setRequiredImports);
        }
    }

    public boolean needImport(String checkImport) {
        return !this.setExistingImports.contains(checkImport) && this.setRequiredImports.contains(checkImport);
    }

    public IPath getPath() {
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public ICompilationUnit getICompilationUnit() {
        return this.iCompilationUnit;
    }

    public void setICompilationUnit(ICompilationUnit iCompilationUnit) {
        this.iCompilationUnit = iCompilationUnit;
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnit(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        Iterator<EntityInfo> it = this.entityInfos.values().iterator();
        while (it.hasNext()) {
            res.append(it.next());
            res.append(";");
        }
        return res.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityInfosCollection)) {
            return false;
        }
        EntityInfosCollection eic = (EntityInfosCollection)obj;
        return this.toString().equals(eic.toString());
    }
}

