/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.common;

import java.util.Vector;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefType;

public class JPAConst {
    public static final String IMPORT_SERIALIZABLE = "java.io.Serializable";
    public static final String IMPORT_ENTITY = "javax.persistence.Entity";
    public static final String IMPORT_GENERATED_VALUE = "javax.persistence.GeneratedValue";
    public static final String IMPORT_ID = "javax.persistence.Id";
    public static final String IMPORT_JOINCOLUMN = "javax.persistence.JoinColumn";
    public static final String IMPORT_ONE2ONE = "javax.persistence.OneToOne";
    public static final String IMPORT_ONE2MANY = "javax.persistence.OneToMany";
    public static final String IMPORT_MANY2ONE = "javax.persistence.ManyToOne";
    public static final String IMPORT_MANY2MANY = "javax.persistence.ManyToMany";
    public static final String IMPORT_ENUMERATED = "javax.persistence.Enumerated";
    public static final String IMPORT_MAPPEDSUPERCLASS = "javax.persistence.MappedSuperclass";
    public static final String IMPORT_VERSION = "javax.persistence.Version";
    public static final String IMPORT_COLUMN = "javax.persistence.Column";
    public static final String ANNOTATION_SERIALIZABLE = "Serializable";
    public static final String ANNOTATION_ENTITY = "Entity";
    public static final String ANNOTATION_GENERATED_VALUE = "GeneratedValue";
    public static final String ANNOTATION_ID = "Id";
    public static final String ANNOTATION_JOINCOLUMN = "JoinColumn";
    public static final String ANNOTATION_ONE2ONE = "OneToOne";
    public static final String ANNOTATION_ONE2MANY = "OneToMany";
    public static final String ANNOTATION_MANY2ONE = "ManyToOne";
    public static final String ANNOTATION_MANY2MANY = "ManyToMany";
    public static final String ANNOTATION_ENUMERATED = "Enumerated";
    public static final String ANNOTATION_MAPPEDSUPERCLASS = "MappedSuperclass";
    public static final String ANNOTATION_VERSION = "Version";
    public static final String ANNOTATION_COLUMN = "Column";
    public static final Vector<String> ALL_IMPORTS = new Vector();

    static {
        ALL_IMPORTS.add(IMPORT_ENTITY);
        ALL_IMPORTS.add(IMPORT_GENERATED_VALUE);
        ALL_IMPORTS.add(IMPORT_ID);
        ALL_IMPORTS.add(IMPORT_JOINCOLUMN);
        ALL_IMPORTS.add(IMPORT_ONE2ONE);
        ALL_IMPORTS.add(IMPORT_ONE2MANY);
        ALL_IMPORTS.add(IMPORT_MANY2ONE);
        ALL_IMPORTS.add(IMPORT_MANY2MANY);
        ALL_IMPORTS.add(IMPORT_ENUMERATED);
        ALL_IMPORTS.add(IMPORT_MAPPEDSUPERCLASS);
        ALL_IMPORTS.add(IMPORT_VERSION);
        ALL_IMPORTS.add(IMPORT_COLUMN);
    }

    public static String getRefType(RefType refType) {
        if (refType == RefType.ONE2ONE) {
            return ANNOTATION_ONE2ONE;
        }
        if (refType == RefType.ONE2MANY) {
            return ANNOTATION_ONE2MANY;
        }
        if (refType == RefType.MANY2ONE) {
            return ANNOTATION_MANY2ONE;
        }
        if (refType == RefType.MANY2MANY) {
            return ANNOTATION_MANY2MANY;
        }
        if (refType == RefType.ENUMERATED) {
            return ANNOTATION_ENUMERATED;
        }
        return "";
    }

    public static boolean isAnnotationEntity(String fullyQualifiedName) {
        return ANNOTATION_ENTITY.compareTo(fullyQualifiedName) == 0 || IMPORT_ENTITY.compareTo(fullyQualifiedName) == 0;
    }

    public static boolean isAnnotationId(String fullyQualifiedName) {
        return ANNOTATION_ID.compareTo(fullyQualifiedName) == 0 || IMPORT_ID.compareTo(fullyQualifiedName) == 0;
    }

    public static boolean isAnnotationGeneratedValue(String fullyQualifiedName) {
        return ANNOTATION_GENERATED_VALUE.compareTo(fullyQualifiedName) == 0 || IMPORT_GENERATED_VALUE.compareTo(fullyQualifiedName) == 0;
    }

    public static boolean isAnnotationOne2One(String fullyQualifiedName) {
        return ANNOTATION_ONE2ONE.compareTo(fullyQualifiedName) == 0 || IMPORT_ONE2ONE.compareTo(fullyQualifiedName) == 0;
    }

    public static boolean isAnnotationOne2Many(String fullyQualifiedName) {
        return ANNOTATION_ONE2MANY.compareTo(fullyQualifiedName) == 0 || IMPORT_ONE2MANY.compareTo(fullyQualifiedName) == 0;
    }

    public static boolean isAnnotationMany2One(String fullyQualifiedName) {
        return ANNOTATION_MANY2ONE.compareTo(fullyQualifiedName) == 0 || IMPORT_MANY2ONE.compareTo(fullyQualifiedName) == 0;
    }

    public static boolean isAnnotationMany2Many(String fullyQualifiedName) {
        return ANNOTATION_MANY2MANY.compareTo(fullyQualifiedName) == 0 || IMPORT_MANY2MANY.compareTo(fullyQualifiedName) == 0;
    }

    public static boolean isAnnotationEnumerated(String fullyQualifiedName) {
        return ANNOTATION_ENUMERATED.compareTo(fullyQualifiedName) == 0 || IMPORT_ENUMERATED.compareTo(fullyQualifiedName) == 0;
    }

    public static boolean isAnnotationMappedSuperclass(String fullyQualifiedName) {
        return ANNOTATION_MAPPEDSUPERCLASS.compareTo(fullyQualifiedName) == 0 || IMPORT_MAPPEDSUPERCLASS.compareTo(fullyQualifiedName) == 0;
    }

    public static boolean isAnnotationVersion(String fullyQualifiedName) {
        return ANNOTATION_VERSION.compareTo(fullyQualifiedName) == 0 || IMPORT_VERSION.compareTo(fullyQualifiedName) == 0;
    }

    public static boolean isAnnotationColumn(String fullyQualifiedName) {
        return ANNOTATION_COLUMN.compareTo(fullyQualifiedName) == 0 || IMPORT_COLUMN.compareTo(fullyQualifiedName) == 0;
    }
}

