/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.process;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.hibernate.eclipse.jdt.ui.internal.jpa.collect.CollectEntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfosCollection;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.JPAConst;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.OwnerType;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefColumnInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefEntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefFieldInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefType;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.AnnotStyle;

public class ProcessEntityInfo
extends ASTVisitor {
    protected EntityInfosCollection entityInfos;
    protected EntityInfo entityInfo;
    protected Map<String, EntityInfo> entities;
    protected ASTRewrite rewriter;
    protected AnnotStyle annotationStyle = AnnotStyle.FIELDS;
    protected int defaultStrLength = 255;
    protected boolean enableOptLock = false;

    public void setEntityInfos(EntityInfosCollection entityInfos) {
        this.entityInfos = entityInfos;
    }

    public void setEntities(Map<String, EntityInfo> entities) {
        this.entities = entities;
    }

    public void setASTRewrite(ASTRewrite rewriter) {
        this.rewriter = rewriter;
    }

    public boolean visit(CompilationUnit node) {
        this.entityInfo = null;
        int i = 0;
        while (i < JPAConst.ALL_IMPORTS.size()) {
            String tmp = JPAConst.ALL_IMPORTS.get(i);
            if (this.entityInfos.needImport(tmp)) {
                this.addImport(node, tmp);
            }
            ++i;
        }
        return true;
    }

    public boolean addImport(CompilationUnit node, String importDeclaration) {
        String[] importDeclarations = importDeclaration.split("\\.");
        if (importDeclarations.length <= 1) {
            return false;
        }
        ImportDeclaration importDecl = this.rewriter.getAST().newImportDeclaration();
        SimpleName simpleName0 = this.rewriter.getAST().newSimpleName(importDeclarations[0]);
        SimpleName simpleName1 = this.rewriter.getAST().newSimpleName(importDeclarations[1]);
        QualifiedName qualifiedName0 = this.rewriter.getAST().newQualifiedName((Name)simpleName0, simpleName1);
        int i = 2;
        while (i < importDeclarations.length) {
            SimpleName simpleNameI = this.rewriter.getAST().newSimpleName(importDeclarations[i]);
            qualifiedName0 = this.rewriter.getAST().newQualifiedName((Name)qualifiedName0, simpleNameI);
            ++i;
        }
        importDecl.setName((Name)qualifiedName0);
        ListRewrite lrw = this.rewriter.getListRewrite((ASTNode)node, CompilationUnit.IMPORTS_PROPERTY);
        Iterator it = lrw.getRewrittenList().iterator();
        ImportDeclaration insertBeforeNode = null;
        while (it.hasNext()) {
            ImportDeclaration id;
            String idName;
            Object obj = it.next();
            if (!(obj instanceof ImportDeclaration) || (idName = (id = (ImportDeclaration)obj).getName().getFullyQualifiedName()).compareTo(importDeclaration) <= 0) continue;
            insertBeforeNode = id;
            break;
        }
        if (insertBeforeNode == null) {
            lrw.insertLast((ASTNode)importDecl, null);
        } else {
            lrw.insertBefore((ASTNode)importDecl, insertBeforeNode, null);
        }
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        ListRewrite lrw;
        MarkerAnnotation matd;
        String nodeName;
        ITypeBinding typeBinding = node.resolveBinding();
        String string = nodeName = typeBinding == null ? null : typeBinding.getBinaryName();
        if (nodeName == null) {
            return false;
        }
        this.entityInfo = this.entityInfos.getEntityInfo(nodeName);
        if (this.entityInfo == null) {
            return false;
        }
        if (this.entityInfo.isAddMappedSuperclassFlag()) {
            matd = this.rewriter.getAST().newMarkerAnnotation();
            matd.setTypeName((Name)this.rewriter.getAST().newSimpleName("MappedSuperclass"));
            lrw = this.rewriter.getListRewrite((ASTNode)node, TypeDeclaration.MODIFIERS2_PROPERTY);
            lrw.insertFirst((ASTNode)matd, null);
        }
        if (this.entityInfo.isAddEntityFlag()) {
            matd = this.rewriter.getAST().newMarkerAnnotation();
            matd.setTypeName((Name)this.rewriter.getAST().newSimpleName("Entity"));
            lrw = this.rewriter.getListRewrite((ASTNode)node, TypeDeclaration.MODIFIERS2_PROPERTY);
            lrw.insertFirst((ASTNode)matd, null);
        }
        if (!this.entityInfo.isImplicitConstructorFlag() && !this.entityInfo.isDefaultConstructorFlag() && this.entityInfo.isAddSerializableInterfaceFlag()) {
            MethodDeclaration md = this.rewriter.getAST().newMethodDeclaration();
            md.setConstructor(true);
            Modifier modifier = this.rewriter.getAST().newModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
            md.modifiers().add(modifier);
            Block body = this.rewriter.getAST().newBlock();
            md.setBody(body);
            SimpleName sn = this.rewriter.getAST().newSimpleName(this.entityInfo.getName());
            md.setName(sn);
            ListRewrite lrw2 = this.rewriter.getListRewrite((ASTNode)node, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            List list = lrw2.getOriginalList();
            MethodDeclaration insertBeforeNode = null;
            for (Object obj : list) {
                if (!(obj instanceof MethodDeclaration)) continue;
                insertBeforeNode = (MethodDeclaration)obj;
                break;
            }
            if (insertBeforeNode == null) {
                lrw2.insertLast((ASTNode)md, null);
            } else {
                lrw2.insertBefore((ASTNode)md, insertBeforeNode, null);
            }
        }
        if (this.enableOptLock && this.entityInfo.isAddVersionFlag() && !this.entityInfo.hasVersionAnnotation()) {
            VariableDeclarationFragment vdFragment = this.rewriter.getAST().newVariableDeclarationFragment();
            SimpleName variableName = this.rewriter.getAST().newSimpleName("version");
            vdFragment.setName(variableName);
            FieldDeclaration fieldVersion = this.rewriter.getAST().newFieldDeclaration(vdFragment);
            Modifier modifier = this.rewriter.getAST().newModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
            fieldVersion.modifiers().add(modifier);
            Name typeName = this.rewriter.getAST().newName("Integer");
            SimpleType type = this.rewriter.getAST().newSimpleType(typeName);
            fieldVersion.setType((Type)type);
            MethodDeclaration mdGetter = this.rewriter.getAST().newMethodDeclaration();
            modifier = this.rewriter.getAST().newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
            mdGetter.modifiers().add(modifier);
            Block body = this.rewriter.getAST().newBlock();
            ReturnStatement returnVersion = this.rewriter.getAST().newReturnStatement();
            variableName = this.rewriter.getAST().newSimpleName("version");
            returnVersion.setExpression((Expression)variableName);
            body.statements().add(returnVersion);
            mdGetter.setBody(body);
            SimpleName sn = this.rewriter.getAST().newSimpleName("getVersion");
            mdGetter.setName(sn);
            typeName = this.rewriter.getAST().newName("Integer");
            type = this.rewriter.getAST().newSimpleType(typeName);
            mdGetter.setReturnType2((Type)type);
            MethodDeclaration mdSetter = this.rewriter.getAST().newMethodDeclaration();
            modifier = this.rewriter.getAST().newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
            mdSetter.modifiers().add(modifier);
            body = this.rewriter.getAST().newBlock();
            Assignment assignment = this.rewriter.getAST().newAssignment();
            FieldAccess fieldAccess = this.rewriter.getAST().newFieldAccess();
            ThisExpression thisExpression = this.rewriter.getAST().newThisExpression();
            fieldAccess.setExpression((Expression)thisExpression);
            variableName = this.rewriter.getAST().newSimpleName("version");
            fieldAccess.setName(variableName);
            assignment.setLeftHandSide((Expression)fieldAccess);
            variableName = this.rewriter.getAST().newSimpleName("version");
            assignment.setRightHandSide((Expression)variableName);
            ExpressionStatement expressionStatement = this.rewriter.getAST().newExpressionStatement((Expression)assignment);
            body.statements().add(expressionStatement);
            mdSetter.setBody(body);
            sn = this.rewriter.getAST().newSimpleName("setVersion");
            mdSetter.setName(sn);
            SingleVariableDeclaration svd = this.rewriter.getAST().newSingleVariableDeclaration();
            variableName = this.rewriter.getAST().newSimpleName("version");
            svd.setName(variableName);
            typeName = this.rewriter.getAST().newName("Integer");
            type = this.rewriter.getAST().newSimpleType(typeName);
            svd.setType((Type)type);
            mdSetter.parameters().add(svd);
            ListRewrite lrw3 = this.rewriter.getListRewrite((ASTNode)node, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            if (this.entityInfo.getVersionFieldGetter() != EntityInfo.FieldGetterType.FIELD && this.entityInfo.getVersionFieldGetter() != EntityInfo.FieldGetterType.FIELD_GETTER) {
                lrw3.insertLast((ASTNode)fieldVersion, null);
            }
            if (this.entityInfo.getVersionFieldGetter() != EntityInfo.FieldGetterType.GETTER && this.entityInfo.getVersionFieldGetter() != EntityInfo.FieldGetterType.FIELD_GETTER) {
                lrw3.insertLast((ASTNode)mdGetter, null);
                lrw3.insertLast((ASTNode)mdSetter, null);
            }
            if (this.annotationStyle == AnnotStyle.FIELDS) {
                MarkerAnnotation matd2 = this.rewriter.getAST().newMarkerAnnotation();
                matd2.setTypeName((Name)this.rewriter.getAST().newSimpleName("Version"));
                lrw3 = this.rewriter.getListRewrite((ASTNode)fieldVersion, FieldDeclaration.MODIFIERS2_PROPERTY);
                lrw3.insertFirst((ASTNode)matd2, null);
            } else if (this.annotationStyle == AnnotStyle.GETTERS) {
                MarkerAnnotation matd3 = this.rewriter.getAST().newMarkerAnnotation();
                matd3.setTypeName((Name)this.rewriter.getAST().newSimpleName("Version"));
                lrw3 = this.rewriter.getListRewrite((ASTNode)mdGetter, MethodDeclaration.MODIFIERS2_PROPERTY);
                lrw3.insertFirst((ASTNode)matd3, null);
            }
        }
        return true;
    }

    public boolean visit(FieldDeclaration node) {
        SimpleType simpleType;
        String typeName;
        Iterator itVarNames;
        if (this.entityInfo == null) {
            return false;
        }
        if (this.annotationStyle != AnnotStyle.FIELDS) {
            return true;
        }
        Type type = node.getType();
        if (type == null) {
            return true;
        }
        if (type.isSimpleType() || type.isPrimitiveType()) {
            ListRewrite lrw;
            MarkerAnnotation matd;
            String name;
            VariableDeclarationFragment var;
            Iterator itVarNames2;
            String primaryIdName;
            if (this.entityInfo.isAddGeneratedValueFlag()) {
                primaryIdName = this.entityInfo.getPrimaryIdName();
                itVarNames2 = node.fragments().iterator();
                boolean addGeneratedValueMarker = false;
                while (itVarNames2.hasNext()) {
                    var = (VariableDeclarationFragment)itVarNames2.next();
                    name = var.getName().getIdentifier();
                    if (!primaryIdName.equals(name)) continue;
                    addGeneratedValueMarker = true;
                    break;
                }
                if (addGeneratedValueMarker) {
                    matd = this.rewriter.getAST().newMarkerAnnotation();
                    matd.setTypeName((Name)this.rewriter.getAST().newSimpleName("GeneratedValue"));
                    lrw = this.rewriter.getListRewrite((ASTNode)node, FieldDeclaration.MODIFIERS2_PROPERTY);
                    lrw.insertFirst((ASTNode)matd, null);
                }
            }
            if (this.entityInfo.isAddPrimaryIdFlag()) {
                primaryIdName = this.entityInfo.getPrimaryIdName();
                itVarNames2 = node.fragments().iterator();
                boolean addIdMarker = false;
                while (itVarNames2.hasNext()) {
                    var = (VariableDeclarationFragment)itVarNames2.next();
                    name = var.getName().getIdentifier();
                    if (!primaryIdName.equals(name)) continue;
                    addIdMarker = true;
                    break;
                }
                if (addIdMarker) {
                    matd = this.rewriter.getAST().newMarkerAnnotation();
                    matd.setTypeName((Name)this.rewriter.getAST().newSimpleName("Id"));
                    lrw = this.rewriter.getListRewrite((ASTNode)node, FieldDeclaration.MODIFIERS2_PROPERTY);
                    lrw.insertFirst((ASTNode)matd, null);
                }
            }
            if (this.enableOptLock && this.entityInfo.isAddVersionFlag() && !this.entityInfo.hasVersionAnnotation()) {
                itVarNames = node.fragments().iterator();
                boolean addVersionMarker = false;
                while (itVarNames.hasNext()) {
                    VariableDeclarationFragment var2 = (VariableDeclarationFragment)itVarNames.next();
                    String name2 = var2.getName().getIdentifier();
                    if (!"version".equals(name2)) continue;
                    addVersionMarker = true;
                    break;
                }
                if (addVersionMarker) {
                    MarkerAnnotation matd2 = this.rewriter.getAST().newMarkerAnnotation();
                    matd2.setTypeName((Name)this.rewriter.getAST().newSimpleName("Version"));
                    ListRewrite lrw2 = this.rewriter.getListRewrite((ASTNode)node, FieldDeclaration.MODIFIERS2_PROPERTY);
                    lrw2.insertFirst((ASTNode)matd2, null);
                }
            }
        }
        if (type.isSimpleType() && 255 != this.defaultStrLength && ("java.lang.String".equals(typeName = (simpleType = (SimpleType)type).getName().getFullyQualifiedName()) || "String".equals(typeName))) {
            RefColumnInfo rci;
            String fieldId = null;
            for (VariableDeclarationFragment var : node.fragments()) {
                fieldId = var.getName().getIdentifier();
                if (fieldId != null) break;
            }
            if ((rci = this.entityInfo.getRefColumnInfo(fieldId)) == null || !rci.isExist()) {
                NormalAnnotation natd = this.rewriter.getAST().newNormalAnnotation();
                natd.setTypeName((Name)this.rewriter.getAST().newSimpleName("Column"));
                ListRewrite lrw = this.rewriter.getListRewrite((ASTNode)node, FieldDeclaration.MODIFIERS2_PROPERTY);
                lrw.insertFirst((ASTNode)natd, null);
                MemberValuePair mvp = this.rewriter.getAST().newMemberValuePair();
                mvp.setName(this.rewriter.getAST().newSimpleName("length"));
                NumberLiteral nl = this.rewriter.getAST().newNumberLiteral(String.valueOf(this.defaultStrLength));
                mvp.setValue((Expression)nl);
                natd.values().add(mvp);
            }
        }
        if (type.isSimpleType() || type.isParameterizedType() || type.isArrayType()) {
            itVarNames = node.fragments().iterator();
            String fieldId = "";
            RefType refType = RefType.UNDEF;
            boolean annotated = false;
            String fullyQualifiedName2 = "";
            while (itVarNames.hasNext()) {
                String name;
                VariableDeclarationFragment var = (VariableDeclarationFragment)itVarNames.next();
                fieldId = name = var.getName().getIdentifier();
                refType = this.entityInfo.getFieldIdRelValue(fieldId);
                annotated = this.entityInfo.getFieldIdAnnotatedValue(fieldId);
                fullyQualifiedName2 = this.entityInfo.getFieldIdFQNameValue(fieldId);
                if (refType != RefType.UNDEF) break;
            }
            Set<RefFieldInfo> setRFI = this.entityInfo.getRefFieldInfoSet(fullyQualifiedName2);
            if (!annotated && setRFI != null && this.isSimilarType(type, fullyQualifiedName2)) {
                RefEntityInfo rei = this.entityInfo.getFieldIdRefEntityInfo(fieldId);
                if (setRFI.size() > 1 && refType != RefType.MANY2ONE) {
                    if (rei.mappedBy == null || rei.mappedBy == "") {
                        this.addSimpleMarkerAnnotation((BodyDeclaration)node, JPAConst.getRefType(refType));
                    } else {
                        this.addComplexNormalAnnotation((BodyDeclaration)node, JPAConst.getRefType(refType), rei);
                    }
                } else if (refType == RefType.MANY2ONE || refType == RefType.ENUMERATED || rei.mappedBy == null || rei.mappedBy == "") {
                    this.addSimpleMarkerAnnotation((BodyDeclaration)node, JPAConst.getRefType(refType));
                } else {
                    this.addComplexNormalAnnotation((BodyDeclaration)node, JPAConst.getRefType(refType), rei);
                }
            }
        }
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        String fieldId;
        RefColumnInfo rci;
        SimpleType simpleType;
        String typeName;
        if (this.entityInfo == null) {
            return false;
        }
        if (this.annotationStyle != AnnotStyle.GETTERS) {
            return true;
        }
        if (node.getName().getFullyQualifiedName().compareTo(this.entityInfo.getName()) == 0 || node.isConstructor()) {
            return true;
        }
        if (node.getName().getIdentifier().startsWith("set") && node.parameters().size() == 1) {
            return true;
        }
        if (!node.getName().getIdentifier().startsWith("get") && !node.getName().getIdentifier().startsWith("is") || node.parameters().size() > 0) {
            return true;
        }
        Type type = node.getReturnType2();
        if (type == null) {
            return true;
        }
        String returnIdentifier = CollectEntityInfo.getReturnIdentifier(node);
        if (type.isSimpleType() || type.isPrimitiveType()) {
            ListRewrite lrw;
            MarkerAnnotation matd;
            String primaryIdName;
            if (this.entityInfo.isAddGeneratedValueFlag()) {
                primaryIdName = this.entityInfo.getPrimaryIdName();
                boolean addGeneratedValueMarker = false;
                if (primaryIdName.equals(returnIdentifier)) {
                    addGeneratedValueMarker = true;
                }
                if (addGeneratedValueMarker) {
                    matd = this.rewriter.getAST().newMarkerAnnotation();
                    matd.setTypeName((Name)this.rewriter.getAST().newSimpleName("GeneratedValue"));
                    lrw = this.rewriter.getListRewrite((ASTNode)node, MethodDeclaration.MODIFIERS2_PROPERTY);
                    lrw.insertFirst((ASTNode)matd, null);
                }
            }
            if (this.entityInfo.isAddPrimaryIdFlag()) {
                primaryIdName = this.entityInfo.getPrimaryIdName();
                boolean addIdMarker = false;
                if (primaryIdName.equals(returnIdentifier)) {
                    addIdMarker = true;
                }
                if (addIdMarker) {
                    matd = this.rewriter.getAST().newMarkerAnnotation();
                    matd.setTypeName((Name)this.rewriter.getAST().newSimpleName("Id"));
                    lrw = this.rewriter.getListRewrite((ASTNode)node, MethodDeclaration.MODIFIERS2_PROPERTY);
                    lrw.insertFirst((ASTNode)matd, null);
                }
            }
            if (this.enableOptLock && this.entityInfo.isAddVersionFlag() && !this.entityInfo.hasVersionAnnotation()) {
                boolean addVersionMarker = false;
                if ("version".equals(returnIdentifier)) {
                    addVersionMarker = true;
                }
                if (addVersionMarker) {
                    MarkerAnnotation matd2 = this.rewriter.getAST().newMarkerAnnotation();
                    matd2.setTypeName((Name)this.rewriter.getAST().newSimpleName("Version"));
                    ListRewrite lrw2 = this.rewriter.getListRewrite((ASTNode)node, MethodDeclaration.MODIFIERS2_PROPERTY);
                    lrw2.insertFirst((ASTNode)matd2, null);
                }
            }
        }
        if (type.isSimpleType() && 255 != this.defaultStrLength && ("java.lang.String".equals(typeName = (simpleType = (SimpleType)type).getName().getFullyQualifiedName()) || "String".equals(typeName)) && ((rci = this.entityInfo.getRefColumnInfo(fieldId = returnIdentifier)) == null || !rci.isExist())) {
            NormalAnnotation natd = this.rewriter.getAST().newNormalAnnotation();
            natd.setTypeName((Name)this.rewriter.getAST().newSimpleName("Column"));
            ListRewrite lrw = this.rewriter.getListRewrite((ASTNode)node, MethodDeclaration.MODIFIERS2_PROPERTY);
            lrw.insertFirst((ASTNode)natd, null);
            MemberValuePair mvp = this.rewriter.getAST().newMemberValuePair();
            mvp.setName(this.rewriter.getAST().newSimpleName("length"));
            NumberLiteral nl = this.rewriter.getAST().newNumberLiteral(String.valueOf(this.defaultStrLength));
            mvp.setValue((Expression)nl);
            natd.values().add(mvp);
        }
        if (type.isSimpleType() || type.isParameterizedType() || type.isArrayType()) {
            String fieldId2 = "";
            RefType refType = RefType.UNDEF;
            boolean annotated = false;
            String fullyQualifiedName2 = "";
            fieldId2 = returnIdentifier;
            refType = this.entityInfo.getFieldIdRelValue(fieldId2);
            annotated = this.entityInfo.getFieldIdAnnotatedValue(fieldId2);
            fullyQualifiedName2 = this.entityInfo.getFieldIdFQNameValue(fieldId2);
            Set<RefFieldInfo> setRFI = this.entityInfo.getRefFieldInfoSet(fullyQualifiedName2);
            if (!annotated && setRFI != null && this.isSimilarType(type, fullyQualifiedName2)) {
                RefEntityInfo rei = this.entityInfo.getFieldIdRefEntityInfo(fieldId2);
                if (setRFI.size() > 1 && refType != RefType.MANY2ONE) {
                    if (rei.mappedBy == null || rei.mappedBy == "") {
                        this.addSimpleMarkerAnnotation((BodyDeclaration)node, JPAConst.getRefType(refType));
                    } else {
                        this.addComplexNormalAnnotation((BodyDeclaration)node, JPAConst.getRefType(refType), rei);
                    }
                } else if (refType == RefType.MANY2ONE || refType == RefType.ENUMERATED || rei.mappedBy == null || rei.mappedBy == "") {
                    this.addSimpleMarkerAnnotation((BodyDeclaration)node, JPAConst.getRefType(refType));
                } else {
                    this.addComplexNormalAnnotation((BodyDeclaration)node, JPAConst.getRefType(refType), rei);
                }
            }
        }
        return true;
    }

    public boolean isSimilarType(Type type, String fullyQualifiedName) {
        ArrayType at;
        Type elementType;
        String typeName = null;
        if (type.isSimpleType()) {
            SimpleType st = (SimpleType)type;
            typeName = st.getName().getFullyQualifiedName();
        } else if (type.isArrayType() && (elementType = (at = (ArrayType)type).getElementType()).isSimpleType()) {
            SimpleType st = (SimpleType)elementType;
            typeName = st.getName().getFullyQualifiedName();
        }
        return typeName == null || fullyQualifiedName.indexOf(typeName) != -1;
    }

    public boolean addSimpleMarkerAnnotation(BodyDeclaration node, String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        MarkerAnnotation matd = this.rewriter.getAST().newMarkerAnnotation();
        matd.setTypeName((Name)this.rewriter.getAST().newSimpleName(name));
        ListRewrite lrw = null;
        if (node instanceof FieldDeclaration) {
            lrw = this.rewriter.getListRewrite((ASTNode)node, FieldDeclaration.MODIFIERS2_PROPERTY);
        } else if (node instanceof MethodDeclaration) {
            lrw = this.rewriter.getListRewrite((ASTNode)node, MethodDeclaration.MODIFIERS2_PROPERTY);
        }
        if (lrw != null) {
            lrw.insertFirst((ASTNode)matd, null);
        }
        return true;
    }

    public boolean addComplexNormalAnnotation(BodyDeclaration node, String name, RefEntityInfo rei) {
        if (name == null || name.length() == 0) {
            return false;
        }
        NormalAnnotation natd = this.rewriter.getAST().newNormalAnnotation();
        MemberValuePair mvp = null;
        if (rei.mappedBy != null && (rei.owner == OwnerType.YES || rei.owner == OwnerType.UNDEF)) {
            mvp = this.rewriter.getAST().newMemberValuePair();
            mvp.setName(this.rewriter.getAST().newSimpleName("mappedBy"));
            StringLiteral sl = this.rewriter.getAST().newStringLiteral();
            sl.setLiteralValue(rei.mappedBy);
            mvp.setValue((Expression)sl);
        }
        natd.setTypeName((Name)this.rewriter.getAST().newSimpleName(name));
        if (mvp != null) {
            natd.values().add(mvp);
        }
        ASTNode natd2 = null;
        ListRewrite lrw = null;
        if (node instanceof FieldDeclaration) {
            lrw = this.rewriter.getListRewrite((ASTNode)node, FieldDeclaration.MODIFIERS2_PROPERTY);
        } else if (node instanceof MethodDeclaration) {
            lrw = this.rewriter.getListRewrite((ASTNode)node, MethodDeclaration.MODIFIERS2_PROPERTY);
        }
        if (lrw != null) {
            if (natd2 != null) {
                lrw.insertFirst(natd2, null);
            }
            lrw.insertFirst((ASTNode)natd, null);
        }
        return true;
    }

    public AnnotStyle getAnnotationStyle() {
        return this.annotationStyle;
    }

    public void setAnnotationStyle(AnnotStyle annotationStyle) {
        this.annotationStyle = annotationStyle;
    }

    public int getDefaultStrLength() {
        return this.defaultStrLength;
    }

    public void setDefaultStrLength(int defaultStrLength) {
        this.defaultStrLength = defaultStrLength;
    }

    public boolean getEnableOptLock() {
        return this.enableOptLock;
    }

    public void setEnableOptLock(boolean enableOptLock) {
        this.enableOptLock = enableOptLock;
    }
}

