/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.filesets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.archives.webtools.IntegrationPlugin;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.Fileset;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.tools.foundation.core.xml.IMemento;
import org.jboss.tools.foundation.core.xml.XMLMemento;

public class FilesetUtil {
    protected static final String FILESET_FILE_NAME = "filesets.xml";
    protected static IPath DEFAULT_FS_ROOT = JBossServerCorePlugin.getGlobalSettingsLocation().append("filesets").append("default");
    protected static String DEFAULT_FS_ALL_SERVERS = "org.jboss.ide.eclipse.archives.webtools.ui.allServers";

    public static Fileset[] loadFilesets(IServer server) {
        return FilesetUtil.loadFilesets(FilesetUtil.getFile(server), server);
    }

    public static Fileset[] loadFilesets(File file, IServer server) {
        if (file == null || !file.exists()) {
            return new Fileset[0];
        }
        try {
            return FilesetUtil.loadFilesets(new FileInputStream(file), server);
        }
        catch (FileNotFoundException fnfe) {
            return new Fileset[0];
        }
    }

    public static Fileset[] loadFilesets(InputStream is, IServer server) {
        Fileset[] sets = FilesetUtil.loadFilesets(is);
        if (sets != null) {
            int i = 0;
            while (i < sets.length) {
                sets[i].setServer(server);
                ++i;
            }
        }
        return sets;
    }

    public static Fileset[] loadFilesets(InputStream is) {
        Fileset[] filesets = null;
        XMLMemento memento = XMLMemento.createReadRoot((InputStream)is);
        IMemento[] categoryMementos = memento.getChildren("fileset");
        filesets = new Fileset[categoryMementos.length];
        int i = 0;
        while (i < categoryMementos.length) {
            String name = categoryMementos[i].getString("name");
            String folder = categoryMementos[i].getString("folder");
            String includes = categoryMementos[i].getString("includes");
            String excludes = categoryMementos[i].getString("excludes");
            filesets[i] = new Fileset(name, folder, includes, excludes);
            ++i;
        }
        return filesets;
    }

    public static void saveFilesets(IServer server, Fileset[] sets) {
        FilesetUtil.saveFilesets(FilesetUtil.getFile(server), sets);
    }

    public static void saveFilesets(File file, Fileset[] sets) {
        if (file != null) {
            file.getParentFile().mkdirs();
            XMLMemento memento = XMLMemento.createWriteRoot((String)"filesets");
            int i = 0;
            while (i < sets.length) {
                XMLMemento child = (XMLMemento)memento.createChild("fileset");
                child.putString("name", sets[i].getName());
                child.putString("folder", sets[i].getRawFolder());
                child.putString("includes", sets[i].getIncludesPattern());
                child.putString("excludes", sets[i].getExcludesPattern());
                ++i;
            }
            try {
                memento.save((OutputStream)new FileOutputStream(file));
            }
            catch (IOException ioe) {
                IntegrationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.archives.webtools", ioe.getMessage(), (Throwable)ioe));
            }
        }
    }

    public static File getFile(IServer server) {
        return JBossServerCorePlugin.getServerStateLocation((IServer)server).append(FILESET_FILE_NAME).toFile();
    }
}

