/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.IReferenceEditor;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.IWizardHandle;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.archives.webtools.filesets.vcf.WorkspaceFilesetVirtualComponent;

public class FilesetReferenceWizardFragment
extends WizardFragment
implements IReferenceEditor {
    private boolean hasEntered = false;
    private Text incText;
    private Text excText;
    private Text rootText;
    private String includes;
    private String excludes;
    private String folder;
    private WorkspaceFilesetVirtualComponent original;

    public boolean hasComposite() {
        return true;
    }

    public boolean isComplete() {
        return this.hasEntered;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.hasEntered = true;
        handle.setTitle(Messages.ReferenceWizard_title);
        handle.setDescription(Messages.ReferenceWizard_description);
        Composite child = new Composite(parent, 0);
        child.setLayout((Layout)new FormLayout());
        Text top = null;
        this.addLabel(Messages.FilesetsNewRootDir, child, (Control)top);
        top = this.rootText = this.addText(child, (Control)top, true);
        this.addLabel(Messages.FilesetsNewIncludes, child, (Control)top);
        top = this.incText = this.addText(child, (Control)top, false);
        this.addLabel(Messages.FilesetsNewExcludes, child, (Control)top);
        top = this.excText = this.addText(child, (Control)top, false);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilesetReferenceWizardFragment.this.textModified();
            }
        };
        IProject p = (IProject)this.getTaskModel().getObject("root.project");
        this.rootText.setText(p.getFullPath().toString());
        this.incText.setText("**");
        this.rootText.addModifyListener(listener);
        this.incText.addModifyListener(listener);
        this.excText.addModifyListener(listener);
        this.textModified();
        if (this.original != null) {
            this.rootText.setText(this.original.getRootFolderPath());
            this.incText.setText(this.original.getIncludes());
            this.excText.setText(this.original.getExcludes());
        }
        return child;
    }

    protected void textModified() {
        this.includes = this.incText.getText();
        this.excludes = this.excText.getText();
        this.folder = this.rootText.getText();
    }

    protected Text addText(Composite parent, Control top, boolean includeBrowse) {
        Text t = new Text(parent, 2048);
        Button b = null;
        if (includeBrowse) {
            b = new Button(parent, 0);
            b.setText(Messages.FilesetsNewBrowse);
            this.addBrowseListener(b, t);
            FormData bData = new FormData();
            bData.right = new FormAttachment(100, -5);
            bData.top = top == null ? new FormAttachment(0, 5) : new FormAttachment(top, 5);
            b.setLayoutData((Object)bData);
        }
        FormData fd = new FormData();
        fd.top = top == null ? new FormAttachment(0, 5) : new FormAttachment(top, 5);
        fd.left = new FormAttachment(25, 0);
        fd.right = b == null ? new FormAttachment(100, -5) : new FormAttachment((Control)b, -5);
        t.setLayoutData((Object)fd);
        return t;
    }

    protected void addBrowseListener(final Button b, final Text t) {
        b.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FilesetReferenceWizardFragment.this.browsePressed(b, t);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void browsePressed(Button b, Text t) {
        Object[] o;
        ContainerSelectionDialog d = new ContainerSelectionDialog(b.getShell(), null, false, "Please select a root folder");
        if (d.open() == 0 && (o = d.getResult()) != null && o.length > 0) {
            IPath path = (IPath)o[0];
            t.setText(path.toString());
        }
    }

    protected Label addLabel(String text, Composite parent, Control top) {
        Label l = new Label(parent, 0);
        l.setText(text);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.top = top == null ? new FormAttachment(0, 5) : new FormAttachment(top, 5);
        l.setLayoutData((Object)fd);
        return l;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IVirtualComponent comp = this.getFilesetComponent();
        IVirtualComponent rootComponent = (IVirtualComponent)this.getTaskModel().getObject("root.component");
        VirtualReference ref = new VirtualReference(rootComponent, comp);
        ref.setDependencyType(1);
        ref.setRuntimePath((IPath)new Path("/"));
        this.getTaskModel().putObject("dependency.reference.final", (Object)ref);
    }

    protected IVirtualComponent getFilesetComponent() {
        IVirtualComponent root = (IVirtualComponent)this.getTaskModel().getObject("root.component");
        WorkspaceFilesetVirtualComponent vc = new WorkspaceFilesetVirtualComponent(root.getProject(), root, new Path(this.folder).makeAbsolute().toString());
        vc.setIncludes(this.includes);
        vc.setExcludes(this.excludes);
        return vc;
    }

    public boolean canEdit(IVirtualReference vr) {
        IVirtualComponent vc = vr.getReferencedComponent();
        if (vc instanceof WorkspaceFilesetVirtualComponent) {
            this.original = (WorkspaceFilesetVirtualComponent)vc;
        }
        return this.original != null;
    }
}

