/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveType;
import org.jboss.ide.eclipse.archives.ui.providers.ArchivesContentProviderDelegate;
import org.jboss.ide.eclipse.archives.ui.providers.ArchivesLabelProvider;
import org.jboss.ide.eclipse.archives.ui.wizards.AbstractArchiveWizard;
import org.jboss.ide.eclipse.archives.ui.wizards.WizardPageWithNotification;
import org.jboss.ide.eclipse.archives.webtools.Messages;

public abstract class PreviewPage
extends WizardPageWithNotification {
    private Group previewGroup;
    protected AbstractArchiveWizard wizard;
    private TreeViewer previewViewer;
    private boolean hasCreated = false;

    public PreviewPage(AbstractArchiveWizard wizard, String name, String title, ImageDescriptor descriptor) {
        super(name, title, descriptor);
        this.wizard = wizard;
    }

    protected abstract String getDescriptionMessage();

    public void createControl(Composite parent) {
        this.setMessage(this.getDescriptionMessage());
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FormLayout());
        this.layoutGroups(main);
        this.fillGroups();
        this.setControl((Control)main);
    }

    protected void layoutGroups(Composite main) {
        this.previewGroup = new Group(main, 0);
        this.previewGroup.setText(Messages.Preview);
        FormData previewData = new FormData();
        previewData.left = new FormAttachment(0, 5);
        previewData.right = new FormAttachment(100, -5);
        previewData.top = new FormAttachment(0, 5);
        previewData.bottom = new FormAttachment(100, -5);
        this.previewGroup.setLayoutData((Object)previewData);
        this.previewGroup.setLayout((Layout)new FormLayout());
        this.previewViewer = new TreeViewer((Composite)this.previewGroup);
        this.previewViewer.setLabelProvider((IBaseLabelProvider)new ArchivesLabelProvider(1));
        this.previewViewer.setContentProvider((IContentProvider)new ArchivesContentProviderDelegate(false));
        FormData warPreviewData = new FormData();
        warPreviewData.left = new FormAttachment(0, 5);
        warPreviewData.right = new FormAttachment(100, -5);
        warPreviewData.top = new FormAttachment(0, 5);
        warPreviewData.bottom = new FormAttachment(100, -5);
        this.previewViewer.getTree().setLayoutData((Object)warPreviewData);
    }

    protected void fillGroups() {
    }

    public boolean isPageComplete() {
        return true;
    }

    public void pageEntered(int button) {
        this.addToPackage();
        this.fillWidgets(this.wizard.getArchive());
        IModuleArtifact[] moduleArtifacts = ServerPlugin.getModuleArtifacts((Object)this.wizard.getProject());
        if (moduleArtifacts != null && moduleArtifacts.length > 0) {
            FormData d = (FormData)this.previewGroup.getLayoutData();
            d.top = new FormAttachment(0, 5);
            this.previewGroup.setLayoutData((Object)d);
            ((Composite)this.getControl()).layout();
        }
        this.getWizard().getContainer().updateButtons();
    }

    protected void addToPackage() {
        if (!this.hasCreated) {
            this.hasCreated = true;
            String archiveTypeId = this.getArchiveTypeId();
            IArchiveType type = ArchivesCore.getInstance().getExtensionManager().getArchiveType(archiveTypeId);
            type.fillDefaultConfiguration(this.wizard.getProject().getName(), this.wizard.getArchive(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected abstract String getArchiveTypeId();

    protected void fillWidgets(IArchive pkg) {
        this.previewViewer.setInput((Object)pkg);
        this.previewViewer.expandAll();
    }

    protected IArchiveFolder getFolder(IArchive pkg, String folderName) {
        IArchiveFolder result = null;
        IArchiveFolder[] folders = pkg.getFolders();
        int i = 0;
        while (i < folders.length) {
            if (folders[i].getName().equals(folderName)) {
                result = folders[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public void pageExited(int button) {
        this.addToPackage();
    }

    public static class WorkspaceFolderSelectionDialog
    extends ElementTreeSelectionDialog {
        public WorkspaceFolderSelectionDialog(Shell parent, boolean allowMultiple, String selectedPaths) {
            super(parent, (ILabelProvider)new FolderLabelProvider(), (ITreeContentProvider)new FolderContentProvider());
            this.setAllowMultiple(allowMultiple);
            this.setupDestinationList();
            this.setupInitialSelections(selectedPaths);
        }

        private void setupDestinationList() {
            List<IProject> projects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
            this.setInput(projects);
        }

        private void setupInitialSelections(String initialSelection) {
            ArrayList<IResource> resources = new ArrayList<IResource>();
            String[] paths = initialSelection.split(",");
            int i = 0;
            while (i < paths.length) {
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(paths[i]);
                resources.add(res);
                ++i;
            }
            this.setInitialSelections(resources.toArray(new IResource[resources.size()]));
        }

        private static class FolderContentProvider
        implements ITreeContentProvider {
            private static final Object[] NO_CHILDREN = new Object[0];

            private FolderContentProvider() {
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IContainer) {
                    IContainer container = (IContainer)parentElement;
                    try {
                        IResource[] members = container.members();
                        ArrayList<IResource> folders = new ArrayList<IResource>();
                        int i = 0;
                        while (i < members.length) {
                            if (members[i].getType() == 2) {
                                folders.add(members[i]);
                            }
                            ++i;
                        }
                        return folders.toArray();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                return NO_CHILDREN;
            }

            public Object getParent(Object element) {
                if (element instanceof IContainer) {
                    return ((IContainer)element).getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                Object[] results = this.getChildren(element);
                return results != null && results.length > 0;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return NO_CHILDREN;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        public static class FolderLabelProvider
        implements ILabelProvider {
            public Image getImage(Object element) {
                if (element instanceof IProject) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                }
                if (element instanceof IFolder) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IContainer) {
                    return ((IContainer)element).getName();
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        }
    }
}

