/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.ejb3;

import java.io.FileNotFoundException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.classpath.core.ejb3.EJB3ClasspathContainer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;

public class EJB30SupportVerifier {
    protected static boolean definitelySupports(IRuntime rt) {
        IJBossServerRuntime jbRuntime = (IJBossServerRuntime)rt.loadAdapter(IJBossServerRuntime.class, null);
        String jbossVersion = jbRuntime.getRuntime().getRuntimeType().getVersion();
        return jbossVersion.compareTo("5.0") >= 0;
    }

    public static boolean verify(IRuntime rt) {
        if (rt == null) {
            return false;
        }
        IJBossServerRuntime jbRuntime = (IJBossServerRuntime)rt.loadAdapter(IJBossServerRuntime.class, null);
        if (jbRuntime == null) {
            return false;
        }
        if (EJB30SupportVerifier.definitelySupports(rt)) {
            return true;
        }
        if (rt.getRuntimeType().getVersion().equals("3.2")) {
            return false;
        }
        IPath serverHome = rt.getLocation();
        IPath configPath = jbRuntime.getConfigurationFullPath();
        try {
            if (rt.getRuntimeType().getVersion().equals("4.0")) {
                EJB3ClasspathContainer.get40Jars(serverHome, configPath);
            } else if (rt.getRuntimeType().getVersion().equals("4.2")) {
                EJB3ClasspathContainer.get42Jars(serverHome, configPath);
            }
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        return true;
    }
}

