/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ModuleSlot;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.RuntimeClasspathCache;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.RuntimeKey;

public class ModuleSlotCache {
    private static ModuleSlotCache instance = null;
    private Map<IFile, ModuleSlot[]> moduleSlotEntries = new HashMap<IFile, ModuleSlot[]>();
    private Map<IFile, Long> lastUpdated = new HashMap<IFile, Long>();
    private Map<RuntimeKey, ModuleSlot[]> defaultModuleSlots = new HashMap<RuntimeKey, ModuleSlot[]>();
    private Map<IProject, ArrayList<IFile>> manifests = new HashMap<IProject, ArrayList<IFile>>();
    private Map<IProject, ArrayList<IFile>> deploymentStructures = new HashMap<IProject, ArrayList<IFile>>();

    public static ModuleSlotCache getInstance() {
        if (instance == null) {
            instance = new ModuleSlotCache();
        }
        return instance;
    }

    ModuleSlotCache() {
    }

    public boolean hasInitializedManifests(IProject p) {
        return this.manifests.containsKey(p) && this.manifests.get(p) != null;
    }

    public boolean hasInitializedDeploymentStructures(IProject p) {
        return this.deploymentStructures.containsKey(p) && this.deploymentStructures.get(p) != null;
    }

    public void setManifests(IProject p, IFile[] manFiles) {
        this.manifests.put(p, new ArrayList<IFile>(Arrays.asList(manFiles)));
    }

    public void setDeploymentStructures(IProject p, IFile[] manFiles) {
        this.deploymentStructures.put(p, new ArrayList<IFile>(Arrays.asList(manFiles)));
    }

    public IFile[] getManifests(IProject p) {
        ArrayList<IFile> ret = this.manifests.get(p);
        if (ret != null) {
            return ret.toArray(new IFile[ret.size()]);
        }
        return null;
    }

    public IFile[] getDeploymentStructures(IProject p) {
        ArrayList<IFile> ret = this.deploymentStructures.get(p);
        if (ret != null) {
            return ret.toArray(new IFile[ret.size()]);
        }
        return null;
    }

    public void cache(IFile file, ModuleSlot[] ms) {
        this.lastUpdated.put(file, file.getLocation().toFile().lastModified());
        this.moduleSlotEntries.put(file, ms);
    }

    public ModuleSlot[] getEntries(IFile file) {
        return this.moduleSlotEntries.get(file);
    }

    public boolean isOutdated(IFile file) {
        boolean ret = false;
        Long o = this.lastUpdated.get(file);
        File f = file.getLocation().toFile();
        ret = !f.exists() && o != null ? true : o == null || !(o instanceof Long) || o < file.getLocation().toFile().lastModified();
        return ret;
    }

    public void cacheRuntimeModuleSlots(IRuntime runtime, ModuleSlot[] all) {
        RuntimeKey key = RuntimeClasspathCache.getRuntimeKey(runtime);
        this.defaultModuleSlots.put(key, all);
    }

    public ModuleSlot[] getRuntimeModuleSlots(IRuntime runtime) {
        RuntimeKey key = RuntimeClasspathCache.getRuntimeKey(runtime);
        return this.defaultModuleSlots.get(key);
    }

    public void clearRuntimeModuleSlots(IRuntime runtime) {
        RuntimeKey key = RuntimeClasspathCache.getRuntimeKey(runtime);
        this.defaultModuleSlots.remove(key);
    }
}

