/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.modules.manifest;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ModuleSlot;
import org.jboss.ide.eclipse.as.classpath.core.runtime.internal.PathProviderResolutionUtil;
import org.jboss.ide.eclipse.as.classpath.core.runtime.modules.manifest.AbstractModuleSlotUtil;
import org.jboss.ide.eclipse.as.classpath.core.runtime.modules.manifest.DeploymentStructureUtil;

public class DeploymentStructureEntryContainerInitializer
extends ClasspathContainerInitializer {
    public static final String PATH_SEGMENT = "org.jboss.ide.eclipse.as.classpath.core.runtime.modules.deploymentstructure";

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        int size = containerPath.segmentCount();
        if (size > 0) {
            DeploymentStructureEntryContainer container = this.createClasspathContainer(containerPath, project);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    protected DeploymentStructureEntryContainer createClasspathContainer(IPath path, IJavaProject jp) {
        return new DeploymentStructureEntryContainer(path, jp.getProject());
    }

    public static class DeploymentStructureEntryContainer
    implements IClasspathContainer {
        private IRuntime rt;
        private IPath path;
        private IProject p;

        public DeploymentStructureEntryContainer(IPath path, IProject p) {
            this(DeploymentStructureEntryContainer.getRuntime(path), p);
        }

        public DeploymentStructureEntryContainer(IRuntime rt, IProject p) {
            this.rt = rt;
            this.p = p;
        }

        protected static IRuntime getRuntime(IPath p) {
            String rtName;
            String string = rtName = p.segmentCount() > 1 ? p.segment(1) : null;
            if (rtName != null) {
                IRuntime rt = ServerCore.findRuntime((String)rtName);
                return rt;
            }
            return null;
        }

        public IClasspathEntry[] getClasspathEntries() {
            if (this.rt != null) {
                IRuntimePathProvider[] sets = this.getRuntimePathProviders();
                IPath[] paths = PathProviderResolutionUtil.getAllPaths(this.rt, sets);
                return PathProviderResolutionUtil.getClasspathEntriesForResolvedPaths(paths);
            }
            return new IClasspathEntry[0];
        }

        public IRuntimePathProvider[] getRuntimePathProviders() {
            ModuleSlot[] all = new DeploymentStructureUtil().getAllModuleSlots(this.p);
            IRuntimePathProvider[] sets = AbstractModuleSlotUtil.moduleSlotsAsProviders(all);
            return sets;
        }

        public String getDescription() {
            return "JBoss Modules - Deployment Structure Entries";
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.path;
        }
    }
}

