/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.modules.manifest;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ModuleSlot;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ModuleSlotCache;
import org.jboss.ide.eclipse.as.classpath.core.runtime.modules.manifest.AbstractModuleSlotUtil;
import org.jboss.tools.foundation.core.xml.IMemento;
import org.jboss.tools.foundation.core.xml.XMLMemento;

public class DeploymentStructureUtil
extends AbstractModuleSlotUtil {
    @Override
    protected void cacheFiles(IProject p, IFile[] files) {
        ModuleSlotCache.getInstance().setDeploymentStructures(p, files);
    }

    @Override
    protected boolean cacheInitializedProject(IProject p) {
        return ModuleSlotCache.getInstance().hasInitializedDeploymentStructures(p);
    }

    @Override
    protected IFile[] getCachedFiles(IProject p) {
        return ModuleSlotCache.getInstance().getDeploymentStructures(p);
    }

    @Override
    protected boolean isInitialized(IProject p) {
        return ModuleSlotCache.getInstance().hasInitializedDeploymentStructures(p);
    }

    @Override
    protected ModuleSlot[] calculateModuleSlots(IFile f) {
        ArrayList<ModuleSlot> collector = new ArrayList<ModuleSlot>();
        try {
            XMLMemento mem = XMLMemento.createReadRoot((InputStream)f.getContents());
            IMemento[] all = mem.getChildren();
            int i = 0;
            while (i < all.length) {
                IMemento[] deps = all[i].getChildren("dependencies");
                int j = 0;
                while (j < deps.length) {
                    IMemento[] modules = deps[j].getChildren("module");
                    int k = 0;
                    while (k < modules.length) {
                        String name = modules[k].getString("name");
                        String slot = modules[k].getString("slot");
                        if (name != null) {
                            collector.add(new ModuleSlot(name, slot));
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            return collector.toArray(new ModuleSlot[collector.size()]);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new ModuleSlot[0];
        }
    }

    @Override
    protected IFile[] locateRelevantFiles(IProject p) throws CoreException {
        return super.locateFiles(p, "jboss-deployment-structure.xml");
    }
}

