/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.xpl;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathCorePlugin;
import org.jboss.ide.eclipse.as.classpath.core.internal.Messages;
import org.jboss.ide.eclipse.as.classpath.core.xpl.ClasspathDecorations;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class ClasspathDecorationsManager {
    private static final String CLASSPATH_PREFERENCES = "classpathPreferences";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private final HashMap<String, HashMap<String, ClasspathDecorations>> decorations = this.read();

    private IEclipsePreferences getEclipsePreferences() {
        IEclipsePreferences node = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance").node("org.jboss.ide.eclipse.as.classpath.core");
        return node;
    }

    private String getPreferences() {
        return this.getEclipsePreferences().get(CLASSPATH_PREFERENCES, null);
    }

    public ClasspathDecorations getDecorations(String key, String entry) {
        HashMap<String, ClasspathDecorations> submap = this.decorations.get(key);
        if (submap == null) {
            return null;
        }
        return submap.get(entry);
    }

    public void setDecorations(String key, String entry, ClasspathDecorations dec) {
        HashMap<String, ClasspathDecorations> submap = this.decorations.get(key);
        if (submap == null) {
            submap = new HashMap();
            this.decorations.put(key, submap);
        }
        submap.put(entry, dec);
    }

    public void clearAllDecorations(String key) {
        this.decorations.remove(key);
    }

    public void save() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<classpath>");
        buffer.append(SEPARATOR);
        for (String k : this.decorations.keySet()) {
            Map submap = this.decorations.get(k);
            buffer.append("  <container id=\"");
            buffer.append(k);
            buffer.append("\">");
            buffer.append(SEPARATOR);
            for (String k2 : submap.keySet()) {
                ClasspathDecorations dec = (ClasspathDecorations)submap.get(k2);
                buffer.append("    <entry id=\"");
                buffer.append(k2);
                buffer.append("\">");
                buffer.append(SEPARATOR);
                String src = "";
                if (dec.getSourceAttachmentPath() != null) {
                    src = dec.getSourceAttachmentPath().toString();
                }
                buffer.append("      <source-attachment-path>");
                buffer.append(src);
                buffer.append("</source-attachment-path>");
                buffer.append(SEPARATOR);
                if (dec.getSourceAttachmentRootPath() != null) {
                    buffer.append("      <source-attachment-root-path>");
                    buffer.append(dec.getSourceAttachmentRootPath().toString());
                    buffer.append("</source-attachment-root-path>");
                    buffer.append(SEPARATOR);
                }
                IClasspathAttribute[] attrs = dec.getExtraAttributes();
                int i = 0;
                while (i < attrs.length) {
                    IClasspathAttribute attr = attrs[i];
                    buffer.append("      <attribute name=\"");
                    buffer.append(attr.getName());
                    buffer.append("\">");
                    buffer.append(attr.getValue());
                    buffer.append("</attribute>");
                    buffer.append(SEPARATOR);
                    ++i;
                }
                buffer.append("    </entry>");
                buffer.append(SEPARATOR);
            }
            buffer.append("  </container>");
            buffer.append(SEPARATOR);
        }
        buffer.append("</classpath>");
        buffer.append(SEPARATOR);
        IEclipsePreferences ep = this.getEclipsePreferences();
        ep.put(CLASSPATH_PREFERENCES, buffer.toString());
        try {
            ep.flush();
        }
        catch (BackingStoreException e) {
            String msg = Messages.ClasspathDecorationsManager_unexpected_exception;
            ClasspathCorePlugin.log(msg, e);
        }
    }

    private HashMap<String, HashMap<String, ClasspathDecorations>> read() {
        HashMap<String, HashMap<String, ClasspathDecorations>> map = new HashMap<String, HashMap<String, ClasspathDecorations>>();
        String prefs = this.getPreferences();
        if (prefs == null || prefs.length() <= 0) {
            return map;
        }
        Element root = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docbuilder = factory.newDocumentBuilder();
            StringReader reader = new StringReader(prefs);
            InputSource source = new InputSource(reader);
            root = docbuilder.parse(source).getDocumentElement();
        }
        catch (Exception e) {
            String msg = Messages.ClasspathDecorationsManager_unexpected_exception;
            ClasspathCorePlugin.log(msg, e);
            return map;
        }
        Iterator<Element> itr1 = ClasspathDecorationsManager.elements(root, "container");
        while (itr1.hasNext()) {
            Element e1 = itr1.next();
            String cid = e1.getAttribute("id");
            HashMap<String, ClasspathDecorations> submap = new HashMap<String, ClasspathDecorations>();
            map.put(cid, submap);
            Iterator<Element> itr2 = ClasspathDecorationsManager.elements(e1, "entry");
            while (itr2.hasNext()) {
                Element e2 = itr2.next();
                String eid = e2.getAttribute("id");
                ClasspathDecorations dec = new ClasspathDecorations();
                submap.put(eid, dec);
                Iterator<Element> itr3 = ClasspathDecorationsManager.elements(e2);
                while (itr3.hasNext()) {
                    Element e3 = itr3.next();
                    String n = e3.getNodeName();
                    String text = ClasspathDecorationsManager.text(e3);
                    if (text != null) {
                        if (n.equals("source-attachment-path")) {
                            dec.setSourceAttachmentPath((IPath)new Path(ClasspathDecorationsManager.text(e3)));
                        } else if (n.equals("source-attachment-root-path")) {
                            dec.setSourceAttachmentRootPath((IPath)new Path(ClasspathDecorationsManager.text(e3)));
                        }
                    }
                    if (!n.equals("attribute")) continue;
                    String name = e3.getAttribute("name");
                    dec.addExtraAttribute(name, ClasspathDecorationsManager.text(e3));
                }
            }
        }
        return map;
    }

    private static String text(Element el) {
        NodeList nodes = el.getChildNodes();
        String str = null;
        StringBuffer buf = null;
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 3) {
                String val = node.getNodeValue();
                if (buf != null) {
                    buf.append(val);
                } else if (str != null) {
                    buf = new StringBuffer();
                    buf.append(str);
                    buf.append(val);
                    str = null;
                } else {
                    str = val;
                }
            }
            ++i;
        }
        if (buf != null) {
            return buf.toString();
        }
        return str;
    }

    private static Iterator<Element> elements(Element el, String name) {
        return new ElementsIterator(el, name);
    }

    private static Iterator<Element> elements(Element el) {
        return new ElementsIterator(el, null);
    }

    private static final class ElementsIterator
    implements Iterator<Element> {
        private final NodeList nodes;
        private final int length;
        private final String name;
        private int position;
        private Element element;

        public ElementsIterator(Element parent, String name) {
            this.nodes = parent.getChildNodes();
            this.length = this.nodes.getLength();
            this.position = -1;
            this.name = name;
            this.advance();
        }

        private void advance() {
            this.element = null;
            ++this.position;
            while (this.position < this.length && this.element == null) {
                Node node = this.nodes.item(this.position);
                if (node.getNodeType() == 1 && (this.name == null || node.getNodeName().equals(this.name))) {
                    this.element = (Element)node;
                }
                ++this.position;
            }
        }

        @Override
        public boolean hasNext() {
            return this.element != null;
        }

        @Override
        public Element next() {
            Element el = this.element;
            if (el == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return el;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

