/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.descriptors;

import java.util.HashMap;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.tools.foundation.core.xml.IMemento;

public class XPathCategory {
    protected String name;
    protected IServer server;
    protected IMemento memento;
    protected HashMap<String, XPathQuery> children;

    public XPathCategory(String name, IServer server) {
        this.name = name;
        this.server = server;
        this.children = new HashMap();
    }

    public XPathCategory(IServer server, IMemento memento) {
        this.server = server;
        this.name = memento.getString("name");
        IMemento[] queryMementos = memento.getChildren("query");
        this.children = new HashMap();
        int i = 0;
        while (i < queryMementos.length) {
            String name = queryMementos[i].getString("name");
            XPathQuery child = new XPathQuery(queryMementos[i], server);
            this.children.put(name, child);
            child.setCategory(this);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public IServer getServer() {
        return this.server;
    }

    public boolean queriesLoaded() {
        return this.children != null;
    }

    public XPathQuery[] getQueries() {
        return this.children.values().toArray(new XPathQuery[this.children.size()]);
    }

    public XPathQuery getQuery(String name) {
        this.getQueries();
        return this.children.get(name);
    }

    public void addQuery(XPathQuery query) {
        this.getQueries();
        this.children.put(query.getName(), query);
        query.setCategory(this);
    }

    protected void renameQuery(String oldName, String newName) {
        this.getQueries();
        XPathQuery q = this.children.get(oldName);
        if (q != null) {
            this.children.remove(oldName);
            this.children.put(newName, q);
        }
    }

    public void removeQuery(XPathQuery query) {
        this.getQueries();
        this.children.remove(query.getName());
    }

    public boolean isLoaded() {
        return this.children != null;
    }

    public void clearCache() {
        if (this.isLoaded()) {
            XPathQuery[] allQueries = this.getQueries();
            int i = 0;
            while (i < allQueries.length) {
                allQueries[i].clearCache();
                ++i;
            }
        }
    }

    public void save() {
        XPathModel.getDefault().save(this.server);
    }
}

