/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.RuntimeDelegate;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.wtp.core.util.VMInstallUtil;

public abstract class AbstractLocalJBossServerRuntime
extends RuntimeDelegate
implements IJBossServerRuntime {
    public void setDefaults(IProgressMonitor monitor) {
        this.getRuntimeWorkingCopy().setName(this.getNextRuntimeName());
        this.setExecutionEnvironment(this.getDefaultExecutionEnvironment(this.getRuntime().getRuntimeType()));
        this.setVM(null);
    }

    protected String getNextRuntimeName() {
        return AbstractLocalJBossServerRuntime.getNextRuntimeName(this.getRuntimeNameBase());
    }

    protected String getRuntimeNameBase() {
        String version = this.getRuntime().getRuntimeType().getVersion();
        String base = String.valueOf(Messages.jboss) + " " + version + " " + Messages.runtime;
        return base;
    }

    public abstract String getDefaultRunArgs();

    public abstract String getDefaultRunVMArgs();

    public static String getNextRuntimeName(String base) {
        IRuntime rt = ServerCore.findRuntime((String)base);
        if (rt == null) {
            return base;
        }
        int i = 0;
        while (rt != null) {
            rt = ServerCore.findRuntime((String)(String.valueOf(base) + " " + ++i));
        }
        return String.valueOf(base) + " " + i;
    }

    public IVMInstall getHardVM() {
        if (this.getVMInstallTypeId() != null) {
            String id = this.getAttribute("PROPERTY_VM_ID", null);
            String type = this.getAttribute("PROPERTY_VM_TYPE_ID", null);
            return VMInstallUtil.findVMInstall((String)type, (String)id);
        }
        return null;
    }

    public IVMInstall getVM() {
        IVMInstall hard = this.getHardVM();
        if (hard != null) {
            return hard;
        }
        if (this.getExecutionEnvironment() != null) {
            return VMInstallUtil.findVMInstall((IExecutionEnvironment)this.getExecutionEnvironment());
        }
        return this.getDefaultVMInstall();
    }

    public void setVM(IVMInstall selectedVM) {
        if (selectedVM == null) {
            this.setAttribute("PROPERTY_VM_ID", null);
            this.setAttribute("PROPERTY_VM_TYPE_ID", null);
        } else {
            this.setAttribute("PROPERTY_VM_ID", selectedVM.getId());
            this.setAttribute("PROPERTY_VM_TYPE_ID", selectedVM.getVMInstallType().getId());
        }
    }

    public boolean isUsingDefaultJRE() {
        return this.getVMInstallTypeId() == null;
    }

    protected String getVMInstallTypeId() {
        return this.getAttribute("PROPERTY_VM_TYPE_ID", null);
    }

    protected IVMInstall getDefaultVMInstall() {
        IVMInstall i = this.getExecutionEnvironment().getDefaultVM();
        return i == null ? JavaRuntime.getDefaultVMInstall() : i;
    }

    public IVMInstall[] getValidJREs(IRuntimeType type) {
        return this.getValidJREs(this.getMinimumExecutionEnvironment(type), this.getMaximumExecutionEnvironment(type));
    }

    public IVMInstall[] getValidJREs(IExecutionEnvironment minimum, IExecutionEnvironment maximum) {
        return VMInstallUtil.getValidJREs((IExecutionEnvironment)minimum, (IExecutionEnvironment)maximum);
    }

    public IExecutionEnvironment getExecutionEnvironment() {
        String id = this.getAttribute("PROPERTY_EXEC_ENVIRONMENT", null);
        return id == null ? this.getDefaultExecutionEnvironment(this.getRuntime().getRuntimeType()) : JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(id);
    }

    public IExecutionEnvironment getDefaultExecutionEnvironment(IRuntimeType rtType) {
        ServerExtendedProperties sep = new ExtendedServerPropertiesAdapterFactory().getExtendedProperties(rtType);
        if (sep instanceof JBossExtendedProperties) {
            return ((JBossExtendedProperties)sep).getDefaultExecutionEnvironment();
        }
        return JavaRuntime.getExecutionEnvironmentsManager().getEnvironment("J2SE-1.4");
    }

    public IExecutionEnvironment getMinimumExecutionEnvironment(IRuntimeType rtType) {
        ServerExtendedProperties sep = new ExtendedServerPropertiesAdapterFactory().getExtendedProperties(rtType);
        if (sep instanceof JBossExtendedProperties) {
            return ((JBossExtendedProperties)sep).getMinimumExecutionEnvironment();
        }
        return this.getDefaultExecutionEnvironment(rtType);
    }

    public IExecutionEnvironment getMaximumExecutionEnvironment(IRuntimeType rtType) {
        ServerExtendedProperties sep = new ExtendedServerPropertiesAdapterFactory().getExtendedProperties(rtType);
        if (sep instanceof JBossExtendedProperties) {
            return ((JBossExtendedProperties)sep).getMaximumExecutionEnvironment();
        }
        return null;
    }

    public void setExecutionEnvironment(IExecutionEnvironment environment) {
        this.setAttribute("PROPERTY_EXEC_ENVIRONMENT", environment == null ? null : environment.getId());
    }
}

