/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServer;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.core.server.controllable.internal.DeployableServerBehavior;
import org.jboss.tools.as.core.server.controllable.systems.IPortsController;
import org.jboss.tools.jmx.core.IConnectionFacade;
import org.jboss.tools.jmx.core.IConnectionWrapper;

public class JBossServer
extends DeployableServer
implements IJBossServer,
IURLProvider,
IConnectionFacade {
    public static final String AUTOMATICALLY_UPDATE_LAUNCH = "org.jboss.ide.eclipse.as.core.server.internal.AUTOMATICALLY_UPDATE_LAUNCH";

    @Override
    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.IGNORE_LAUNCH_COMMANDS", false);
        this.setAttribute("auto-publish-time", 1);
        this.setAttribute("id", String.valueOf(this.getAttribute("id", "")) + new Date().getTime());
        this.setUsername("admin");
        boolean defaultServerDeployment = this.isAS50() || JBossServer.isEAP(this.getServer());
        this.setDeployLocationType(defaultServerDeployment ? "server" : "metadata");
        ServerProfileModel.setProfile((IServerWorkingCopy)this.getServerWorkingCopy(), (String)"local");
    }

    @Deprecated
    public static boolean isEAP(IServer server) {
        return RuntimeUtils.isEAP((IRuntimeType)server.getServerType().getRuntimeType());
    }

    private boolean isAS50() {
        IRuntimeType rtt = this.getServer().getServerType().getRuntimeType();
        return rtt == null ? false : rtt.getId().equals("org.jboss.ide.eclipse.as.50");
    }

    public String getHost() {
        return this.getServer().getHost();
    }

    @Override
    public String getConfigDirectory() {
        IJBossServerRuntime runtime = (IJBossServerRuntime)this.getServer().getRuntime().loadAdapter(IJBossServerRuntime.class, null);
        return runtime.getConfigurationFullPath().toOSString();
    }

    @Override
    public String getDeployFolder() {
        return this.getDeployFolder(this.getDeployLocationType());
    }

    public String getDeployFolder(String type) {
        if (type.equals("server")) {
            return this.getExtendedProperties().getServerDeployLocation();
        }
        return JBossServer.getDeployFolder(this, type);
    }

    public static String getDeployFolder(JBossServer jbs, String type) {
        String ret = null;
        if (type.equals("custom")) {
            ret = JBossServer.getCustomDeployLocationFromSettings(jbs.getServer(), "org.jboss.ide.eclipse.as.core.server.deployDirectory");
        }
        if (ret == null || type.equals("metadata")) {
            ret = JBossServer.getMetadataDeployLocation(jbs.getServer());
        }
        return ret;
    }

    public static String getCustomDeployLocationFromSettings(IServer server, String attribute) {
        String val = server.getAttribute(attribute, null);
        if (val != null) {
            Path val2 = new Path(val);
            return ServerUtil.makeGlobal(server.getRuntime(), (IPath)val2).toString();
        }
        return null;
    }

    public static String getMetadataDeployLocation(IServer server) {
        return JBossServerCorePlugin.getServerStateLocation(server).append("deploy").makeAbsolute().toString();
    }

    public JBossExtendedProperties getExtendedProperties() {
        return (JBossExtendedProperties)this.getServer().loadAdapter(ServerExtendedProperties.class, null);
    }

    @Override
    public String getTempDeployFolder() {
        return JBossServer.getTempDeployFolder(this, this.getDeployLocationType());
    }

    public static String getTempDeployFolder(JBossServer jbs, String type) {
        IServer server = jbs.getServer();
        IJBossServerRuntime jbsrt = RuntimeUtils.getJBossServerRuntime((IServerAttributes)server);
        if (type.equals("custom")) {
            return ServerUtil.makeGlobal(jbsrt.getRuntime(), (IPath)new Path(server.getAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", ""))).toString();
        }
        if (type.equals("metadata")) {
            return JBossServerCorePlugin.getServerStateLocation(server).append("tempDeploy").makeAbsolute().toString();
        }
        if (type.equals("server") && jbsrt != null) {
            String loc = jbsrt.getConfigLocation();
            String config = jbsrt.getJBossConfiguration();
            IPath p = new Path(loc).append(config).append("tmp").append("jbosstoolsTemp");
            return ServerUtil.makeGlobal(jbsrt.getRuntime(), p).toString();
        }
        return null;
    }

    public int getJNDIPort() {
        return this.findPort(100, 1099);
    }

    @Override
    protected int getWebPort() {
        return this.getJBossWebPort();
    }

    public int getJBossWebPort() {
        return this.findPort(101, 8080);
    }

    protected int getPortOffset() {
        return this.findPort(102, 0);
    }

    protected int findPort(int key, int defaultValue) {
        try {
            IPortsController pc = (IPortsController)JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)this.getServer()).getController("server.ports");
            if (pc != null) {
                return pc.findPort(key, defaultValue);
            }
        }
        catch (CoreException ce) {
            JBossServerCorePlugin.log(ce.getStatus());
        }
        catch (Throwable t) {
            JBossServerCorePlugin.log(t);
        }
        return defaultValue;
    }

    public String getUsername() {
        return this.getAttribute("org.jboss.ide.eclipse.as.core.server.userName", "admin");
    }

    public String getRawUsername() {
        return this.getAttribute("org.jboss.ide.eclipse.as.core.server.userName", null);
    }

    public void setUsername(String name) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.userName", name);
    }

    public String getPassword() {
        String s = ServerUtil.getFromSecureStorage((IServerAttributes)this.getServer(), "org.jboss.ide.eclipse.as.core.server.password");
        if (s == null) {
            return this.getAttribute("org.jboss.ide.eclipse.as.core.server.password", "admin");
        }
        return s;
    }

    public String getRawPassword() {
        String s = ServerUtil.getFromSecureStorage((IServerAttributes)this.getServer(), "org.jboss.ide.eclipse.as.core.server.password");
        if (s == null) {
            return this.getAttribute("org.jboss.ide.eclipse.as.core.server.password", null);
        }
        return s;
    }

    public void setPassword(String pass) {
        try {
            ServerUtil.storeInSecureStorage((IServerAttributes)this.getServer(), "org.jboss.ide.eclipse.as.core.server.password", pass);
        }
        catch (StorageException e) {
            JBossServerCorePlugin.log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Could not save password for server in secure storage.", (Throwable)e));
        }
        catch (UnsupportedEncodingException e) {
            JBossServerCorePlugin.log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Could not save password for server in secure storage.", (Throwable)e));
        }
    }

    @Override
    public boolean hasJMXProvider() {
        DeployableServerBehavior beh = (DeployableServerBehavior)((Object)this.getServer().loadAdapter(DeployableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor()));
        return beh != null;
    }

    public IConnectionWrapper getJMXConnection() {
        return (IConnectionWrapper)Platform.getAdapterManager().loadAdapter((Object)this, IConnectionWrapper.class.getName());
    }
}

