/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.launch.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.util.ArgsUtil;

public class JBossLaunchConfigProperties {
    private static final String SERVER_ID = "server-id";

    public void setClasspath(List<String> entries, ILaunchConfigurationWorkingCopy launchConfig) {
        if (this.isSet(entries)) {
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, entries);
        }
    }

    public boolean isClasspathSet(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH);
    }

    public void setUseDefaultClassPath(boolean useDefaultClassPath, ILaunchConfigurationWorkingCopy launchConfig) {
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, useDefaultClassPath);
    }

    public boolean isUseDefaultClasspath(ILaunchConfiguration launchConfig) throws CoreException {
        return this.isUseDefaultClasspath(launchConfig, true);
    }

    public boolean isUseDefaultClasspath(ILaunchConfiguration launchConfig, boolean defaultValue) throws CoreException {
        return launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, defaultValue);
    }

    public boolean isUseDefaultClasspathSet(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH);
    }

    public void setMainType(String mainType, ILaunchConfigurationWorkingCopy launchConfig) {
        if (this.isSet(mainType)) {
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
        }
    }

    public boolean isMainTypeSet(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        return launchConfig.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME);
    }

    public void setWorkingDirectory(String directory, ILaunchConfigurationWorkingCopy launchConfig) {
        if (this.isSet(directory)) {
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, directory);
        }
    }

    public boolean isWorkingDirectorySet(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY);
    }

    public String getServerId(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.getAttribute(SERVER_ID, null);
    }

    public void setHost(String host, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        String currentHost;
        if (this.isSet(host) && ((currentHost = this.getHost((ILaunchConfiguration)launchConfig)) == null || !host.equals(currentHost))) {
            String programArguments = this.getProgramArguments((ILaunchConfiguration)launchConfig);
            programArguments = ArgsUtil.setArg((String)programArguments, (String)"-b", (String)"--host", (String)host);
            this.setProgramArguments(programArguments, launchConfig);
        }
    }

    public boolean isHostSet(ILaunchConfiguration launchConfig) throws CoreException {
        String value = ArgsUtil.getValue((String)this.getProgramArguments(launchConfig), (String)"-b", (String)"--host");
        return value != null;
    }

    public void setProgramArguments(String programArguments, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArguments);
    }

    public String getProgramArguments(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
    }

    public boolean areProgramArgumentsSet(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS);
    }

    public boolean isConfigSet(ILaunchConfiguration launchConfig) throws CoreException {
        String value = ArgsUtil.getValue((String)this.getProgramArguments(launchConfig), (String)"-c", (String)"--configuration");
        return value != null;
    }

    public String getHost(ILaunchConfiguration launchConfig) throws CoreException {
        return ArgsUtil.getValue((String)this.getProgramArguments(launchConfig), (String)"-b", (String)"--host");
    }

    public void setConfig(String config, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        if (this.isSet(config)) {
            String programArguments = this.getProgramArguments((ILaunchConfiguration)launchConfig);
            programArguments = ArgsUtil.setArg((String)programArguments, (String)"-c", (String)"--configuration", (String)config);
            this.setProgramArguments(programArguments, launchConfig);
        }
    }

    public void setJreContainer(String vmContainerPath, ILaunchConfigurationWorkingCopy launchConfig) {
        if (this.isSet(vmContainerPath)) {
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, vmContainerPath);
        }
    }

    public boolean isJreContainerSet(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH);
    }

    public void setServerHome(String serverHome, IJBossServerRuntime runtime, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        if (this.isSet(serverHome)) {
            String programArguments = this.getProgramArguments((ILaunchConfiguration)launchConfig);
            String arguments = ArgsUtil.setArg((String)programArguments, null, (String)"-Djboss.server.base.url", (String)serverHome);
            this.setProgramArguments(arguments, launchConfig);
        }
    }

    public void setServerFlag(boolean useFlag, IJBossServerRuntime runtime, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        String programArguments = this.getVMArguments((ILaunchConfiguration)launchConfig);
        String newArgs = useFlag ? ArgsUtil.setFlag((String)programArguments, (String)"-server") : ArgsUtil.clearFlag((String)programArguments, (String)"-server");
        this.setVmArguments(newArgs, launchConfig);
    }

    public boolean isServerHomeSet(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        String value = ArgsUtil.getValue((String)this.getProgramArguments((ILaunchConfiguration)launchConfig), null, (String)"-Djboss.server.base.url");
        return value != null;
    }

    public void setClasspathProvider(String classpathProvider, ILaunchConfigurationWorkingCopy launchConfig) {
        if (this.isSet(classpathProvider)) {
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, classpathProvider);
        }
    }

    public boolean isClasspathProviderSet(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER);
    }

    public void setEndorsedDir(String endorsedDir, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        if (this.isSet(endorsedDir)) {
            String vmArguments = this.getVMArguments((ILaunchConfiguration)launchConfig);
            vmArguments = ArgsUtil.setArg((String)vmArguments, null, (String)"-Djava.endorsed.dirs", (String)("\"" + endorsedDir + "\""));
            this.setVmArguments(vmArguments, launchConfig);
        }
    }

    public void setJavaLibPath(String libPath, ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        if (this.isSet(libPath)) {
            String vmArguments = this.getVMArguments((ILaunchConfiguration)launchConfig);
            vmArguments = ArgsUtil.setArg((String)vmArguments, null, (String)"-Djava.library.path", (String)("\"" + libPath + "\""));
            this.setVmArguments(vmArguments, launchConfig);
        }
    }

    public boolean isEndorsedDirSet(ILaunchConfiguration launchConfig) throws CoreException {
        String value = ArgsUtil.getValue((String)this.getVMArguments(launchConfig), null, (String)"-Djava.endorsed.dirs");
        return value != null;
    }

    public void setVmArguments(String vmArguments, ILaunchConfigurationWorkingCopy launchConfig) {
        if (this.isSet(vmArguments)) {
            launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArguments);
        }
    }

    public String getVMArguments(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
    }

    public boolean areVMArgumentsSet(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        return launchConfig.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS);
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables, ILaunchConfigurationWorkingCopy launchConfig) {
        if (this.isSet(environmentVariables)) {
            launchConfig.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, environmentVariables);
        }
    }

    public boolean areEnvironmentVariablesSet(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.hasAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES);
    }

    public List<String> getClasspath(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, new ArrayList());
    }

    protected boolean isSet(String value) {
        return value != null && value.length() > 0;
    }

    protected boolean isSet(List<String> list) {
        return list != null;
    }

    protected boolean isSet(Map<String, String> map) {
        return map != null;
    }

    protected ServerBeanLoader getBeanLoader(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        IRuntime rt;
        IServer s;
        String serverId = this.getServerId((ILaunchConfiguration)launchConfig);
        if (serverId != null && (s = ServerCore.findServer((String)serverId)) != null && (rt = s.getRuntime()) != null) {
            IPath location = rt.getLocation();
            return new ServerBeanLoader(location.toFile());
        }
        return null;
    }

    public void setServerId(String serverId, ILaunchConfigurationWorkingCopy launchConfig) {
        if (this.isSet(serverId)) {
            launchConfig.setAttribute(SERVER_ID, serverId);
        }
    }

    public boolean isServerIdSet(ILaunchConfiguration launchConfig) throws CoreException {
        return launchConfig.hasAttribute(SERVER_ID);
    }
}

