/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.launch.configuration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.launch.configuration.JBossLaunchConfigProperties;
import org.jboss.ide.eclipse.as.core.util.IJBossRuntimeResourceConstants;
import org.jboss.ide.eclipse.as.core.util.LaunchConfigUtils;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.launch.LaunchConfiguratorWithOverrides;

public class LocalStopLaunchConfigurator
extends LaunchConfiguratorWithOverrides {
    public LocalStopLaunchConfigurator(IServer server) throws CoreException {
        super(server);
    }

    protected void doOverrides(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
    }

    protected void doConfigure(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        JBossLaunchConfigProperties props = new JBossLaunchConfigProperties();
        props.setProgramArguments(this.getDefaultProgramArguments(), launchConfig);
        props.setMainType(this.getMainType(), launchConfig);
        props.setWorkingDirectory(this.getWorkingDirectory(), launchConfig);
        props.setClasspath(this.getClasspath(new JBossLaunchConfigProperties().getClasspath((ILaunchConfiguration)launchConfig)), launchConfig);
        props.setUseDefaultClassPath(this.isUseDefaultClasspath(), launchConfig);
        props.setServerId(this.getServerId(this.server), launchConfig);
    }

    protected boolean isUseDefaultClasspath() {
        return false;
    }

    protected String getDefaultProgramArguments() throws CoreException {
        return this.getJBossServer().getExtendedProperties().getDefaultLaunchArguments().getDefaultStopArgs();
    }

    protected String getMainType() {
        return "org.jboss.Shutdown";
    }

    protected String getWorkingDirectory() throws CoreException {
        return ServerUtil.getServerBinDirectory(this.getJBossServer()).toOSString();
    }

    protected List<String> getClasspath(List<String> currentClasspath) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> classpath = new ArrayList<IRuntimeClasspathEntry>();
        LaunchConfigUtils.addCPEntry(ServerUtil.getServerHomePath(this.getJBossServer()), IJBossRuntimeResourceConstants.SHUTDOWN_JAR_LOC, classpath);
        LaunchConfigUtils.addJREEntry(this.getJBossRuntime().getVM(), classpath);
        return LaunchConfigUtils.toStrings(classpath);
    }

    protected JBossServer getJBossServer() {
        return (JBossServer)((Object)this.server.loadAdapter(JBossServer.class, (IProgressMonitor)new NullProgressMonitor()));
    }

    private IJBossServerRuntime getJBossRuntime() throws CoreException {
        return RuntimeUtils.checkedGetJBossServerRuntime((IRuntime)this.runtime);
    }
}

