/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.v7;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.internal.v7.IJBoss7Deployment;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;

public class DeploymentMarkerUtils {
    public static final String DEPLOYED = ".deployed";
    public static final String FAILED_DEPLOY = ".failed";
    public static final String DO_DEPLOY = ".dodeploy";
    public static final String DEPLOYING = ".isdeploying";
    public static final String UNDEPLOYING = ".isundeploying";
    public static final String UNDEPLOYED = ".undeployed";
    public static final String SKIP_DEPLOY = ".skipdeploy";
    public static final String PENDING = ".pending";

    public static boolean supportsJBoss7MarkerDeployment(IServer server) {
        return server.loadAdapter(IJBoss7Deployment.class, (IProgressMonitor)new NullProgressMonitor()) != null;
    }

    public static String getDeployedMarker(String file) {
        return String.valueOf(file) + DEPLOYED;
    }

    public static String getUndeployedMarker(String file) {
        return String.valueOf(file) + UNDEPLOYED;
    }

    public static String getFailedMarkerName(String file) {
        return String.valueOf(file) + FAILED_DEPLOY;
    }

    public static String getDoDeployMarkerName(String file) {
        return String.valueOf(file) + DO_DEPLOY;
    }

    public static IStatus removeDeployFailedMarker(IPath module, IFilesystemController controller) throws CoreException {
        IPath folder = module.removeLastSegments(1);
        IPath p = folder.append(DeploymentMarkerUtils.getFailedMarkerName(module.lastSegment()));
        return controller.deleteResource(p, (IProgressMonitor)new NullProgressMonitor());
    }

    @Deprecated
    public static IStatus removedDeployFailedMarker(IPath module, IFilesystemController controller) throws CoreException {
        return DeploymentMarkerUtils.removeDeployFailedMarker(module, controller);
    }

    @Deprecated
    public static IStatus removedDeployedMarker(IPath module, IFilesystemController controller) throws CoreException {
        return DeploymentMarkerUtils.removeDeployedMarker(module, controller);
    }

    public static IStatus removeDeployedMarker(IPath module, IFilesystemController controller) throws CoreException {
        IPath folder = module.removeLastSegments(1);
        IPath p = folder.append(DeploymentMarkerUtils.getDeployedMarker(module.lastSegment()));
        return controller.deleteResource(p, (IProgressMonitor)new NullProgressMonitor());
    }

    @Deprecated
    public static IStatus removedUndeployedMarker(IPath module, IFilesystemController controller) throws CoreException {
        return DeploymentMarkerUtils.removeUndeployedMarker(module, controller);
    }

    public static IStatus removeUndeployedMarker(IPath module, IFilesystemController controller) throws CoreException {
        IPath folder = module.removeLastSegments(1);
        IPath p = folder.append(DeploymentMarkerUtils.getUndeployedMarker(module.lastSegment()));
        return controller.deleteResource(p, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus removeDoDeployMarker(IPath module, IFilesystemController controller) throws CoreException {
        IPath folder = module.removeLastSegments(1);
        IPath p = folder.append(DeploymentMarkerUtils.getDoDeployMarkerName(module.lastSegment()));
        return controller.deleteResource(p, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus createDoDeployMarker(IPath module, IFilesystemController controller) throws CoreException {
        IPath folder = module.removeLastSegments(1);
        IPath p = folder.append(DeploymentMarkerUtils.getDoDeployMarkerName(module.lastSegment()));
        return controller.touchResource(p, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean markerExists(IPath module, IFilesystemController controller, String markerId) throws CoreException {
        IPath folder = module.removeLastSegments(1);
        IPath p = folder.append(String.valueOf(module.lastSegment()) + markerId);
        return controller.exists(p, (IProgressMonitor)new NullProgressMonitor());
    }
}

