/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.v7;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Trace;
import org.jboss.ide.eclipse.as.core.server.IServerModeDetails;
import org.jboss.ide.eclipse.as.core.server.internal.AbstractDeploymentScannerAdditions;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.v7.AS7DeploymentScannerUtility;

public class LocalJBoss7DeploymentScannerAdditions
extends AbstractDeploymentScannerAdditions {
    @Override
    public boolean accepts(IServer server) {
        ServerExtendedProperties props = (ServerExtendedProperties)server.loadAdapter(ServerExtendedProperties.class, null);
        boolean usesManagement = props != null && props.getMultipleDeployFolderSupport() == 3;
        IServerModeDetails det = (IServerModeDetails)Platform.getAdapterManager().getAdapter((Object)server, IServerModeDetails.class);
        return usesManagement && det != null;
    }

    @Override
    protected void ensureScannersAdded(IServer server, String[] folders) {
        Trace.trace("/finer", "Adding AS7 Deployment Scanners");
        ArrayList<String> asList = new ArrayList<String>();
        asList.addAll(Arrays.asList(folders));
        ArrayList<String> added = new ArrayList<String>();
        added.addAll(Arrays.asList(folders));
        ArrayList<String> removed = new ArrayList<String>();
        HashMap<String, String> props = null;
        AS7DeploymentScannerUtility.Scanner[] all = new AS7DeploymentScannerUtility().getDeploymentScannersBlocking(server, false);
        if (all == null) {
            return;
        }
        props = new AS7DeploymentScannerUtility().getDeploymentScannersFromServer(server, all);
        AS7DeploymentScannerUtility.Scanner defaultScanner = this.loadDefaultScannerFromServer(server);
        int existingScannerTimeout = defaultScanner == null ? 5000 : defaultScanner.getTimeout();
        int existingScannerInterval = defaultScanner == null ? -20 : defaultScanner.getInterval();
        Iterator lastStartup = props.keySet().iterator();
        String k = null;
        String v = null;
        while (lastStartup.hasNext()) {
            k = (String)lastStartup.next();
            v = (String)props.get(k);
            String withoutQuotes = v.trim();
            withoutQuotes = withoutQuotes.startsWith("\"") ? withoutQuotes.substring(1) : withoutQuotes;
            String string = withoutQuotes = withoutQuotes.endsWith("\"") ? withoutQuotes.substring(0, withoutQuotes.length() - 1) : withoutQuotes;
            if (!asList.contains(v) && !asList.contains(withoutQuotes)) {
                removed.add(k);
                continue;
            }
            added.remove(withoutQuotes);
            Trace.trace("/finest", "Unchanged Deployment Scanner " + k + ":" + v);
        }
        AS7DeploymentScannerUtility util = new AS7DeploymentScannerUtility();
        Iterator i = removed.iterator();
        String scannerName = null;
        while (i.hasNext()) {
            scannerName = (String)i.next();
            IStatus s = util.removeDeploymentScanner(server, scannerName);
            if (s.isOK()) {
                props.remove(scannerName);
            }
            Trace.trace("/finer", "Removed Deployment Scanner: success=" + s.isOK() + ", " + scannerName + ":" + (String)props.get(scannerName));
        }
        int defaultInterval = server.getAttribute("org.jboss.ide.eclipse.as.core.server.deploymentscanner.interval", existingScannerInterval);
        int defaultTimeout = server.getAttribute("org.jboss.ide.eclipse.as.core.server.deploymentscanner.timeout", existingScannerTimeout);
        for (String path : added) {
            String newScannerName = this.findNextScannerName(props);
            IStatus s = util.addDeploymentScanner(server, newScannerName, path, defaultInterval, defaultTimeout);
            if (s.isOK()) {
                props.put(newScannerName, path);
            }
            Trace.trace("/finer", "Added Deployment Scanner: success=" + s.isOK() + ", " + scannerName + ":" + (String)props.get(newScannerName));
        }
        Trace.trace("/finer", "Finished Adding AS7 Deployment Scanners");
    }

    private Map<String, String> loadScannersFromServerSafely(IServer server) {
        Map<String, String> props = null;
        Exception e2 = null;
        try {
            props = this.loadScannersFromServer(server);
        }
        catch (Exception e) {
            e2 = e;
        }
        if (props == null) {
            JBossServerCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Unable to retrieve a list of remote deployment scanners", (Throwable)e2));
            return new HashMap<String, String>();
        }
        return props;
    }

    @Override
    protected void ensureScannersRemoved(IServer server, String[] folders) {
        Map<String, String> props = this.loadScannersFromServerSafely(server);
        AS7DeploymentScannerUtility util = new AS7DeploymentScannerUtility();
        for (String scannerName : props.keySet()) {
            if (!scannerName.startsWith("jbosstoolsscanner")) continue;
            util.removeDeploymentScanner(server, scannerName);
        }
    }

    protected void setAllScannerEnablement(IServer server, boolean state) {
        Map<String, String> props = this.loadScannersFromServerSafely(server);
        AS7DeploymentScannerUtility util = new AS7DeploymentScannerUtility();
        for (String scannerName : props.keySet()) {
            util.setScannerEnabled(server, scannerName, state);
        }
    }

    protected Map<String, String> loadScannersFromServer(IServer server) throws Exception {
        return new AS7DeploymentScannerUtility().getDeploymentScannersFromServer(server, false, false, true);
    }

    protected AS7DeploymentScannerUtility.Scanner loadDefaultScannerFromServer(IServer server) {
        return new AS7DeploymentScannerUtility().getDefaultDeploymentScanner(server);
    }

    protected String findNextScannerName(Map<String, String> props) {
        int i = 1;
        while (props.get("jbosstoolsscanner" + i) != null) {
            ++i;
        }
        return "jbosstoolsscanner" + i;
    }

    @Override
    public boolean persistsScannerChanges() {
        return true;
    }

    @Override
    public boolean canCustomizeInterval() {
        return true;
    }

    @Override
    public boolean canCustomizeTimeout() {
        return true;
    }

    public void suspendScanners(IServer server) throws UnsupportedOperationException {
        this.setAllScannerEnablement(server, false);
    }

    public void resumeScanners(IServer server) throws UnsupportedOperationException {
        this.setAllScannerEnablement(server, true);
    }
}

