/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.v7;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.jboss.ide.eclipse.as.core.server.internal.LocalJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.util.IJBossRuntimeConstants;

public class LocalJBoss7ServerRuntime
extends LocalJBossServerRuntime
implements IJBossRuntimeConstants {
    public static final String CONFIG_FILE = "org.jboss.ide.eclipse.as.core.server.internal.v7.CONFIG_FILE";
    public static final String CONFIG_FILE_DEFAULT = "standalone.xml";
    public static final String BASE_DIRECTORY = "org.jboss.ide.eclipse.as.core.server.internal.v7.BASE_DIRECTORY";

    @Override
    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        this.setAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationName", "");
    }

    @Override
    public IStatus validate() {
        return Status.OK_STATUS;
    }

    @Override
    public String getDefaultRunArgs() {
        return this.getDefaultRunArgs(this.getRuntime().getLocation());
    }

    @Override
    public String getDefaultRunArgs(IPath serverHome) {
        return this.getExtendedProperties().getDefaultLaunchArguments().getStartDefaultProgramArgs();
    }

    @Override
    public String getDefaultRunVMArgs(IPath serverHome) {
        return this.getExtendedProperties().getDefaultLaunchArguments().getStartDefaultVMArgs();
    }

    @Override
    public String getDefaultRunVMArgs() {
        IPath loc = this.getRuntime().getLocation();
        return this.getDefaultRunVMArgs(loc);
    }

    public String getConfigurationFile() {
        return this.getAttribute(CONFIG_FILE, CONFIG_FILE_DEFAULT);
    }

    public void setConfigurationFile(String file) {
        this.setAttribute(CONFIG_FILE, file);
    }

    public String getConfigurationFileFullPath() {
        String configFile = this.getConfigurationFile();
        if (new Path(configFile).isAbsolute()) {
            return configFile;
        }
        IPath configFolder = new Path(this.getBaseDirectory()).append("configuration");
        return configFolder.append(configFile).toFile().getAbsolutePath();
    }

    public String getBaseDirectory() {
        String bd = this.getAttribute(BASE_DIRECTORY, "standalone");
        Path p = new Path(bd);
        if (p.isAbsolute()) {
            return p.toFile().getAbsolutePath();
        }
        if (this.getRuntime() == null || this.getRuntime().getLocation() == null) {
            return "standalone";
        }
        if (this.getRuntime().getLocation().equals((Object)new Path(""))) {
            return "standalone";
        }
        return this.getRuntime().getLocation().append((IPath)p).toFile().getAbsolutePath();
    }

    public String getRawBaseDirectory() {
        return this.getAttribute(BASE_DIRECTORY, "standalone");
    }

    public void setBaseDirectory(String s) {
        this.setAttribute(BASE_DIRECTORY, s);
    }

    @Override
    public String getConfigLocation() {
        return new Path(this.getBaseDirectory()).append("configuration").toFile().getAbsolutePath();
    }

    @Override
    public String getJBossConfiguration() {
        return "";
    }
}

