/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.launch;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.osgi.util.NLS;

public class LocalCommandLineRunner {
    public static final String PROCESS_TYPE = "LocalCommandLine";

    public IProcess launchCommand(String command, IProgressMonitor monitor) throws CoreException {
        Launch l = new Launch(null, "run", null);
        return this.launchCommand(command, (ILaunch)l, monitor);
    }

    public IProcess launchCommand(String command, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Process p = this.createProcessForCommand(command, monitor);
        if (p != null) {
            String[] cmdLine = new String[]{command};
            return this.getIProcessForProcess(cmdLine, launch, null, null, p);
        }
        return null;
    }

    private Process createProcessForCommand(String cmdLine, IProgressMonitor monitor) throws CoreException {
        Process p = this.exec(cmdLine);
        if (p == null) {
            return null;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return null;
        }
        return p;
    }

    private IProcess getIProcessForProcess(String[] cmdLine, ILaunch launch, File workingDir, String[] envp, Process p) throws CoreException {
        String timestamp = DateFormat.getDateTimeInstance(2, 2).format(new Date(System.currentTimeMillis()));
        IProcess process = this.newProcess(launch, p, LocalCommandLineRunner.renderProcessLabel(cmdLine, timestamp), this.getDefaultProcessMap());
        process.setAttribute("org.eclipse.debug.core.ATTR_PATH", cmdLine[0]);
        process.setAttribute(IProcess.ATTR_CMDLINE, this.renderCommandLine(cmdLine));
        String ltime = launch == null ? null : launch.getAttribute("org.eclipse.debug.core.launch.timestamp");
        process.setAttribute("org.eclipse.debug.core.launch.timestamp", ltime != null ? ltime : timestamp);
        if (workingDir != null) {
            process.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", workingDir.getAbsolutePath());
        }
        if (envp != null) {
            Arrays.sort(envp);
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < envp.length) {
                buff.append(envp[i]);
                if (i < envp.length - 1) {
                    buff.append('\n');
                }
                ++i;
            }
            process.setAttribute("org.eclipse.debug.core.ATTR_ENVIRONMENT", buff.toString());
        }
        return process;
    }

    protected String renderCommandLine(String[] commandLine) {
        return DebugPlugin.renderArguments((String[])commandLine, null);
    }

    public static String renderProcessLabel(String[] commandLine, String timestamp) {
        String format = LaunchingMessages.StandardVMRunner__0____1___2;
        return NLS.bind((String)format, (Object[])new String[]{commandLine[0], timestamp});
    }

    protected Map<String, String> getDefaultProcessMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(IProcess.ATTR_PROCESS_TYPE, PROCESS_TYPE);
        return map;
    }

    protected IProcess newProcess(ILaunch launch, Process p, String label, Map<String, String> attributes) throws CoreException {
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)label, attributes);
        if (process == null) {
            p.destroy();
            this.abort(LaunchingMessages.AbstractVMRunner_0, null, 150);
        }
        return process;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", code, message, exception));
    }

    private static boolean needsQuoting(String s) {
        int len = s.length();
        if (len == 0) {
            return true;
        }
        int i = 0;
        while (i < len) {
            switch (s.charAt(i)) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '\\': {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static String winQuote(String s) {
        if (!LocalCommandLineRunner.needsQuoting(s)) {
            return s;
        }
        s = s.replaceAll("([\\\\]*)\"", "$1$1\\\\\"");
        s = s.replaceAll("([\\\\]*)\\z", "$1$1");
        return "\"" + s + "\"";
    }

    private static String[] quoteWindowsArgs(String[] cmdLine) {
        if (Platform.getOS().equals("win32")) {
            String[] winCmdLine = new String[cmdLine.length];
            int i = 0;
            while (i < cmdLine.length) {
                winCmdLine[i] = LocalCommandLineRunner.winQuote(cmdLine[i]);
                ++i;
            }
            cmdLine = winCmdLine;
        }
        return cmdLine;
    }

    protected Process exec(String cmdLine) throws CoreException {
        cmdLine = LocalCommandLineRunner.quoteWindowsArgs(new String[]{cmdLine})[0];
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmdLine);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0, DebugCoreMessages.DebugPlugin_0, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (NoSuchMethodError e) {
            Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0, DebugCoreMessages.DebugPlugin_0, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        return p;
    }
}

