/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IServerModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.server.internal.RecentlyUpdatedServerLaunches;
import org.jboss.ide.eclipse.as.core.server.internal.UpdateModuleStateJob;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.CachedPublisherProfileBehavior;

public class DeployableServerBehavior
extends CachedPublisherProfileBehavior {
    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        RecentlyUpdatedServerLaunches.getDefault().setRecentServer(this.getServer());
        super.setupLaunchConfiguration(workingCopy, monitor);
    }

    public void setServerStarted() {
        super.setServerStarted();
        this.launchPostStartupJobs();
    }

    protected void launchPostStartupJobs() {
        IServer s = this.getServer();
        JBossExtendedProperties properties = (JBossExtendedProperties)s.loadAdapter(JBossExtendedProperties.class, null);
        if (properties != null) {
            Job rootJob;
            Job scannerJob = null;
            boolean addScanners = this.getServer().getAttribute("org.jboss.ide.eclipse.as.core.server.addDeploymentScanner", true);
            if (addScanners) {
                scannerJob = properties.getDeploymentScannerModifier().getUpdateDeploymentScannerJob(s);
            }
            IServerModuleStateVerifier verifier = properties.getModuleStateVerifier();
            UpdateModuleStateJob moduleStateJob = null;
            if (verifier != null) {
                moduleStateJob = new UpdateModuleStateJob(s, verifier, true, 10000);
            }
            if ((rootJob = this.chainJobs(scannerJob, moduleStateJob)) != null) {
                rootJob.schedule();
            }
        }
    }

    private Job chainJobs(final Job job1, final Job job2) {
        if (job1 == null) {
            return job2;
        }
        if (job2 == null) {
            return job1;
        }
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                job1.removeJobChangeListener((IJobChangeListener)this);
                if (job2 != null && event.getResult() != null && event.getResult().getSeverity() != 4 && event.getResult().getSeverity() != 8) {
                    job2.schedule();
                }
            }
        };
        job1.addJobChangeListener((IJobChangeListener)listener);
        return job1;
    }
}

