/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.ILaunchConfigConfigurator;
import org.jboss.ide.eclipse.as.core.server.ILaunchConfigConfiguratorProvider;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.launch.StandardLocalJBossStartLaunchDelegate;
import org.jboss.ide.eclipse.as.core.server.internal.launch.configuration.LocalJBossStartLaunchConfigurator;
import org.jboss.ide.eclipse.as.core.server.internal.v7.LocalJBoss7StartConfigurator;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ILaunchServerController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IShutdownControllerDelegate;
import org.jboss.tools.as.core.server.controllable.subsystems.internal.LocalLegacyShutdownController;

public class LocalJBossLaunchController
extends AbstractSubsystemController
implements ILaunchServerController,
ILaunchConfigurationDelegate2,
IShutdownControllerDelegate,
ILaunchConfigConfiguratorProvider {
    private StandardLocalJBossStartLaunchDelegate launchDelegate;

    private StandardLocalJBossStartLaunchDelegate getLaunchDelegate() {
        if (this.launchDelegate == null) {
            this.launchDelegate = new StandardLocalJBossStartLaunchDelegate();
        }
        return this.launchDelegate;
    }

    public IStatus canStart(String launchMode) {
        return Status.OK_STATUS;
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigConfigurator configurator = this.getConfigurator();
        if (configurator != null) {
            configurator.configure(workingCopy);
        }
    }

    private ILaunchConfigConfigurator getConfigurator() throws CoreException {
        JBossExtendedProperties props = ExtendedServerPropertiesAdapterFactory.getJBossExtendedProperties((IServerAttributes)this.getServer());
        int fs = props.getFileStructure();
        if (fs == 1) {
            return new LocalJBossStartLaunchConfigurator(this.getServer());
        }
        if (fs == 2) {
            return new LocalJBoss7StartConfigurator(this.getServer());
        }
        return null;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.getLaunchDelegate().launch(configuration, mode, launch, monitor);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.getLaunchDelegate().getLaunch(configuration, mode);
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getLaunchDelegate().buildForLaunch(configuration, mode, monitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getLaunchDelegate().finalLaunchCheck(configuration, mode, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getLaunchDelegate().preLaunchCheck(configuration, mode, monitor);
    }

    public IServerShutdownController getShutdownController() {
        LocalLegacyShutdownController c = new LocalLegacyShutdownController();
        c.initialize((IServerAttributes)this.getServer(), null, null);
        return c;
    }

    public ILaunchConfigConfigurator getLaunchConfigurator() throws CoreException {
        return this.getConfigurator();
    }
}

