/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.Trace;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.publishers.JSTPublisherXMLToucher;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilterProvider;
import org.jboss.ide.eclipse.as.core.server.internal.UpdateModuleStateJob;
import org.jboss.ide.eclipse.as.core.server.internal.v7.DeploymentMarkerUtils;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.wtp.core.modules.filter.patterns.ComponentModuleInclusionFilterUtility;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPrimaryPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishControllerDelegate;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.util.PublishControllerUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.BinaryModulePublishRunner;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.LocalZippedModulePublishRunner;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.ModulePublishErrorCache;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.PublishModuleFullRunner;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.PublishModuleIncrementalRunner;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentZipOptionsController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleRestartBehaviorController;

public class StandardFileSystemPublishController
extends AbstractSubsystemController
implements IPublishController,
IPrimaryPublishController {
    private IModuleStateController moduleStateController;
    private boolean moduleStateControllerLoadFailed = false;
    private IModuleRestartBehaviorController restartController;
    private boolean restartControllerLoadFailed = false;
    private IDeploymentOptionsController deploymentOptions;
    private IModuleDeployPathController deployPathController;
    private IFilesystemController filesystemController;
    private HashMap<IModule[], Integer> publishType = new HashMap();
    private HashMap<IModule[], Boolean> requiresRestart = new HashMap();

    protected IModuleRestartBehaviorController getModuleRestartBehaviorController() throws CoreException {
        if (this.restartController == null && !this.restartControllerLoadFailed) {
            try {
                this.restartController = (IModuleRestartBehaviorController)this.findDependencyFromBehavior("module.restart.behavior");
            }
            catch (CoreException ce) {
                this.restartControllerLoadFailed = true;
            }
        }
        return this.restartController;
    }

    protected IModuleStateController getModuleStateController() throws CoreException {
        if (this.moduleStateController == null && !this.moduleStateControllerLoadFailed) {
            try {
                this.moduleStateController = (IModuleStateController)this.findDependencyFromBehavior("modules");
            }
            catch (CoreException ce) {
                this.moduleStateControllerLoadFailed = true;
            }
        }
        return this.moduleStateController;
    }

    protected IDeploymentOptionsController getDeploymentOptions() throws CoreException {
        if (this.deploymentOptions == null) {
            this.deploymentOptions = (IDeploymentOptionsController)this.findDependencyFromBehavior("deploymentOptions");
        }
        return this.deploymentOptions;
    }

    protected IModuleDeployPathController getDeployPathController() throws CoreException {
        if (this.deployPathController == null) {
            return (IModuleDeployPathController)this.findDependencyFromBehavior("moduleDeployPath");
        }
        return this.deployPathController;
    }

    protected IFilesystemController getFilesystemController() throws CoreException {
        if (this.filesystemController == null) {
            this.filesystemController = (IFilesystemController)this.findDependencyFromBehavior("filesystem");
        }
        return this.filesystemController;
    }

    public IStatus validate() {
        try {
            IStatus sup = super.validate();
            if (!sup.isOK()) {
                return sup;
            }
            this.getDeploymentOptions();
            this.getDeployPathController();
            this.getFilesystemController();
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public IStatus canPublish() {
        IStatus s = this.validate();
        if (!s.isOK()) {
            return s;
        }
        return Status.OK_STATUS;
    }

    public boolean canPublishModule(IModule[] module) {
        IStatus s = this.validate();
        return s.isOK();
    }

    public void publishStart(IProgressMonitor monitor) throws CoreException {
        Trace.trace("/finer", "publishStart called on server " + this.getServer().getName());
        IStatus s = this.validate();
        if (s != null && !s.isOK()) {
            throw new CoreException(s);
        }
    }

    public void publishFinish(IProgressMonitor monitor) throws CoreException {
        Trace.trace("/finer", "publishFinish called on server " + this.getServer().getName());
        this.validate();
        IServer s = this.getServer();
        this.ensureModulesRestarted();
        ((Server)s).setServerPublishState(this.getUpdatedPublishState(s));
        this.launchUpdateModuleStateJob();
    }

    protected void launchUpdateModuleStateJob() throws CoreException {
        IModuleStateController c = this.getModuleStateController();
        if (c != null && this.getServer().getServerState() == 2) {
            Trace.trace("/finer", "launching job to update module state for server " + this.getServer().getName());
            new UpdateModuleStateJob(c, this.getServer(), true, 15000).schedule(5000L);
        }
    }

    private int getUpdatedPublishState(IServer server) {
        IModule[] modules = server.getModules();
        boolean allpublished = true;
        int i = 0;
        while (i < modules.length) {
            if (server.getModulePublishState(new IModule[]{modules[i]}) != 1) {
                allpublished = false;
            }
            ++i;
        }
        if (allpublished) {
            return 1;
        }
        return 2;
    }

    private String moduleToString(IModule[] mod) throws CoreException {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < mod.length) {
            if (mod[i] == null) {
                Status s = new Status(4, "org.jboss.ide.eclipse.as.core", "Server " + this.getServer().getName() + " has been asked to publish a null module: " + sb.append((String)null).toString());
                throw new CoreException((IStatus)s);
            }
            sb.append(mod[i].getName());
            if (i < mod.length) {
                sb.append(",   ");
            }
            ++i;
        }
        return sb.toString();
    }

    public int publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        Trace.trace("/finer", NLS.bind((String)"publishModule called on server {0} with kind={1}, deltaKind={2}, module of size {3}: {4}", (Object[])new Object[]{this.getServer().getName(), kind, deltaKind, module.length, this.moduleToString(module)}));
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        this.validate();
        IPublishControllerDelegate delegate = PublishControllerUtil.findDelegatePublishController((IServer)this.getServer(), (IModule[])module, (boolean)true);
        if (delegate != null) {
            Trace.trace("/finer", "   Publish delegate for module type " + module[module.length - 1].getModuleType().getName());
            return delegate.publishModule(kind, deltaKind, module, (IProgressMonitor)subMonitor.split(1));
        }
        boolean isBinaryObject = this.treatAsBinaryModule(module);
        Trace.trace("/finer", "   Module " + module[module.length - 1].getName() + " is binary? " + isBinaryObject);
        boolean serverPrefersZipped = this.prefersZipped();
        Trace.trace("/finer", "   Server " + this.getServer().getName() + " prefers zipped deployment? " + serverPrefersZipped);
        IPath archiveDestination = this.getModuleDeployRoot(module, isBinaryObject);
        Trace.trace("/finer", "   Archive destination: " + archiveDestination.toString());
        boolean anyDeleted = ServerModelUtilities.isAnyDeleted((IModule[])module);
        int publishType = PublishControllerUtil.getPublishType((IServer)this.getServer(), (IModule[])module, (int)kind, (int)deltaKind);
        if (publishType == 3) {
            if (!isBinaryObject) {
                Trace.trace("/finer", "   Removing module: " + module[module.length - 1].getName());
                return this.removeModule(module, archiveDestination, (IProgressMonitor)subMonitor.split(1));
            }
            Trace.trace("/finer", "   Removing binary module: " + module[module.length - 1].getName());
            return this.handlePublishBinaryModule(module, archiveDestination, anyDeleted, publishType, (IProgressMonitor)subMonitor.split(1));
        }
        if (anyDeleted) {
            Trace.trace("/finer", "   Module or parent module is a wtp 'deleted module' (aka missing/deleted /closed project). No Action Taken. Returning state=unknown ");
            return 0;
        }
        boolean modulePrefersZipped = this.forceZipModule(module);
        boolean forzeZipAnyParent = this.parentModuleIsForcedZip(module);
        if (forzeZipAnyParent) {
            Trace.trace("/finer", "   Parent module already published and zipped. Ignoring this call");
            return 1;
        }
        if (!isBinaryObject && modulePrefersZipped) {
            Trace.trace("/finer", "   Non-Binary module setting prefers zipped deployment.");
            return this.handleZippedPublish(module, publishType, archiveDestination, true, (IProgressMonitor)subMonitor.split(1));
        }
        IStatus[] ret = null;
        String msgForFailure = null;
        IModulePathFilter filter = ComponentModuleInclusionFilterUtility.findDefaultModuleFilter((IModule)module[module.length - 1]);
        if (isBinaryObject) {
            Trace.trace("/finer", "   Publishing binary module.");
            return this.handlePublishBinaryModule(module, archiveDestination, anyDeleted, publishType, (IProgressMonitor)subMonitor.split(1));
        }
        if (publishType == 2) {
            Trace.trace("/finer", "   Executing full publish on module.");
            ret = this.executeFullPublish(module, archiveDestination, filter, (IProgressMonitor)subMonitor.split(1));
            msgForFailure = Messages.FullPublishFail;
        } else if (publishType == 1) {
            Trace.trace("/finer", "   Executing incremental publish on module.");
            PublishModuleIncrementalRunner runner = new PublishModuleIncrementalRunner(this.getFilesystemController(), archiveDestination);
            IModuleResourceDelta[] cleanDelta = filter != null ? filter.getFilteredDelta(this.getDeltaForModule(module)) : this.getDeltaForModule(module);
            IModuleRestartBehaviorController moduleRestartController = this.getModuleRestartBehaviorController();
            if (moduleRestartController != null) {
                this.requiresRestart.put(module, moduleRestartController.moduleRequiresRestart(module, cleanDelta));
            }
            ret = runner.publish(cleanDelta, (IProgressMonitor)subMonitor.split(1));
            msgForFailure = Messages.IncrementalPublishFail;
        } else {
            this.requiresRestart.put(module, false);
        }
        MultiStatus acc = null;
        if (ret != null && ret.length > 0) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 1644298244, NLS.bind((String)msgForFailure, (Object)module[module.length - 1].getName()), null);
            int i = 0;
            while (i < ret.length) {
                if (ret[i] != null && !ret[i].isOK()) {
                    ms.add(ret[i]);
                }
                ++i;
            }
            acc = ms;
        }
        this.markModulePublished(module, publishType, (IStatus)acc, true);
        subMonitor.setWorkRemaining(0);
        return acc == null || acc.isOK() ? 1 : 0;
    }

    protected boolean treatAsBinaryModule(IModule[] module) {
        return this.isBinaryModule(module);
    }

    protected boolean isBinaryModule(IModule[] module) {
        return ServerModelUtilities.isBinaryModule((IModule[])module);
    }

    private int handlePublishBinaryModule(IModule[] module, IPath deployFolder, boolean anyDeleted, int publishType, IProgressMonitor monitor) throws CoreException {
        if (publishType == 0) {
            this.markModulePublished(module, 0, null, true);
            return 1;
        }
        IPath archDestinationWithNameSegment = this.getModuleDeployRoot(module, false);
        IFilesystemController fc = this.getFilesystemController();
        IModuleResource[] all = ModuleResourceUtil.getMembers((IModule)module[module.length - 1]);
        IModuleResourceDelta[] delta = this.getDeltaForModule(module);
        BinaryModulePublishRunner runner = new BinaryModulePublishRunner(module, deployFolder, archDestinationWithNameSegment, fc, all, delta);
        if (3 == publishType) {
            MultiStatus ms = null;
            ms = anyDeleted ? runner.removeDeletedBinaryModule(monitor) : runner.removeBinaryModule(monitor);
            int ret = ms.isOK() ? 1 : 3;
            this.markModulePublished(module, 3, (IStatus)ms, true);
            return ret;
        }
        if (1 == publishType) {
            boolean requiresRestart2 = this.getModuleRestartBehaviorController().moduleRequiresRestart(module, delta);
            MultiStatus ms = runner.publishModuleIncremental(monitor);
            int ret = ms.isOK() ? 1 : 3;
            this.requiresRestart.put(module, requiresRestart2);
            this.markModulePublished(module, 1, (IStatus)ms, true);
            return ret;
        }
        if (2 == publishType) {
            MultiStatus ms = runner.publishModuleFull(monitor);
            int ret = ms.isOK() ? 1 : 3;
            this.markModulePublished(module, 2, (IStatus)ms, true);
            return ret;
        }
        return 0;
    }

    protected IStatus[] executeFullPublish(IModule[] module, IPath archiveDestination, IModulePathFilter filter, IProgressMonitor monitor) throws CoreException {
        Server s = (Server)this.getServer();
        ArrayList kids = ServerModelUtilities.getDeepChildren((IServer)this.getServer(), (IModule[])module);
        Iterator it = kids.iterator();
        while (it.hasNext()) {
            s.setModulePublishState((IModule[])it.next(), 3);
        }
        PublishModuleFullRunner runner = new PublishModuleFullRunner(this.getFilesystemController(), archiveDestination);
        IModuleResource[] filtered = filter == null ? ModuleResourceUtil.getMembers((IModule)module[module.length - 1]) : filter.getFilteredMembers();
        IStatus[] ret = runner.fullPublish(filtered, monitor);
        this.requiresRestart.put(module, true);
        return ret;
    }

    protected int removeModule(IModule[] module, IPath remote, IProgressMonitor monitor) throws CoreException {
        boolean error;
        if (module.length > 1) {
            return 1;
        }
        Trace.trace("/finer", "Handling an unpublish");
        IStatus results = this.getFilesystemController().deleteResource(remote, monitor);
        boolean bl = error = results != null && !results.isOK();
        if (error) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 0x62020006, NLS.bind((String)Messages.DeleteModuleFail, (Object)module[module.length - 1]), results.getException());
            ms.add(results);
            results = ms;
            Trace.trace("/finer", "Failed to delete deployment resource: " + remote.toOSString());
        } else {
            Trace.trace("/finer", "Deleted deployment resource: " + remote.toOSString());
        }
        this.markModulePublished(module, 3, results, true);
        return error ? 0 : 1;
    }

    private int handleZippedPublish(IModule[] module, int publishType, IPath archiveDestination, boolean force, IProgressMonitor monitor) throws CoreException {
        if (!force && module.length > 1) {
            return 1;
        }
        if (publishType == 3) {
            return this.removeModule(module, archiveDestination, monitor);
        }
        if (ServerModelUtilities.isAnyDeleted((IModule[])module)) {
            Trace.trace("/finer", "Handling a wtp 'deleted module' (aka missing/deleted /closed project). No Action Taken. Returning state=unknown ");
            return 0;
        }
        IPath localTempLocation = this.getMetadataTemporaryLocation(this.getServer());
        IPath tmpArchive = localTempLocation.append(archiveDestination.lastSegment());
        LocalZippedModulePublishRunner runner = this.createZippedRunner(module, tmpArchive);
        monitor.beginTask("Packaging Module", 200);
        IStatus result = null;
        boolean rebuiltFull = false;
        boolean rebuiltInc = false;
        if (publishType == 2) {
            rebuiltFull = true;
            result = runner.fullPublishModule(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
        } else {
            int childPublishType = runner.childPublishTypeRequired();
            if (childPublishType == 2) {
                rebuiltFull = true;
                result = runner.fullPublishModule(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
            } else if (publishType == 1 || childPublishType == 1) {
                rebuiltInc = true;
                result = runner.incrementalPublishModule(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
            }
        }
        if ((rebuiltFull || rebuiltInc) && (result == null || result.isOK())) {
            if (tmpArchive.toFile().exists()) {
                this.getFilesystemController().deleteResource(archiveDestination, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)10));
                result = this.getFilesystemController().copyFile(tmpArchive.toFile(), archiveDestination, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)90));
            } else {
                result = new Status(4, "org.jboss.ide.eclipse.as.core", "Zipped archive not found");
            }
        }
        boolean error = result != null && !result.isOK();
        int pubTypeRet = -1;
        if (rebuiltFull || rebuiltInc && module.length == 1) {
            pubTypeRet = 2;
        } else if (rebuiltInc) {
            IModuleRestartBehaviorController c = this.getModuleRestartBehaviorController();
            if (c != null && c.moduleRequiresRestart(module, new IModuleResource[0])) {
                pubTypeRet = 2;
            }
        } else {
            pubTypeRet = 0;
        }
        this.markModulePublished(module, pubTypeRet, result, true);
        return result == null || result.isOK() ? 1 : 0;
    }

    private boolean prefersZipped() throws CoreException {
        return this.getDeploymentOptions().prefersZippedDeployments();
    }

    protected IPath getModuleDeployRoot(IModule[] module) throws CoreException {
        return this.getModuleDeployRoot(module, this.treatAsBinaryModule(module));
    }

    protected IPath getModuleDeployRoot(IModule[] module, boolean isBinaryObject) throws CoreException {
        IDeploymentOptionsController opts = this.getDeploymentOptions();
        IModuleDeployPathController depPath = this.getDeployPathController();
        return new RemotePath(depPath.getDeployDirectory(module, isBinaryObject).toOSString(), opts.getPathSeparatorCharacter());
    }

    protected IModulePathFilterProvider getModulePathFilterProvider() {
        return new IModulePathFilterProvider(){

            public IModulePathFilter getFilter(IServer server, IModule[] module) {
                return ComponentModuleInclusionFilterUtility.findDefaultModuleFilter((IModule)module[module.length - 1]);
            }
        };
    }

    private void markModulePublished(IModule[] module, int type, IStatus result, boolean logError) {
        this.publishType.put(module, type);
        if (logError && result != null && !result.isOK()) {
            ServerLogger.getDefault().log(this.getServer(), result);
        }
        ModulePublishErrorCache.getDefault().setPublishErrorState(this.getServer(), module, type, result);
    }

    protected boolean forceZipModule(IModule[] moduleTree) {
        try {
            IDeploymentOptionsController doc = this.getDeploymentOptions();
            if (doc instanceof IDeploymentZipOptionsController) {
                return ((IDeploymentZipOptionsController)doc).shouldZipDeployment(moduleTree);
            }
        }
        catch (CoreException ce) {
            JBossServerCorePlugin.log(ce);
        }
        return PublishUtil.deployPackaged(moduleTree, this.getServer());
    }

    private boolean parentModuleIsForcedZip(IModule[] moduleTree) {
        ArrayList<IModule> tmp = new ArrayList<IModule>(Arrays.asList(moduleTree));
        tmp.remove(tmp.size() - 1);
        while (!tmp.isEmpty()) {
            IModule[] tmpArray = tmp.toArray(new IModule[tmp.size()]);
            if (this.forceZipModule(tmpArray)) {
                return true;
            }
            tmp.remove(tmp.size() - 1);
        }
        return false;
    }

    private IPath getMetadataTemporaryLocation(IServer server) {
        IPath deployRoot = JBossServerCorePlugin.getServerStateLocation(server).append("tempRemoteDeploy").makeAbsolute();
        deployRoot.toFile().mkdirs();
        return deployRoot;
    }

    public void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        this.validate();
    }

    protected void ensureModulesRestarted() {
        List<IModule> top = this.getTopLevelModules();
        for (IModule m : top) {
            if (this.moduleRequiresRestart(m)) {
                this.restartModule(m);
                continue;
            }
            if (!this.moduleRequiresRemovalCompletion(m)) continue;
            this.completeRemoval(m);
        }
    }

    protected boolean moduleRequiresRemovalCompletion(IModule m) {
        for (IModule[] mit : this.publishType.keySet()) {
            if (mit.length != 1 || !mit[0].equals(m) || this.publishType.get(mit) != 3) continue;
            return true;
        }
        return false;
    }

    protected void completeRemoval(IModule m) {
        try {
            boolean useAS7Behavior = this.supportsJBoss7Markers();
            if (useAS7Behavior) {
                IPath archiveDestination = this.getModuleDeployRoot(new IModule[]{m});
                IFilesystemController controller = this.getFilesystemController();
                DeploymentMarkerUtils.removeDoDeployMarker(archiveDestination, controller);
                DeploymentMarkerUtils.removeDeployedMarker(archiveDestination, controller);
                DeploymentMarkerUtils.removeDeployFailedMarker(archiveDestination, controller);
            }
        }
        catch (CoreException ce) {
            JBossServerCorePlugin.log(ce);
        }
    }

    protected boolean supportsJBoss7Markers() {
        return DeploymentMarkerUtils.supportsJBoss7MarkerDeployment(this.getServer());
    }

    protected void restartModule(IModule m) {
        try {
            IPath archiveDestination = this.getModuleDeployRoot(new IModule[]{m});
            IFilesystemController controller = this.getFilesystemController();
            boolean useAS7Behavior = this.supportsJBoss7Markers();
            if (!useAS7Behavior) {
                JSTPublisherXMLToucher.getInstance().touch(archiveDestination, m, controller);
            } else {
                DeploymentMarkerUtils.removeDeployedMarker(archiveDestination, controller);
                DeploymentMarkerUtils.removeDeployFailedMarker(archiveDestination, controller);
                DeploymentMarkerUtils.createDoDeployMarker(archiveDestination, controller);
            }
        }
        catch (CoreException ce) {
            JBossServerCorePlugin.log(ce);
        }
    }

    private List<IModule> getTopLevelModules() {
        ArrayList<IModule> collector = new ArrayList<IModule>();
        for (IModule[] m : this.publishType.keySet()) {
            if (collector.contains(m[0])) continue;
            collector.add(m[0]);
        }
        return collector;
    }

    protected boolean shouldMinimizeRedeployments() {
        boolean debugMode = "debug".equals(this.getServer().getMode());
        Object o = this.getControllableBehavior().getSharedData("AbstractStartJavaServerLaunchDelegate.HotCodeReplaceOverridden");
        return debugMode && o instanceof Boolean && (Boolean)o != false;
    }

    protected boolean moduleRequiresRestart(IModule m) {
        boolean minimizeRedeployments = this.shouldMinimizeRedeployments();
        for (IModule[] fromMap : this.publishType.keySet()) {
            boolean isRemovedChild;
            int type;
            if (minimizeRedeployments) {
                if (fromMap.length != 1 || fromMap[0] != m) continue;
                type = this.publishType.get(fromMap);
                return type == 2;
            }
            if (fromMap.length <= 0 || fromMap[0] != m) continue;
            type = this.publishType.get(fromMap);
            Boolean t = this.requiresRestart.get(fromMap);
            boolean matchesPattern = t != null && t != false;
            boolean bl = isRemovedChild = fromMap.length > 1 && type == 3;
            if (!matchesPattern && type != 2 && !isRemovedChild) continue;
            return true;
        }
        return false;
    }

    protected LocalZippedModulePublishRunner createZippedRunner(IModule m, IPath p) {
        return this.createZippedRunner(new IModule[]{m}, p);
    }

    protected LocalZippedModulePublishRunner createZippedRunner(IModule[] m, IPath p) {
        return new LocalZippedModulePublishRunner(this.getServer(), m, p, this.getModulePathFilterProvider());
    }

    protected IModuleResourceDelta[] getDeltaForModule(IModule[] module) {
        IModuleResourceDelta[] deltas = ((Server)this.getServer()).getPublishedResourceDelta(module);
        return deltas;
    }

    public int transferBuiltModule(IModule[] module, IPath srcFile, IProgressMonitor monitor) throws CoreException {
        IPath archiveDestination = this.getModuleDeployRoot(module);
        IStatus result = this.getFilesystemController().copyFile(srcFile.toFile(), archiveDestination, monitor);
        boolean error = result != null && !result.isOK();
        this.markModulePublished(module, 2, result, true);
        return error ? 0 : 1;
    }

    public int removeModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        IPath archiveDestination = this.getModuleDeployRoot(module);
        return this.removeModule(module, archiveDestination, monitor);
    }
}

