/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.jmx.integration;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Properties;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

public class JMXUtil {
    public static void setCredentials(IServer server) throws CredentialException {
        String user = ServerConverter.getJBossServer((IServer)server).getUsername();
        String pass = ServerConverter.getJBossServer((IServer)server).getPassword();
        JMXUtil.setCredentials(server, user, pass);
    }

    public static void setCredentials(IServer server, Object principal, Object credential) throws CredentialException {
        Exception temp = null;
        try {
            Class<?> simplePrincipal = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.security.SimplePrincipal");
            Class<?> securityAssoc = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.security.SecurityAssociation");
            securityAssoc.getMethods();
            Constructor<?> newSimplePrincipal = simplePrincipal.getConstructor(String.class);
            Object newPrincipalInstance = newSimplePrincipal.newInstance(principal);
            Method setPrincipalMethod = securityAssoc.getMethod("setPrincipal", Principal.class);
            setPrincipalMethod.invoke(null, newPrincipalInstance);
            Method setCredentialMethod = securityAssoc.getMethod("setCredential", Object.class);
            setCredentialMethod.invoke(null, credential);
        }
        catch (ClassNotFoundException e) {
            temp = e;
        }
        catch (SecurityException e) {
            temp = e;
        }
        catch (NoSuchMethodException e) {
            temp = e;
        }
        catch (IllegalArgumentException e) {
            temp = e;
        }
        catch (InstantiationException e) {
            temp = e;
        }
        catch (IllegalAccessException e) {
            temp = e;
        }
        catch (InvocationTargetException e) {
            temp = e;
        }
        if (temp != null) {
            throw new CredentialException(temp);
        }
    }

    public static Properties getDefaultProperties(IServer server) {
        IJBossServer jbs = ServerConverter.getJBossServer((IServer)server);
        Properties props = new Properties();
        if (jbs != null) {
            int port = jbs.getJNDIPort();
            props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            props.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            props.put("java.naming.provider.url", "jnp://" + jbs.getHost() + ":" + port);
            props.put("jnp.disableDiscovery", new Boolean(true));
        }
        return props;
    }

    public static class CredentialException
    extends Exception {
        private static final long serialVersionUID = 1L;
        protected Exception wrapped;

        public CredentialException(Exception wrapped) {
            this.wrapped = wrapped;
        }

        public Exception getWrapped() {
            return this.wrapped;
        }
    }
}

