/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.management.core;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7DeploymentResult;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.IncrementalDeploymentManagerService;
import org.jboss.ide.eclipse.as.management.core.IncrementalManagementModel;
import org.jboss.ide.eclipse.as.management.core.JBoss7DeploymentState;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.jboss.ide.eclipse.as.management.core.JBoss7ServerState;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class JBoss7ManagerServiceProxy
extends ServiceTracker<IJBoss7ManagerService, IJBoss7ManagerService>
implements IJBoss7ManagerService,
IncrementalDeploymentManagerService {
    private String serviceVersion;

    public JBoss7ManagerServiceProxy(BundleContext context, String serviceVersion) throws InvalidSyntaxException {
        super(context, context.createFilter(MessageFormat.format("(&(objectClass={0})(as.version={1}))", IJBoss7ManagerService.class.getCanonicalName(), serviceVersion)), null);
        this.serviceVersion = serviceVersion;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    @Override
    public void init() throws JBoss7ManangerException {
        this.checkedGetService().init();
    }

    @Override
    public IJBoss7DeploymentResult deployAsync(IAS7ManagementDetails details, String deploymentName, File file, boolean add, IProgressMonitor monitor) throws JBoss7ManangerException {
        return this.checkedGetService().deployAsync(details, deploymentName, file, add, monitor);
    }

    @Override
    public IJBoss7DeploymentResult deploySync(IAS7ManagementDetails details, String deploymentName, File file, boolean add, IProgressMonitor monitor) throws JBoss7ManangerException {
        return this.checkedGetService().deploySync(details, deploymentName, file, add, monitor);
    }

    @Override
    public IJBoss7DeploymentResult undeployAsync(IAS7ManagementDetails details, String deploymentName, boolean removeFile, IProgressMonitor monitor) throws JBoss7ManangerException {
        return this.checkedGetService().undeployAsync(details, deploymentName, removeFile, monitor);
    }

    @Override
    public IJBoss7DeploymentResult undeploySync(IAS7ManagementDetails details, String deploymentName, boolean removeFile, IProgressMonitor monitor) throws JBoss7ManangerException {
        return this.checkedGetService().undeploySync(details, deploymentName, removeFile, monitor);
    }

    @Override
    public JBoss7DeploymentState getDeploymentState(IAS7ManagementDetails details, String deploymentName) throws JBoss7ManangerException {
        return this.checkedGetService().getDeploymentState(details, deploymentName);
    }

    @Override
    public JBoss7ServerState getServerState(IAS7ManagementDetails details) throws JBoss7ManangerException {
        return this.checkedGetService().getServerState(details);
    }

    @Override
    public boolean isRunning(IAS7ManagementDetails details) throws JBoss7ManangerException {
        try {
            return this.checkedGetService().isRunning(details);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void stop(IAS7ManagementDetails details) throws JBoss7ManangerException {
        this.checkedGetService().stop(details);
    }

    @Override
    public String execute(IAS7ManagementDetails details, String request) throws JBoss7ManangerException {
        return this.checkedGetService().execute(details, request);
    }

    private IJBoss7ManagerService checkedGetService() throws JBoss7ManangerException {
        IJBoss7ManagerService service = (IJBoss7ManagerService)this.getService();
        if (service == null) {
            throw new JBoss7ManangerException("Could not acquire JBoss Management service version " + this.serviceVersion);
        }
        return service;
    }

    @Override
    public void dispose() {
        IJBoss7ManagerService service = (IJBoss7ManagerService)this.getService();
        if (service != null) {
            service.dispose();
        }
        this.close();
    }

    @Override
    public IJBoss7DeploymentResult addDeployment(IAS7ManagementDetails details, String deploymentName, File file, IProgressMonitor monitor) throws JBoss7ManangerException {
        return this.checkedGetService().addDeployment(details, deploymentName, file, monitor);
    }

    @Override
    public IJBoss7DeploymentResult removeDeployment(IAS7ManagementDetails details, String deploymentName, IProgressMonitor monitor) throws JBoss7ManangerException {
        return this.checkedGetService().removeDeployment(details, deploymentName, monitor);
    }

    @Override
    public IJBoss7DeploymentResult replaceDeployment(IAS7ManagementDetails details, String deploymentName, File file, IProgressMonitor monitor) throws JBoss7ManangerException {
        return this.checkedGetService().replaceDeployment(details, deploymentName, file, monitor);
    }

    @Override
    public boolean supportsIncrementalDeployment() {
        return this.checkedGetService().supportsIncrementalDeployment();
    }

    @Override
    public IJBoss7DeploymentResult incrementalPublish(IAS7ManagementDetails details, String deploymentName, IncrementalManagementModel model, boolean redeploy, IProgressMonitor monitor) throws JBoss7ManangerException {
        IJBoss7ManagerService serv = this.checkedGetService();
        if (serv instanceof IncrementalDeploymentManagerService) {
            return ((IncrementalDeploymentManagerService)serv).incrementalPublish(details, deploymentName, model, redeploy, monitor);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public IJBoss7DeploymentResult deploySync(IAS7ManagementDetails details, String deploymentName, File file, boolean add, String[] explodePaths, IProgressMonitor monitor) throws JBoss7ManangerException {
        IJBoss7ManagerService serv = this.checkedGetService();
        if (serv instanceof IncrementalDeploymentManagerService) {
            return ((IncrementalDeploymentManagerService)serv).deploySync(details, deploymentName, file, add, explodePaths, monitor);
        }
        throw new UnsupportedOperationException();
    }
}

