/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.management.core.service;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.ide.eclipse.as.management.core.AS7ManagementActivator;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7DeploymentResult;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.IncrementalDeploymentManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7DeploymentState;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.jboss.ide.eclipse.as.management.core.JBoss7ServerState;

public abstract class DelegatingManagerService
implements IJBoss7ManagerService {
    protected boolean hasLoggedError = false;

    protected abstract String getDelegateServiceId();

    protected IJBoss7ManagerService getDelegateService() {
        IJBoss7ManagerService service = JBoss7ManagerUtil.getManagerService(this.getDelegateServiceId());
        return service;
    }

    @Override
    public void init() throws JBoss7ManangerException {
        this.checkDelegate();
        this.getDelegateService().init();
    }

    @Override
    public IJBoss7DeploymentResult addDeployment(IAS7ManagementDetails details, String deploymentName, File file, IProgressMonitor monitor) throws JBoss7ManangerException {
        this.checkDelegate();
        return this.getDelegateService().addDeployment(details, deploymentName, file, monitor);
    }

    @Override
    public IJBoss7DeploymentResult removeDeployment(IAS7ManagementDetails details, String deploymentName, IProgressMonitor monitor) throws JBoss7ManangerException {
        this.checkDelegate();
        return this.getDelegateService().removeDeployment(details, deploymentName, monitor);
    }

    @Override
    public IJBoss7DeploymentResult replaceDeployment(IAS7ManagementDetails details, String deploymentName, File file, IProgressMonitor monitor) throws JBoss7ManangerException {
        this.checkDelegate();
        return this.getDelegateService().replaceDeployment(details, deploymentName, file, monitor);
    }

    @Override
    public IJBoss7DeploymentResult deployAsync(IAS7ManagementDetails details, String deploymentName, File file, boolean add, IProgressMonitor monitor) throws JBoss7ManangerException {
        this.checkDelegate();
        return this.getDelegateService().deployAsync(details, deploymentName, file, add, monitor);
    }

    @Override
    public IJBoss7DeploymentResult undeployAsync(IAS7ManagementDetails details, String deploymentName, boolean removeFile, IProgressMonitor monitor) throws JBoss7ManangerException {
        this.checkDelegate();
        return this.getDelegateService().undeployAsync(details, deploymentName, removeFile, monitor);
    }

    @Override
    public IJBoss7DeploymentResult deploySync(IAS7ManagementDetails details, String deploymentName, File file, boolean add, IProgressMonitor monitor) throws JBoss7ManangerException {
        this.checkDelegate();
        return this.getDelegateService().deploySync(details, deploymentName, file, add, monitor);
    }

    @Override
    public IJBoss7DeploymentResult undeploySync(IAS7ManagementDetails details, String deploymentName, boolean removeFile, IProgressMonitor monitor) throws JBoss7ManangerException {
        this.checkDelegate();
        return this.getDelegateService().undeploySync(details, deploymentName, removeFile, monitor);
    }

    @Override
    public JBoss7DeploymentState getDeploymentState(IAS7ManagementDetails details, String deploymentName) throws JBoss7ManangerException {
        this.checkDelegate();
        return this.getDelegateService().getDeploymentState(details, deploymentName);
    }

    @Override
    public JBoss7ServerState getServerState(IAS7ManagementDetails details) throws JBoss7ManangerException {
        this.checkDelegate();
        return this.getDelegateService().getServerState(details);
    }

    @Override
    public boolean isRunning(IAS7ManagementDetails details) throws JBoss7ManangerException {
        return this.getDelegateService().isRunning(details);
    }

    @Override
    public void stop(IAS7ManagementDetails details) throws JBoss7ManangerException {
        this.checkDelegate();
        this.getDelegateService().stop(details);
    }

    @Override
    public String execute(IAS7ManagementDetails details, String request) throws JBoss7ManangerException {
        this.checkDelegate();
        return this.getDelegateService().execute(details, request);
    }

    @Override
    public void dispose() {
        this.checkDelegate();
        this.getDelegateService().dispose();
    }

    protected void checkDelegate() throws JBoss7ManangerException {
        IJBoss7ManagerService del = this.getDelegateService();
        if (del == null) {
            JBoss7ManangerException ex = new JBoss7ManangerException("Unable to locate delegate management service with as.version=" + this.getDelegateServiceId());
            if (!this.hasLoggedError) {
                AS7ManagementActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.management.core", ex.getMessage(), (Throwable)ex));
                this.hasLoggedError = true;
            }
            throw ex;
        }
    }

    @Override
    public boolean supportsIncrementalDeployment() {
        return this.getDelegateService() instanceof IncrementalDeploymentManagerService;
    }
}

