/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.Trace;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.rse.core.RSEUtils;
import org.jboss.ide.eclipse.as.rse.core.util.RemoteCallWrapperUtility;

public class RSEFrameworkUtils {
    protected static List<String> APPROVED_FILE_SYSTEMS = Arrays.asList("ftp.files", "local.files", "ssh.files", "dstore.files");

    public static IHost findHost(String connectionName) {
        IHost[] allHosts = RSECorePlugin.getTheSystemRegistry().getHosts();
        return RSEFrameworkUtils.findHost(connectionName, allHosts);
    }

    public static IHost findHost(String connectionName, IHost[] hosts) {
        int i = 0;
        while (i < hosts.length) {
            if (hosts[i].getAliasName().equals(connectionName)) {
                return hosts[i];
            }
            ++i;
        }
        return null;
    }

    public static void waitForFullInit() throws CoreException {
        try {
            RSECorePlugin.waitForInitCompletion();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", "The RSE model initialization has been interrupted."));
        }
    }

    public static boolean isHostWindows(IHost host) {
        String sysType = host.getSystemType().getId();
        if (sysType.equals("org.eclipse.rse.systemtype.windows")) {
            return true;
        }
        ISubSystem[] systems = RSECorePlugin.getTheSystemRegistry().getSubSystems(host);
        int i = 0;
        while (i < systems.length) {
            if (systems[i].getConfigurationId().equals("dstore.windows.files")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IFileServiceSubSystem findFileTransferSubSystem(IHost host) {
        ISubSystem[] systems = RSECorePlugin.getTheSystemRegistry().getSubSystems(host);
        int i = 0;
        while (i < systems.length) {
            if (APPROVED_FILE_SYSTEMS.contains(systems[i].getConfigurationId())) {
                return (IFileServiceSubSystem)systems[i];
            }
            ++i;
        }
        return null;
    }

    public static IShellService findHostShellSystem(IHost host) {
        ISubSystem[] systems = RSECorePlugin.getTheSystemRegistry().getSubSystems(host);
        int i = 0;
        while (i < systems.length) {
            if (systems[i] instanceof IShellServiceSubSystem) {
                IShellService service = ((IShellServiceSubSystem)systems[i]).getShellService();
                return service;
            }
            ++i;
        }
        return null;
    }

    public static IStatus ensureActiveConnection(IServer server, final IFileServiceSubSystem fileSubSystem, IProgressMonitor monitor) {
        monitor.beginTask("Verifying connectivity to remote server", 200);
        Exception caught = null;
        Trace.trace((String)"/finer", (String)("Ensuring connection to remote server for server " + server.getName()));
        if (fileSubSystem != null && !fileSubSystem.isConnected()) {
            try {
                fileSubSystem.connect(ProgressMonitorUtil.getSubMon((IProgressMonitor)monitor, (int)100), false);
            }
            catch (Exception e) {
                Trace.trace((String)"/finer", (String)("Exception connecting to remote server: " + e.getMessage()));
                caught = e;
            }
        }
        boolean isConnected = fileSubSystem != null && fileSubSystem.isConnected();
        String connectionName = RSEUtils.getRSEConnectionName((IServerAttributes)server);
        if (isConnected) {
            RemoteCallWrapperUtility.NamedRunnableWithProgress run = new RemoteCallWrapperUtility.NamedRunnableWithProgress("Accessing Remote System Root"){

                public Object run(IProgressMonitor monitor) throws CoreException, SystemMessageException, RuntimeException {
                    fileSubSystem.getFileService().getRoots(monitor);
                    return Status.OK_STATUS;
                }
            };
            IProgressMonitor childMonitor = ProgressMonitorUtil.getSubMon((IProgressMonitor)monitor, (int)100);
            Exception e = RemoteCallWrapperUtility.wrapRemoteCallStatusTimeLimit(server, run, "null", null, 15000, childMonitor);
            if (e == null) {
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.rse.core", 1644298251, "The remote server " + connectionName + " is currently not responding to file system requests.", (Throwable)e);
        }
        return new Status(4, "org.eclipse.rse.core", 1644298251, "Unable to communicate with remote connection: " + connectionName, (Throwable)caught);
    }
}

