/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.ILaunchConfigConfigurator;
import org.jboss.ide.eclipse.as.core.server.IManagementPortProvider;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossAS7ExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.ArgsUtil;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.rse.core.RSELaunchConfigProperties;
import org.jboss.ide.eclipse.as.rse.core.RSEUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerTCPIPMonitorUtil;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;

public class RSEJBoss7LaunchConfigurator
implements ILaunchConfigConfigurator {
    private IJBossServer jbossServer;

    public RSEJBoss7LaunchConfigurator(IServer server) throws CoreException {
        this.jbossServer = ServerConverter.checkedGetJBossServer((IServer)server);
    }

    public void configure(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        RSELaunchConfigProperties propertyUtil = new RSELaunchConfigProperties();
        boolean detectStartupCommand = propertyUtil.isDetectStartupCommand((ILaunchConfiguration)launchConfig, true);
        String currentStartupCmd = propertyUtil.getStartupCommand((ILaunchConfiguration)launchConfig);
        String defaultStartup = this.getLaunchCommand((JBossServer)this.jbossServer);
        propertyUtil.setDefaultStartupCommand(defaultStartup, launchConfig);
        String defaultDebugStartup = this.getLaunchDebugCommand((JBossServer)this.jbossServer);
        if (detectStartupCommand || !this.isSet(currentStartupCmd)) {
            propertyUtil.setStartupCommand(defaultStartup, launchConfig);
            propertyUtil.setDebugStartupCommand(defaultDebugStartup, launchConfig);
        }
        boolean detectShutdownCommand = propertyUtil.isDetectShutdownCommand((ILaunchConfiguration)launchConfig, true);
        String currentShutdownCmd = propertyUtil.getShutdownCommand((ILaunchConfiguration)launchConfig);
        String defaultShutdownCommand = this.getDefaultShutdownCommand(this.jbossServer.getServer());
        propertyUtil.setDefaultShutdownCommand(defaultShutdownCommand, launchConfig);
        if (detectShutdownCommand || !this.isSet(currentShutdownCmd)) {
            propertyUtil.setShutdownCommand(defaultShutdownCommand, launchConfig);
        }
    }

    protected String getDefaultShutdownCommand(IServer server) throws CoreException {
        String rseHome = RSEUtils.getRSEHomeDir((IServerAttributes)server);
        IPath p = new Path(rseHome).append("bin");
        String ret = String.valueOf(p.toString()) + "/" + this.getManagementScript(server);
        boolean exposeManagement = LaunchCommandPreferences.exposesManagement((IServerAttributes)server);
        if (exposeManagement) {
            String host = server.getHost();
            ServerDelegate sd = (ServerDelegate)server.loadAdapter(ServerDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            int defPort = 9999;
            int port = sd instanceof IManagementPortProvider ? ((IManagementPortProvider)sd).getManagementPort() : defPort;
            String host2 = ServerTCPIPMonitorUtil.getHostFor((String)host, (int)port);
            int port2 = ServerTCPIPMonitorUtil.getPortFor((String)host, (int)port);
            ret = String.valueOf(ret) + " --controller=" + host2 + ":" + port2;
        }
        ret = String.valueOf(ret) + " --connect command=:shutdown";
        return ret;
    }

    protected String getManagementScript(IServer server) {
        JBossExtendedProperties props = (JBossExtendedProperties)server.loadAdapter(JBossExtendedProperties.class, null);
        if (props instanceof JBossAS7ExtendedProperties) {
            return ((JBossAS7ExtendedProperties)props).getJBossAdminScript();
        }
        return "jboss-admin.sh";
    }

    protected JBossExtendedProperties getExtendedProperties() {
        JBossExtendedProperties props = (JBossExtendedProperties)this.jbossServer.getServer().loadAdapter(JBossExtendedProperties.class, (IProgressMonitor)new NullProgressMonitor());
        return props;
    }

    protected String getArgsOverrideHost(IServer server, String preArgs) {
        if (!this.getExtendedProperties().runtimeSupportsBindingToAllInterfaces()) {
            return preArgs;
        }
        String host = server.getHost();
        if (LaunchCommandPreferences.listensOnAllHosts((IServerAttributes)this.jbossServer.getServer())) {
            host = "0.0.0.0";
        }
        return ArgsUtil.setArg((String)preArgs, (String)"-b", null, (String)host);
    }

    protected String getArgsOverrideConfigFile(IServer server, String preArgs) {
        String rseConfigFile = server.getAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerConfig", "standalone.xml");
        String programArguments = ArgsUtil.setArg((String)preArgs, null, (String)"--server-config", (String)rseConfigFile);
        return programArguments;
    }

    protected String getArgsOverrideBaseDir(IServer server, String preArgs) {
        Character c = Character.valueOf(RSEUtils.getRemoteSystemSeparatorCharacter((IServerAttributes)server));
        String basedir = RSEUtils.getBaseDirectory((IServerAttributes)server, c.charValue());
        String programArguments = ArgsUtil.setArg((String)preArgs, null, (String)"-Djboss.server.base.dir", (String)basedir);
        return programArguments;
    }

    protected String getArgsOverrideExposedManagement(IServer server, String preArgs) {
        boolean overrides = LaunchCommandPreferences.exposesManagement((IServerAttributes)server);
        if (overrides) {
            String newVal = overrides ? server.getHost() : null;
            String vmArguments = ArgsUtil.setArg((String)preArgs, null, (String)"-Djboss.bind.address.management", (String)newVal);
            return vmArguments;
        }
        return preArgs;
    }

    protected String getLaunchCommand(JBossServer jbossServer) throws CoreException {
        String programArguments = this.getLaunchProgramArgs();
        String vmArguments = this.getLaunchVMArgs();
        String jar = this.getJar(jbossServer.getServer());
        String command = "java " + vmArguments + " -jar " + jar + " " + programArguments + "&";
        return command;
    }

    protected String getLaunchDebugCommand(JBossServer jbossServer) throws CoreException {
        String programArguments = this.getLaunchProgramArgs();
        String vmArguments = this.getLaunchVMArgs();
        String jar = this.getJar(jbossServer.getServer());
        String debugPort = this.getDebugPort();
        String debugArgs = "-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + debugPort + " -Xdebug ";
        String command = "java " + debugArgs + vmArguments + " -jar " + jar + " " + programArguments + "&";
        return command;
    }

    protected boolean attachDebugger() {
        Boolean b = this.jbossServer.getServer().getAttribute("org.jboss.ide.eclipse.as.core.server.launch.DebugLaunchConstants.ATTACH_DEBUGGER", true);
        return b;
    }

    protected String getDebugPort() {
        String dbugPort = this.jbossServer.getServer().getAttribute("org.jboss.ide.eclipse.as.core.server.launch.DebugLaunchConstants.DEBUG_PORT", new Integer(8787).toString());
        return dbugPort;
    }

    protected String getLaunchVMArgs() {
        String vmArguments = this.getDefaultVMArguments(this.jbossServer.getServer());
        vmArguments = this.getArgsOverrideExposedManagement(this.jbossServer.getServer(), vmArguments);
        return vmArguments;
    }

    protected String getLaunchProgramArgs() {
        String programArguments = this.getDefaultProgramArguments(this.jbossServer.getServer());
        programArguments = this.getArgsOverrideHost(this.jbossServer.getServer(), programArguments);
        programArguments = this.getArgsOverrideConfigFile(this.jbossServer.getServer(), programArguments);
        programArguments = this.getArgsOverrideBaseDir(this.jbossServer.getServer(), programArguments);
        return programArguments;
    }

    protected String getDefaultVMArguments(IServer server) {
        String rseHome = RSEUtils.getRSEHomeDir((IServerAttributes)server);
        RemotePath rp = new RemotePath(rseHome, this.getSeparatorCharacter(server));
        String ret = this.getExtendedProperties().getDefaultLaunchArguments().getStartDefaultVMArgs((IPath)rp);
        return ret;
    }

    protected String getDefaultProgramArguments(IServer server) {
        String rseHome = RSEUtils.getRSEHomeDir((IServerAttributes)server);
        RemotePath rp = new RemotePath(rseHome, this.getSeparatorCharacter(server));
        String ret = this.getExtendedProperties().getDefaultLaunchArguments().getStartDefaultProgramArgs((IPath)rp);
        return ret;
    }

    protected char getSeparatorCharacter(IServer server) {
        char sep = File.separatorChar;
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        if (beh != null) {
            try {
                IDeploymentOptionsController cont = (IDeploymentOptionsController)beh.getController("deploymentOptions");
                if (cont != null) {
                    sep = cont.getPathSeparatorCharacter();
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return sep;
    }

    protected String getJar(IServer server) {
        String rseHome = RSEUtils.getRSEHomeDir((IServerAttributes)server);
        return new Path(rseHome).append(this.getMainType()).toString();
    }

    protected String getMainType() {
        return "jboss-modules.jar";
    }

    private boolean isSet(String value) {
        return value != null;
    }
}

