/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.rse.core.RSEStreamsProxy;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.launch.ServerProcess;

public class RSEServerDummyProcess
extends ServerProcess {
    private RSEStreamsProxy proxy;
    private PipedOutputStream pipeOut;

    public RSEServerDummyProcess(IServer server, ILaunch launch, String label) {
        super(launch, server, label);
    }

    public void processComplete() {
        this.complete = true;
        if (this.pipeOut != null) {
            try {
                this.pipeOut.flush();
                this.pipeOut.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.fireTerminateEvent();
    }

    public IStreamsProxy getStreamsProxy() {
        block5: {
            if (this.proxy == null) {
                try {
                    PipedInputStream sysout = new PipedInputStream();
                    this.pipeOut = new PipedOutputStream(sysout);
                    this.proxy = new RSEStreamsProxy(sysout, null, null, null);
                }
                catch (IOException ioe) {
                    if (this.pipeOut == null) break block5;
                    try {
                        this.pipeOut.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.proxy;
    }

    public synchronized void appendToSysout(String[] lines) {
        if (this.pipeOut != null && !this.complete && lines != null) {
            int i = 0;
            while (i < lines.length) {
                try {
                    this.pipeOut.write(lines[i].getBytes());
                    this.pipeOut.write(System.lineSeparator().getBytes());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                ++i;
            }
        }
    }

    public void serverChanged(ServerEvent event) {
        ILaunch l;
        super.serverChanged(event);
        if (UnitedServerListener.serverSwitchesToState((ServerEvent)event, (int)4) && (l = this.getLaunch()) != null) {
            try {
                IDebugTarget dt;
                ILaunchConfiguration lc = l.getLaunchConfiguration();
                boolean skipLaunch = LaunchCommandPreferences.isIgnoreLaunchCommand((ILaunchConfiguration)lc);
                if (skipLaunch && (dt = l.getDebugTarget()).canDisconnect()) {
                    dt.disconnect();
                    this.fireTerminateEvent();
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public boolean canTerminate() {
        return !this.isTerminated() && this.getProcessId() != null;
    }

    private String getProcessId() {
        return (String)this.getControllableBehavior().getSharedData("DeployableServerBehavior.Process_ID");
    }

    private IControllableServerBehavior getControllableBehavior() {
        ServerBehaviourDelegate del;
        if (this.server != null && (del = (ServerBehaviourDelegate)this.server.loadAdapter(ServerBehaviourDelegate.class, null)) instanceof ControllableServerBehavior) {
            return (IControllableServerBehavior)del;
        }
        return null;
    }
}

